/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import net.sf.pizzacompiler.compiler.ConstType;
import net.sf.pizzacompiler.compiler.DoubleConst;
import net.sf.pizzacompiler.compiler.FloatConst;
import net.sf.pizzacompiler.compiler.IntConst;
import net.sf.pizzacompiler.compiler.LongConst;
import net.sf.pizzacompiler.compiler.Trail;
import net.sf.pizzacompiler.compiler.Type;

abstract class NumConst
extends Type.NumType
implements ConstType {
    NumConst(int n) {
        super(n);
        this.setSym(Type.classOfTag[n]);
    }

    public abstract int intValue();

    public abstract long longValue();

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract String stringValue();

    public String sourceRepr() {
        return this.stringValue();
    }

    boolean isConstant() {
        return true;
    }

    ConstType constValue() {
        return this;
    }

    public ConstType coerce(int n) {
        if (this.tag == n) {
            return this;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return new IntConst(n, this.intValue());
            }
            case 5: {
                return new LongConst(this.longValue());
            }
            case 6: {
                return new FloatConst(this.floatValue());
            }
            case 7: {
                return new DoubleConst(this.doubleValue());
            }
        }
        throw new InternalError();
    }

    public Type deconst() {
        return Type.typeOfTag[this.tag];
    }

    Trail subtype(Type type, Trail trail) {
        if (this == type) {
            return trail;
        }
        return Type.typeOfTag[this.tag].subtype(type, trail);
    }
}

