/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sf.pizzacompiler.compiler.AST;
import net.sf.pizzacompiler.compiler.Basic;
import net.sf.pizzacompiler.compiler.CompilerOutput;
import net.sf.pizzacompiler.compiler.ConstType;
import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.FunSymbol;
import net.sf.pizzacompiler.compiler.Mangle;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.Namer;
import net.sf.pizzacompiler.compiler.Report;
import net.sf.pizzacompiler.compiler.SourceReader;
import net.sf.pizzacompiler.compiler.Type;
import pizza.support.array;

class Pretty
implements Constants {
    static PrintStream out = System.out;
    static final int postfixPrec = 11;
    static final int prefixPrec = 10;
    static final int mulPrec = 9;
    static final int addPrec = 8;
    static final int shiftPrec = 7;
    static final int ordPrec = 6;
    static final int eqPrec = 5;
    static final int bitandPrec = 4;
    static final int bitxorPrec = 3;
    static final int bitorPrec = 2;
    static final int andPrec = 1;
    static final int orPrec = 0;
    static final int condPrec = -1;
    static final int assignPrec = -2;
    static final int noPrec = -3;
    static int width = 3;
    static int lmargin = 0;
    static int[] opprec = new int[32];

    static void align() {
        for (int i = 0; i < lmargin; ++i) {
            out.print(" ");
        }
    }

    static void indent() {
        lmargin += width;
    }

    static void undent() {
        lmargin -= width;
    }

    static void open(int n, int n2) {
        if (n2 < n) {
            out.print("(");
        }
    }

    static void close(int n, int n2) {
        if (n2 < n) {
            out.print(")");
        }
    }

    static void print(AST.TopLevel topLevel) {
        Pretty.printDefs(topLevel.defs);
    }

    static void printDefs(AST[] aSTArray) {
        for (int i = 0; i < aSTArray.length; ++i) {
            Pretty.printDef(aSTArray[i]);
            out.println();
        }
    }

    static void printDef(AST aST) {
        switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 2: {
                AST aST2 = ((AST.Package)aST).qualid;
                out.print("package ");
                Pretty.printExpr(aST2);
                out.println(";");
                break;
            }
            case 3: {
                AST aST3 = ((AST.Import)aST).qualid;
                out.print("import ");
                Pretty.printExpr(aST3);
                out.println(";");
                break;
            }
            case 4: {
                AST.ClassDef classDef = (AST.ClassDef)aST;
                AST[] aSTArray = classDef.defs;
                AST[] aSTArray2 = classDef.implementing;
                AST aST4 = classDef.extending;
                AST.TypeFormal[] typeFormalArray = classDef.typevars;
                int n = classDef.mods;
                Name name = classDef.name;
                out.print(Namer.modNames(n & 0xFFFFFDFF));
                if ((n & 0x200) != 0) {
                    out.print(String.valueOf("interface ").concat(String.valueOf(name)));
                    Pretty.printTypeVars(typeFormalArray);
                    if (aSTArray2.length > 0) {
                        out.print(" extends ");
                        Pretty.printExprs(aSTArray2);
                    }
                } else {
                    out.print(String.valueOf("class ").concat(String.valueOf(name)));
                    Pretty.printTypeVars(typeFormalArray);
                    if (aST4 != null) {
                        out.print(" extends ");
                        Pretty.printExpr(aST4);
                    }
                    if (aSTArray2.length > 0) {
                        out.print(" implements ");
                        Pretty.printExprs(aSTArray2);
                    }
                }
                Pretty.printClassBlock(aSTArray);
                break;
            }
            case 5: {
                AST.FunDef funDef = (AST.FunDef)aST;
                FunSymbol funSymbol = funDef.sym;
                AST[] aSTArray = funDef.stats;
                AST[] aSTArray3 = funDef.thrown;
                AST.VarDef[] varDefArray = funDef.params;
                AST aST5 = funDef.restype;
                int n = funDef.mods;
                Name name = funDef.name;
                out.print(Namer.modNames(n));
                if (name == Basic.initS && funSymbol != null && funSymbol.owner != null) {
                    out.print(Basic.shortName(Name.fromString(Mangle.unmangle(funSymbol.owner.fullName()))));
                } else {
                    if (aST5 != null) {
                        Pretty.printExpr(aST5);
                    }
                    out.print(String.valueOf(" ").concat(String.valueOf(name)));
                }
                out.print("(");
                Pretty.printExprs((AST[])array.asObject(varDefArray));
                out.print(")");
                if (aSTArray3.length > 0) {
                    out.print(" throws ");
                    Pretty.printExprs(aSTArray3);
                }
                if (aSTArray != null) {
                    out.print(" ");
                    Pretty.printBlock(aSTArray);
                    break;
                }
                out.print(";");
                break;
            }
            case 7: {
                AST.Poly poly = (AST.Poly)aST;
                AST aST6 = poly.def;
                AST.TypeFormal[] typeFormalArray = poly.typevars;
                Pretty.printTypeVars(typeFormalArray);
                out.print(" ");
                Pretty.printDef(aST6);
                break;
            }
            default: {
                Pretty.printStat(aST);
            }
        }
    }

    static void printBlock(AST[] aSTArray) {
        out.println("{");
        Pretty.indent();
        Pretty.printStats(aSTArray);
        Pretty.undent();
        Pretty.align();
        out.print("}");
    }

    static void printClassBlock(AST[] aSTArray) {
        out.println(" {");
        Pretty.indent();
        for (int i = 0; i < aSTArray.length; ++i) {
            Pretty.align();
            Pretty.printDef(aSTArray[i]);
            out.println();
        }
        Pretty.undent();
        Pretty.align();
        out.print("}");
    }

    static void printTypeVars(AST.TypeFormal[] typeFormalArray) {
        if (typeFormalArray.length > 0) {
            out.print("<");
            Pretty.printTypeVar(typeFormalArray[0]);
            for (int i = 1; i < typeFormalArray.length; ++i) {
                out.print(", ");
                Pretty.printTypeVar(typeFormalArray[i]);
            }
            out.print(">");
        }
    }

    static void printTypeVar(AST.TypeFormal typeFormal) {
        out.print(typeFormal.name);
        if (typeFormal.bounds.length > 0) {
            Pretty.printExpr(typeFormal.bounds[0]);
            for (int i = 1; i < typeFormal.bounds.length; ++i) {
                out.print("&");
                Pretty.printExpr(typeFormal.bounds[i]);
            }
        }
    }

    static void printStat(AST aST) {
        switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 8: {
                AST.Block block = (AST.Block)aST;
                int n = block.mods;
                AST[] aSTArray = block.stats;
                if ((n & 8) != 0) {
                    out.print("static ");
                }
                Pretty.printBlock(aSTArray);
                break;
            }
            case 4: {
                Pretty.printDef(aST);
                break;
            }
            case 6: {
                Pretty.printExpr(aST);
                out.print(";");
                break;
            }
            case 9: {
                AST.DoLoop doLoop = (AST.DoLoop)aST;
                AST aST2 = doLoop.body;
                AST aST3 = doLoop.cond;
                out.print("do ");
                Pretty.printStat(aST2);
                Pretty.align();
                out.print(" while (");
                Pretty.printExpr(aST3);
                out.print(");");
                break;
            }
            case 10: {
                AST.WhileLoop whileLoop = (AST.WhileLoop)aST;
                AST aST4 = whileLoop.body;
                AST aST5 = whileLoop.cond;
                out.print("while (");
                Pretty.printExpr(aST5);
                out.print(") ");
                Pretty.printStat(aST4);
                break;
            }
            case 11: {
                AST.ForLoop forLoop = (AST.ForLoop)aST;
                AST aST6 = forLoop.body;
                AST[] aSTArray = forLoop.step;
                AST aST7 = forLoop.cond;
                AST[] aSTArray2 = forLoop.init;
                out.print("for (");
                if (aSTArray2.length > 0) {
                    AST aST8 = aSTArray2[0];
                    switch (aST8.net$sf$pizzacompiler$compiler$AST$$tag) {
                        case 6: {
                            Pretty.printExpr(aSTArray2[0]);
                            block28: for (int i = 1; i < aSTArray2.length; ++i) {
                                AST aST9 = aSTArray2[i];
                                switch (aST9.net$sf$pizzacompiler$compiler$AST$$tag) {
                                    case 6: {
                                        AST.VarDef varDef = (AST.VarDef)aST9;
                                        AST aST10 = varDef.init;
                                        Name name = varDef.name;
                                        out.print(String.valueOf(String.valueOf(", ").concat(String.valueOf(name))).concat(String.valueOf(" = ")));
                                        Pretty.printExpr(aST10);
                                        continue block28;
                                    }
                                    default: {
                                        throw new InternalError();
                                    }
                                }
                            }
                            break;
                        }
                        default: {
                            Pretty.printExprs(aSTArray2);
                        }
                    }
                }
                out.print("; ");
                if (aST7 != null) {
                    Pretty.printExpr(aST7);
                }
                out.print("; ");
                Pretty.printExprs(aSTArray);
                out.print(") ");
                Pretty.printStat(aST6);
                break;
            }
            case 12: {
                AST.Labelled labelled = (AST.Labelled)aST;
                AST aST11 = labelled.body;
                Name name = labelled.label;
                out.print(String.valueOf(name).concat(String.valueOf(": ")));
                Pretty.printStat(aST11);
                break;
            }
            case 13: {
                AST.Switch switch_ = (AST.Switch)aST;
                AST.Case[] caseArray = switch_.cases;
                AST aST12 = switch_.selector;
                out.print("switch (");
                Pretty.printExpr(aST12);
                out.print(") {\n");
                Pretty.printStats((AST[])array.asObject(caseArray));
                Pretty.align();
                out.print("}");
                break;
            }
            case 14: {
                AST.Case case_ = (AST.Case)aST;
                AST[] aSTArray = case_.stats;
                AST aST13 = case_.pat;
                if (aST13 == null) {
                    out.print("default");
                } else {
                    out.print("case ");
                    Pretty.printExpr(aST13);
                }
                out.print(": \n");
                Pretty.indent();
                Pretty.printStats(aSTArray);
                Pretty.undent();
                Pretty.align();
                break;
            }
            case 15: {
                AST.Synchronized synchronized_ = (AST.Synchronized)aST;
                AST aST14 = synchronized_.body;
                AST aST15 = synchronized_.lock;
                out.print("synchronized (");
                Pretty.printExpr(aST15);
                out.print(") ");
                Pretty.printStat(aST14);
                break;
            }
            case 16: {
                AST.Try try_ = (AST.Try)aST;
                AST aST16 = try_.finalizer;
                AST.Catch[] catchArray = try_.catchers;
                AST aST17 = try_.body;
                out.print("try ");
                Pretty.printStat(aST17);
                out.print(" ");
                for (int i = 0; i < catchArray.length; ++i) {
                    Pretty.printStat(catchArray[i]);
                }
                if (aST16 == null) break;
                out.print(" finally ");
                Pretty.printStat(aST16);
                break;
            }
            case 17: {
                AST.Catch catch_ = (AST.Catch)aST;
                AST[] aSTArray = catch_.stats;
                AST.VarDef varDef = catch_.param;
                out.print(" catch (");
                Pretty.printExpr(varDef);
                out.print(") ");
                Pretty.printBlock(aSTArray);
                break;
            }
            case 18: {
                AST.Conditional conditional = (AST.Conditional)aST;
                AST aST18 = conditional.elsepart;
                AST aST19 = conditional.thenpart;
                AST aST20 = conditional.cond;
                out.print("if (");
                Pretty.printExpr(aST20);
                out.print(") ");
                Pretty.printStat(aST19);
                if (aST18 == null) break;
                out.print(" else ");
                Pretty.printStat(aST18);
                break;
            }
            case 19: {
                AST aST21 = ((AST.Exec)aST).expr;
                Pretty.printExpr(aST21);
                out.print(";");
                break;
            }
            case 20: {
                Name name = ((AST.Break)aST).label;
                out.print("break");
                if (name != null) {
                    out.print(String.valueOf(" ").concat(String.valueOf(name)));
                }
                out.print(";");
                if (aST.pos != 0) break;
                out.print(" // inserted for safety");
                break;
            }
            case 21: {
                Name name = ((AST.Continue)aST).label;
                out.print("continue");
                if (name != null) {
                    out.print(String.valueOf(" ").concat(String.valueOf(name)));
                }
                out.print(";");
                break;
            }
            case 22: {
                AST aST22 = ((AST.Return)aST).expr;
                out.print("return");
                if (aST22 != null) {
                    out.print(" ");
                    Pretty.printExpr(aST22);
                }
                out.print(";");
                break;
            }
            case 24: {
                AST aST23 = ((AST.Throw)aST).expr;
                out.print("throw ");
                Pretty.printExpr(aST23);
                out.print(";");
                if (aST.pos != 0) break;
                out.print(" // inserted for safety");
                break;
            }
            case 46: {
                AST.Assert assert_ = (AST.Assert)aST;
                AST aST24 = assert_.message;
                AST aST25 = assert_.expr;
                out.print("assert");
                out.print(" ");
                Pretty.printExpr(aST25);
                if (aST24 != null) {
                    out.print(" : ");
                    Pretty.printExpr(aST24);
                }
                out.print(";");
                break;
            }
            case 47: {
                out.print("// should be unreachable");
                break;
            }
            default: {
                Pretty.printExpr(aST);
            }
        }
    }

    static void printStats(AST[] aSTArray) {
        for (int i = 0; i < aSTArray.length; ++i) {
            Pretty.align();
            Pretty.printStat(aSTArray[i]);
            out.println();
        }
    }

    static void printExpr(AST aST, int n) {
        if (aST == null) {
            out.print("<NULL>");
            return;
        }
        switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 23: {
                AST aST2 = ((AST.Goto)aST).expr;
                out.print("goto ");
                Pretty.printExpr(aST2);
                out.print(";");
                break;
            }
            case 6: {
                AST.VarDef varDef = (AST.VarDef)aST;
                AST aST3 = varDef.init;
                AST aST4 = varDef.vartype;
                int n2 = varDef.mods;
                Name name = varDef.name;
                if (name == null) {
                    out.print("_");
                    break;
                }
                out.print(Namer.modNames(n2));
                Pretty.printExpr(aST4);
                out.print(String.valueOf(" ").concat(String.valueOf(name)));
                if (aST3 == null) break;
                out.print(" = ");
                Pretty.printExpr(aST3);
                break;
            }
            case 19: {
                AST aST5 = ((AST.Exec)aST).expr;
                Pretty.printExpr(aST5);
                break;
            }
            case 18: {
                AST.Conditional conditional = (AST.Conditional)aST;
                AST aST6 = conditional.elsepart;
                AST aST7 = conditional.thenpart;
                AST aST8 = conditional.cond;
                Pretty.open(n, -1);
                Pretty.printExpr(aST8, -1);
                out.print(" ? ");
                Pretty.printExpr(aST7, -1);
                out.print(" : ");
                Pretty.printExpr(aST6, -1);
                Pretty.close(n, -1);
                break;
            }
            case 25: {
                AST.Lambda lambda = (AST.Lambda)aST;
                AST[] aSTArray = lambda.stats;
                AST[] aSTArray2 = lambda.thrown;
                AST.VarDef[] varDefArray = lambda.params;
                AST aST9 = lambda.restype;
                Pretty.open(n, 10);
                out.print("fun (");
                Pretty.printExprs((AST[])array.asObject(varDefArray));
                out.print(") ");
                if (aSTArray2.length > 0) {
                    out.print("throws ");
                    Pretty.printExprs(aSTArray2);
                }
                if (aST9 != null) {
                    out.print(" -> ");
                    Pretty.printExpr(aST9);
                }
                out.print(" ");
                Pretty.printBlock(aSTArray);
                break;
            }
            case 26: {
                AST aST10 = ((AST.Seq)aST).body;
                out.print("seq ");
                Pretty.printStat(aST10);
                break;
            }
            case 27: {
                AST.Aggregate aggregate = (AST.Aggregate)aST;
                AST aST11 = aggregate.atype;
                AST[] aSTArray = aggregate.elems;
                if (aST11 != null) {
                    out.print("new ");
                    Pretty.printExpr(aST11, 11);
                }
                out.print("{");
                Pretty.printExprs(aSTArray);
                out.print("}");
                break;
            }
            case 28: {
                AST.Apply apply = (AST.Apply)aST;
                AST[] aSTArray = apply.args;
                AST aST12 = apply.fn;
                switch (aST12.net$sf$pizzacompiler$compiler$AST$$tag) {
                    case 39: {
                        Name name = ((AST.Self)aST12).name;
                        if (name == Basic.thisS) {
                            out.print(name);
                            break;
                        }
                        Pretty.printExpr(aST12, 11);
                        break;
                    }
                    default: {
                        Pretty.printExpr(aST12, 11);
                    }
                }
                out.print("(");
                Pretty.printExprs(aSTArray);
                out.print(")");
                break;
            }
            case 29: {
                AST.NewClass newClass = (AST.NewClass)aST;
                AST aST13 = newClass.def;
                AST[] aSTArray = newClass.args;
                AST aST14 = newClass.clazz;
                AST aST15 = newClass.encl;
                if (aST15 != null) {
                    Pretty.printExpr(aST15);
                    out.print(".");
                }
                out.print("new ");
                Pretty.printExpr(aST14);
                out.print("(");
                Pretty.printExprs(aSTArray);
                out.print(")");
                if (aST13 == null) break;
                Pretty.printClassBlock(((AST.ClassDef)aST13).defs);
                break;
            }
            case 30: {
                AST.NewArray newArray = (AST.NewArray)aST;
                AST[] aSTArray = newArray.dims;
                AST aST16 = newArray.elemtype;
                out.print("new ");
                int n3 = 0;
                AST aST17 = null;
                AST aST18 = aST16;
                while (aST18 != aST17) {
                    aST17 = aST18;
                    switch (aST18.net$sf$pizzacompiler$compiler$AST$$tag) {
                        case 42: {
                            AST aST19 = ((AST.ArrayTypeTerm)aST18).elemtype;
                            ++n3;
                            aST18 = aST19;
                        }
                    }
                }
                Pretty.printExpr(aST18);
                for (int i = 0; i < aSTArray.length; ++i) {
                    out.print("[");
                    Pretty.printExpr(aSTArray[i]);
                    out.print("]");
                }
                for (int i = 0; i < n3; ++i) {
                    out.print("[]");
                }
                break;
            }
            case 31: {
                AST.Assign assign = (AST.Assign)aST;
                AST aST20 = assign.rhs;
                AST aST21 = assign.lhs;
                Pretty.open(n, -3);
                Pretty.printExpr(aST21, -2);
                out.print(" = ");
                Pretty.printExpr(aST20, -2);
                Pretty.close(n, -3);
                break;
            }
            case 32: {
                AST.Assignop assignop = (AST.Assignop)aST;
                AST aST22 = assignop.rhs;
                AST aST23 = assignop.lhs;
                int n4 = assignop.opcode;
                Pretty.open(n, -3);
                Pretty.printExpr(aST23, -2);
                out.print(String.valueOf(String.valueOf(" ").concat(String.valueOf(Namer.opname[n4]))).concat(String.valueOf("= ")));
                Pretty.printExpr(aST22, -2);
                Pretty.close(n, -3);
                break;
            }
            case 33: {
                AST.Binop binop = (AST.Binop)aST;
                AST aST24 = binop.rhs;
                AST aST25 = binop.lhs;
                int n5 = binop.opcode;
                Pretty.open(n, opprec[n5]);
                Pretty.printExpr(aST25, opprec[n5]);
                out.print(String.valueOf(String.valueOf(" ").concat(String.valueOf(Namer.opname[n5]))).concat(String.valueOf(" ")));
                Pretty.printExpr(aST24, opprec[n5] + 1);
                Pretty.close(n, opprec[n5]);
                break;
            }
            case 34: {
                AST.Unop unop = (AST.Unop)aST;
                AST aST26 = unop.operand;
                int n6 = unop.opcode;
                int n7 = n6 >= 8 ? 11 : 10;
                Pretty.open(n, n7);
                if (n6 < 8) {
                    out.print(String.valueOf(Namer.opname[n6]).concat(String.valueOf(" ")));
                }
                Pretty.printExpr(aST26, n7);
                if (n6 >= 8) {
                    out.print(String.valueOf(" ").concat(String.valueOf(Namer.opname[n6])));
                }
                Pretty.close(n, n7);
                break;
            }
            case 35: {
                AST.Typeop typeop = (AST.Typeop)aST;
                AST aST27 = typeop.clazz;
                AST aST28 = typeop.expr;
                int n8 = typeop.opcode;
                if (n8 == 31) {
                    Pretty.open(n, 10);
                    out.print("(");
                    Pretty.printExpr(aST27, 11);
                    out.print(")");
                    Pretty.printExpr(aST28, 11);
                    Pretty.close(n, 10);
                    break;
                }
                Pretty.open(n, 6);
                Pretty.printExpr(aST28, 6);
                out.print(" instanceof ");
                Pretty.printExpr(aST27);
                Pretty.close(n, 6);
                break;
            }
            case 36: {
                AST.Index index = (AST.Index)aST;
                AST aST29 = index.index;
                AST aST30 = index.indexed;
                Pretty.printExpr(aST30, 11);
                out.print("[");
                Pretty.printExpr(aST29);
                out.print("]");
                break;
            }
            case 37: {
                AST.Select select = (AST.Select)aST;
                Name name = select.selector;
                AST aST31 = select.selected;
                Pretty.printExpr(aST31, 11);
                out.print(String.valueOf(".").concat(String.valueOf(name)));
                break;
            }
            case 38: {
                Name name = ((AST.Ident)aST).idname;
                out.print(name);
                break;
            }
            case 39: {
                AST.Self self = (AST.Self)aST;
                Name name = self.name;
                AST aST32 = self.encl;
                if (aST32 != null) {
                    Pretty.printExpr(aST32, 11);
                    out.print(".");
                }
                out.print(name);
                break;
            }
            case 40: {
                ConstType constType = ((AST.Literal)aST).value;
                out.print(constType.sourceRepr());
                break;
            }
            case 41: {
                int n9 = ((AST.TypeIdent)aST).tag;
                out.print(Type.classOfTag[n9].name);
                break;
            }
            case 42: {
                AST aST33 = ((AST.ArrayTypeTerm)aST).elemtype;
                Pretty.printExpr(aST33);
                out.print("[]");
                break;
            }
            case 43: {
                AST.FunTypeTerm funTypeTerm = (AST.FunTypeTerm)aST;
                AST[] aSTArray = funTypeTerm.thrown;
                AST[] aSTArray3 = funTypeTerm.argtypes;
                AST aST34 = funTypeTerm.restype;
                out.print("(");
                Pretty.printExprs(aSTArray3);
                out.print(") ");
                if (aSTArray != null) {
                    out.print(" throws ");
                    Pretty.printExprs(aSTArray);
                }
                out.print("->");
                Pretty.printExpr(aST34);
                break;
            }
            case 44: {
                AST.ParTypeTerm parTypeTerm = (AST.ParTypeTerm)aST;
                AST[] aSTArray = parTypeTerm.argtypes;
                AST aST35 = parTypeTerm.clazz;
                Pretty.printExpr(aST35);
                out.print("<");
                Pretty.printExprs(aSTArray);
                out.print(">");
                break;
            }
            case 45: {
                Pretty.printTypeVar((AST.TypeFormal)aST);
                break;
            }
            case 48: {
                out.print("(ERROR)");
                break;
            }
            default: {
                out.println(String.valueOf(String.valueOf("(UNKNOWN: ").concat(String.valueOf(aST))).concat(String.valueOf(")")));
            }
        }
    }

    static void printExpr(AST aST) {
        Pretty.printExpr(aST, -3);
    }

    static void printExprs(AST[] aSTArray) {
        if (aSTArray != null && aSTArray.length >= 1) {
            Pretty.printExpr(aSTArray[0]);
            for (int i = 1; i < aSTArray.length; ++i) {
                out.print(", ");
                Pretty.printExpr(aSTArray[i]);
            }
        }
    }

    static boolean isPrologue(AST aST) {
        switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    static void output(AST[] aSTArray, int n, AST.ClassDef classDef, SourceReader sourceReader, CompilerOutput compilerOutput) {
        try {
            OutputStream outputStream = compilerOutput.getSourceOutputStream(classDef.sym.sourcefile.toString(), classDef.sym.fullname.toString(), sourceReader, classDef.pos);
            if (outputStream == null) {
                return;
            }
            out = new PrintStream(new BufferedOutputStream(outputStream));
            for (int i = 0; i < n; ++i) {
                Pretty.printDef(aSTArray[i]);
                out.println();
            }
            Pretty.printDef(classDef);
            out.println();
            out.close();
        }
        catch (IOException iOException) {
            Report.error(0, String.valueOf(String.valueOf(String.valueOf("error while writing ").concat(String.valueOf(classDef.sym))).concat(String.valueOf(": "))).concat(String.valueOf(iOException)));
        }
    }

    static void output(AST.TopLevel topLevel, SourceReader sourceReader, CompilerOutput compilerOutput) {
        int n;
        Name name = Report.useSource(topLevel.sourcefile);
        for (n = 0; n < topLevel.defs.length && Pretty.isPrologue(topLevel.defs[n]); ++n) {
        }
        int n2 = n;
        while (n < topLevel.defs.length) {
            Pretty.output(topLevel.defs, n2, (AST.ClassDef)topLevel.defs[n], sourceReader, compilerOutput);
            ++n;
        }
        Report.useSource(name);
    }

    Pretty() {
    }

    static {
        Pretty.opprec[10] = 0;
        Pretty.opprec[11] = 1;
        Pretty.opprec[12] = 5;
        Pretty.opprec[13] = 5;
        Pretty.opprec[14] = 6;
        Pretty.opprec[15] = 6;
        Pretty.opprec[16] = 6;
        Pretty.opprec[17] = 6;
        Pretty.opprec[18] = 2;
        Pretty.opprec[19] = 3;
        Pretty.opprec[20] = 4;
        Pretty.opprec[21] = 7;
        Pretty.opprec[22] = 7;
        Pretty.opprec[23] = 7;
        Pretty.opprec[24] = 8;
        Pretty.opprec[25] = 8;
        Pretty.opprec[26] = 9;
        Pretty.opprec[27] = 9;
        Pretty.opprec[28] = 9;
    }
}

