/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import net.sf.pizzacompiler.compiler.Basic;
import net.sf.pizzacompiler.compiler.ClassSymbol;
import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.PackageSymbol;
import net.sf.pizzacompiler.compiler.Scope;
import net.sf.pizzacompiler.compiler.Type;
import net.sf.pizzacompiler.compiler.TypeSymbol;

public class Symbol
implements Constants {
    Symbol sym;
    Symbol shadowed = null;
    Symbol sibling = null;
    Scope scope = null;
    int kind;
    public int modifiers;
    public Name name;
    public Type type;
    public Symbol owner;
    static PackageSymbol emptyPackage;
    static ClassSymbol predefClass;
    static Symbol errSymbol;
    static Symbol sentinel;

    Symbol(int n, int n2, Name name, Type type, Symbol symbol) {
        this.kind = n;
        this.modifiers = n2;
        this.name = name;
        this.type = type;
        this.owner = symbol;
        this.sym = this;
    }

    public String toString() {
        return this.name.toString();
    }

    public Symbol next() {
        Symbol symbol = this.shadowed;
        while (symbol.scope != null && symbol.name != this.name) {
            symbol = symbol.shadowed;
        }
        return symbol;
    }

    public String location() {
        if (this.owner.name != null && this.owner.name != Basic.emptyS) {
            return String.valueOf(" in ").concat(String.valueOf(this.owner));
        }
        return "";
    }

    public boolean isLocal() {
        return this.owner.kind == 8 || this.owner.kind == 2 && this.owner.isLocal();
    }

    boolean isTypeVar() {
        return false;
    }

    public boolean isConstructor() {
        return this.name == Basic.initS;
    }

    public boolean isContinuation() {
        return (this.modifiers & 0x210000) == 0x210000;
    }

    public Symbol proxy(Name name) {
        Symbol symbol = new Symbol(0, 0, name, null, this.owner);
        symbol.sym = this;
        return symbol;
    }

    static Name formFullName(Name name, Symbol symbol) {
        if (symbol == null) {
            return name;
        }
        Name name2 = symbol.fullName();
        if (name2 == null || name2 == Basic.emptyS) {
            return name;
        }
        return name2.append(Basic.periodS).append(name);
    }

    public Name unmangledName() {
        return this.name;
    }

    public Name fullName() {
        return Symbol.formFullName(this.name, this.owner);
    }

    public TypeSymbol enclClass() {
        Symbol symbol = this;
        while ((symbol.kind & 3) == 0) {
            symbol = symbol.owner;
        }
        return (TypeSymbol)symbol;
    }

    public Symbol outermostClass() {
        Symbol symbol = this;
        Symbol symbol2 = null;
        while (symbol.kind != 1) {
            if (symbol.kind == 2) {
                symbol2 = symbol;
            }
            symbol = symbol.owner;
        }
        return symbol2;
    }

    boolean subclass(Symbol symbol) {
        throw new InternalError(String.valueOf("subclass ").concat(String.valueOf(this)));
    }

    int caseNum() {
        return this.modifiers >>> 22;
    }

    void setCaseNum(int n) {
        this.modifiers = this.modifiers & 0x3FFFFF | n << 22;
    }

    static void init() {
        emptyPackage = new PackageSymbol(Basic.emptyS, new Type.PackageType(), null);
        predefClass = new ClassSymbol(1, Basic.emptyS, emptyPackage);
        errSymbol = new Symbol(31, 9, Basic.errorS, Type.ErrType, emptyPackage);
        Symbol.errSymbol.shadowed = sentinel;
    }

    static {
        sentinel = new Symbol(0, 0, null, null, null);
    }
}

