/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.htmlcleaner;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.outerj.daisy.htmlcleaner.GeckoCorruptTagCleaner;
import org.outerj.daisy.htmlcleaner.HtmlCleanerTemplate;
import org.outerj.daisy.htmlcleaner.HtmlRepairer;
import org.outerj.daisy.htmlcleaner.MergeCharacterEventsHandler;
import org.outerj.daisy.htmlcleaner.NekoHtmlParser;
import org.outerj.daisy.htmlcleaner.StylingHtmlSerializer;
import org.outerj.daisy.xmlutil.SaxBuffer;

public class HtmlCleaner {
    private HtmlCleanerTemplate template;

    HtmlCleaner(HtmlCleanerTemplate template) {
        this.template = template;
    }

    public void clean(String somethingWhichLooksLikeHtml, OutputStream outputStream) throws Exception {
        NekoHtmlParser parser = new NekoHtmlParser();
        SaxBuffer buffer = parser.parse(GeckoCorruptTagCleaner.clean(somethingWhichLooksLikeHtml));
        StylingHtmlSerializer serializer = new StylingHtmlSerializer(this.template);
        serializer.setOutputStream(outputStream);
        HtmlRepairer repairer = new HtmlRepairer(this.template);
        repairer.clean(buffer, new MergeCharacterEventsHandler(serializer));
    }

    public byte[] cleanToByteArray(String somethingWhichLooksLikeHtml) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        this.clean(somethingWhichLooksLikeHtml, os);
        return os.toByteArray();
    }

    public String cleanToString(String somethingWhichLooksLikeHtml) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        this.clean(somethingWhichLooksLikeHtml, os);
        return os.toString("UTF-8");
    }
}

