/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.htmlcleaner;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.outerj.daisy.htmlcleaner.HtmlCleanerTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class HtmlCleanerFactory {
    private boolean handledCleanup = false;
    private boolean handledSerialization = false;
    HtmlCleanerTemplate template = new HtmlCleanerTemplate();

    public HtmlCleanerTemplate buildTemplate(InputSource is) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(is);
        document.normalize();
        Element docEl = document.getDocumentElement();
        if (!docEl.getLocalName().equals("htmlcleaner") || docEl.getNamespaceURI() != null) {
            throw new Exception("Htmlcleaner config file should have root elemnet 'htmlcleaner'.");
        }
        NodeList nodeList = docEl.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getNamespaceURI() == null && node.getLocalName().equals("cleanup")) {
                this.handleCleanupNode((Element)node);
                continue;
            }
            if (node.getNamespaceURI() == null && node.getLocalName().equals("serialization")) {
                this.handleSerializationNode((Element)node);
                continue;
            }
            throw new Exception("Error in htmlcleaner config: unexpected element: " + node.getNodeName());
        }
        this.template.initialize();
        return this.template;
    }

    private void handleCleanupNode(Element cleanupEl) throws Exception {
        if (this.handledCleanup) {
            throw new Exception("Error in htmlcleaner config: cleanup element is only allowed once");
        }
        this.handledCleanup = true;
        NodeList cleanupNodes = cleanupEl.getChildNodes();
        for (int k = 0; k < cleanupNodes.getLength(); ++k) {
            int z;
            String[] classes;
            Node node = cleanupNodes.item(k);
            if (!(node instanceof Element)) continue;
            if (node.getNamespaceURI() == null && node.getLocalName().equals("allowed-span-classes")) {
                classes = this.getClassChildren((Element)node);
                for (z = 0; z < classes.length; ++z) {
                    this.template.addAllowedSpanClass(classes[z]);
                }
                continue;
            }
            if (node.getNamespaceURI() == null && node.getLocalName().equals("allowed-div-classes")) {
                classes = this.getClassChildren((Element)node);
                for (z = 0; z < classes.length; ++z) {
                    this.template.addAllowedDivClass(classes[z]);
                }
                continue;
            }
            if (node.getNamespaceURI() == null && node.getLocalName().equals("allowed-para-classes")) {
                classes = this.getClassChildren((Element)node);
                for (z = 0; z < classes.length; ++z) {
                    this.template.addAllowedParaClass(classes[z]);
                }
                continue;
            }
            if (node.getNamespaceURI() == null && node.getLocalName().equals("allowed-pre-classes")) {
                classes = this.getClassChildren((Element)node);
                for (z = 0; z < classes.length; ++z) {
                    this.template.addAllowedPreClass(classes[z]);
                }
                continue;
            }
            if (node.getNamespaceURI() == null && node.getLocalName().equals("allowed-elements")) {
                this.handleAllowedElementsNode((Element)node);
                continue;
            }
            if (node.getNamespaceURI() == null && node.getLocalName().equals("img-alternate-src-attr")) {
                String name = ((Element)node).getAttribute("name");
                if (name.equals("")) {
                    throw new Exception("Error in htmlcleaner config: missing name attribute on img-alternate-src-attr");
                }
                this.template.setImgAlternateSrcAttr(name);
                continue;
            }
            throw new Exception("Error in htmlcleaner config: unexpected element " + node.getNodeName() + " inside " + cleanupEl.getNodeName());
        }
    }

    private String[] getClassChildren(Element element) throws Exception {
        ArrayList<String> classes = new ArrayList<String>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getNamespaceURI() == null && node.getLocalName().equals("class")) {
                Node text = node.getFirstChild();
                if (text instanceof Text) {
                    classes.add(((Text)text).getData());
                    continue;
                }
                throw new Exception("Error in htmlcleaner: element class does not have a text node child");
            }
            throw new Exception("Error in htmlcleaner config: unexpected element: " + node.getNodeName() + " as child of " + element.getNodeName());
        }
        return classes.toArray(new String[classes.size()]);
    }

    private void handleAllowedElementsNode(Element element) throws Exception {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getNamespaceURI() == null && node.getLocalName().equals("element")) {
                String name = ((Element)node).getAttribute("name");
                if (name.equals("")) {
                    throw new Exception("Error in htmlcleaner config: missing name attribute on 'element' element");
                }
                String[] attributes = this.getAttributeChildren((Element)node);
                this.template.addAllowedElement(name, attributes);
                continue;
            }
            throw new Exception("Error in htmlcleaner config: unexpected element: '" + node.getNodeName() + "' as child of " + element.getNodeName());
        }
    }

    private String[] getAttributeChildren(Element element) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getNamespaceURI() == null && node.getLocalName().equals("attribute")) {
                String name = ((Element)node).getAttribute("name");
                if (name.equals("")) {
                    throw new Exception("Error in htmlcleaner config: missing name attribute on attribute element");
                }
                names.add(name);
                continue;
            }
            throw new Exception("Error in htmlcleaner config: unexpected element: '" + node.getNodeName() + "' as child of " + element.getNodeName());
        }
        return names.toArray(new String[names.size()]);
    }

    private void handleSerializationNode(Element element) throws Exception {
        if (this.handledSerialization) {
            throw new Exception("Error in htmlcleaner config: serialization element is only allowed once");
        }
        this.handledSerialization = true;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getNamespaceURI() == null && node.getLocalName().equals("linewidth")) {
                String value = ((Element)node).getAttribute("value");
                if (value.equals("")) {
                    throw new Exception("Error in htmlcleaner config: missing value attribute on linewidth element.");
                }
                int intValue = Integer.parseInt(value);
                this.template.setMaxLineWidth(intValue);
                continue;
            }
            if (node.getNamespaceURI() == null && node.getLocalName().equals("elements")) {
                this.handleElementsNode((Element)node);
                continue;
            }
            throw new Exception("Error in htmlcleaner config: unexpected element '" + node.getNodeName() + "' as child of " + element.getNodeName());
        }
    }

    private void handleElementsNode(Element element) throws Exception {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || node.getNamespaceURI() != null || !node.getLocalName().equals("element")) continue;
            Element childEl = (Element)node;
            String name = childEl.getAttribute("name");
            if (name.equals("")) {
                throw new Exception("Error in htmlcleaner config: missing name attribute on 'element' element.");
            }
            String beforeOpenAttr = childEl.getAttribute("beforeOpen");
            String afterOpenAttr = childEl.getAttribute("afterOpen");
            String beforeCloseAttr = childEl.getAttribute("beforeClose");
            String afterCloseAttr = childEl.getAttribute("afterClose");
            int beforeOpen = 0;
            int afterOpen = 0;
            int beforeClose = 0;
            int afterClose = 0;
            if (!beforeOpenAttr.equals("")) {
                beforeOpen = Integer.parseInt(beforeOpenAttr);
            }
            if (!afterOpenAttr.equals("")) {
                afterOpen = Integer.parseInt(afterOpenAttr);
            }
            if (!beforeCloseAttr.equals("")) {
                beforeClose = Integer.parseInt(beforeCloseAttr);
            }
            if (!afterCloseAttr.equals("")) {
                afterClose = Integer.parseInt(afterCloseAttr);
            }
            boolean inline = "true".equals(childEl.getAttribute("inline"));
            this.template.addOutputElement(name, beforeOpen, afterOpen, beforeClose, afterClose, inline);
        }
    }
}

