/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.htmlcleaner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.outerj.daisy.htmlcleaner.HtmlCleanerTemplate;
import org.outerj.daisy.htmlcleaner.OutputElementDescriptor;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class StylingHtmlSerializer
implements ContentHandler {
    private Writer writer;
    private LineRenderer line;
    private StartElementInfo currentStartElement;
    private boolean inPreElement = false;
    private HtmlCleanerTemplate template;
    private OutputElementDescriptor dummy = new OutputElementDescriptor(0, 0, 0, 0, true);

    public StylingHtmlSerializer(HtmlCleanerTemplate template) {
        this.template = template;
    }

    public void setOutputStream(OutputStream outputStream) throws IOException {
        this.writer = new OutputStreamWriter(outputStream, "UTF-8");
        this.line = new LineRenderer();
        this.currentStartElement = null;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        try {
            this.line.flushLine(false);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.writePendingStartElement(false);
        this.line.writeText(this.escapeReservedCharacters(new String(ch, start, length)));
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.writePendingStartElement(false);
        this.currentStartElement = new StartElementInfo(localName, atts);
        if (localName.equals("pre")) {
            this.line.flushLine(false);
            OutputElementDescriptor descriptor = this.getElementDescriptor("pre");
            this.line.newLines(descriptor.getNewLinesBeforeOpenTag());
            this.inPreElement = true;
        }
    }

    public void writePendingStartElement(boolean empty) throws SAXException {
        if (this.currentStartElement != null) {
            String localName = this.currentStartElement.getLocalName();
            Attributes atts = this.currentStartElement.getAttrs();
            StringBuffer tag = new StringBuffer(localName.length() + 2 + atts.getLength() * 50);
            tag.append('<').append(localName);
            if (atts.getLength() > 0) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    tag.append(' ');
                    tag.append(atts.getLocalName(i));
                    tag.append("=\"");
                    tag.append(this.escapeAttribute(atts.getValue(i)));
                    tag.append('\"');
                }
            }
            if (empty) {
                tag.append("/>");
            } else {
                tag.append('>');
            }
            OutputElementDescriptor descriptor = this.getElementDescriptor(localName);
            if (!this.inPreElement) {
                this.line.newLines(descriptor.getNewLinesBeforeOpenTag());
            }
            this.line.writeStartTag(tag.toString(), descriptor);
            if (!this.inPreElement) {
                if (empty) {
                    this.line.newLines(descriptor.getNewLinesAfterCloseTag());
                } else {
                    this.line.newLines(descriptor.getNewLinesAfterOpenTag());
                }
            }
            if (localName.equals("pre")) {
                this.line.flushLine(false);
            }
            this.currentStartElement = null;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equals("pre")) {
            this.inPreElement = false;
        }
        if (this.currentStartElement != null) {
            this.writePendingStartElement(true);
        } else {
            String tag = "</" + localName + ">";
            OutputElementDescriptor descriptor = this.getElementDescriptor(localName);
            if (!this.inPreElement) {
                this.line.newLines(descriptor.getNewLinesBeforeCloseTag());
            }
            this.line.writeEndTag(tag, descriptor);
            if (!this.inPreElement) {
                this.line.newLines(descriptor.getNewLinesAfterCloseTag());
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    private OutputElementDescriptor getElementDescriptor(String localName) {
        OutputElementDescriptor descriptor = (OutputElementDescriptor)this.template.outputElementDescriptors.get(localName);
        if (descriptor != null) {
            return descriptor;
        }
        return this.dummy;
    }

    private String escapeAttribute(String value) {
        StringBuffer newValue = new StringBuffer(value.length() + 10);
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    newValue.append("&quot;");
                    continue block6;
                }
                case '<': {
                    newValue.append("&lt;");
                    continue block6;
                }
                case '>': {
                    newValue.append("&gt;");
                    continue block6;
                }
                case '&': {
                    newValue.append("&amp;");
                    continue block6;
                }
                default: {
                    newValue.append(c);
                }
            }
        }
        return newValue.toString();
    }

    private String escapeReservedCharacters(String text) {
        StringBuffer newText = new StringBuffer(text.length() + 10);
        block5: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    newText.append("&lt;");
                    continue block5;
                }
                case '>': {
                    newText.append("&gt;");
                    continue block5;
                }
                case '&': {
                    newText.append("&amp;");
                    continue block5;
                }
                default: {
                    if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue block5;
                    newText.append(c);
                }
            }
        }
        return newText.toString();
    }

    private static class StartElementInfo {
        private final String localName;
        private final Attributes attrs;

        public StartElementInfo(String localName, Attributes attrs) {
            this.localName = localName;
            this.attrs = attrs;
        }

        public String getLocalName() {
            return this.localName;
        }

        public Attributes getAttrs() {
            return this.attrs;
        }
    }

    private class Line {
        private List lineItems = new ArrayList();
        private int length = 0;

        private Line() {
        }

        public void addStartTag(String text, OutputElementDescriptor descriptor) {
            this.lineItems.add(new StartTag(text, descriptor));
            this.length += text.length();
        }

        public void addEndTag(String text, OutputElementDescriptor descriptor) {
            if (!descriptor.isInline() && this.lineItems.size() > 0 && this.getLastLineItem() instanceof Space) {
                this.lineItems.remove(this.lineItems.size() - 1);
                --this.length;
            }
            this.lineItems.add(new EndTag(text, descriptor));
            this.length += text.length();
        }

        public void addWord(String text) {
            this.lineItems.add(new Word(text));
            this.length += text.length();
        }

        public void addSpace() {
            boolean addSpace = true;
            if (this.lineItems.size() > 0) {
                LineItem lastItem = this.getLastLineItem();
                if (lastItem instanceof Space) {
                    addSpace = false;
                } else if (lastItem instanceof Tag && !((Tag)lastItem).descriptor.isInline()) {
                    addSpace = false;
                }
            } else if (this.lineItems.size() == 0) {
                addSpace = false;
            }
            if (addSpace) {
                this.lineItems.add(new Space());
                ++this.length;
            }
        }

        public boolean endsOnWordOrSpace() {
            if (this.lineItems.size() > 0) {
                LineItem lineItem = this.getLastLineItem();
                return lineItem instanceof Word || lineItem instanceof Space;
            }
            return false;
        }

        public int getLength() {
            return this.length;
        }

        public String empty() {
            return this.empty(this.lineItems.size() - 1);
        }

        public String empty(int until) {
            StringBuffer text = new StringBuffer();
            int lastPos = until;
            for (int i = 0; i <= until; ++i) {
                LineItem lineItem = (LineItem)this.lineItems.get(i);
                if (i == lastPos && lineItem instanceof Space) continue;
                text.append(lineItem.text);
            }
            this.lineItems = new ArrayList(this.lineItems.subList(until + 1, this.lineItems.size()));
            this.recalcLength();
            return text.toString();
        }

        private void recalcLength() {
            int newLength = 0;
            for (int i = 0; i < this.lineItems.size(); ++i) {
                newLength += ((LineItem)this.lineItems.get((int)i)).text.length();
            }
            this.length = newLength;
        }

        public String emptyIfPossibleBeforeWord() {
            LineItem lineItem = this.getLastLineItem();
            if (lineItem instanceof Tag && ((Tag)lineItem).descriptor.isInline()) {
                int splitPoint = this.searchSplitPoint();
                if (splitPoint == -1) {
                    return null;
                }
                return this.empty(splitPoint);
            }
            return this.empty();
        }

        public String emptyIfPossibleBeforeInlineTag() {
            LineItem lineItem = this.getLastLineItem();
            if (lineItem instanceof Tag && ((Tag)lineItem).descriptor.isInline() || lineItem instanceof Word) {
                int splitPoint = this.searchSplitPoint();
                if (splitPoint == -1) {
                    return null;
                }
                return this.empty(splitPoint);
            }
            return this.empty();
        }

        private int searchSplitPoint() {
            if (this.lineItems.size() < 2) {
                return -1;
            }
            LineItem previousLineItem = this.getLastLineItem();
            for (int i = this.lineItems.size() - 2; i >= 0; --i) {
                LineItem currentLineItem = (LineItem)this.lineItems.get(i);
                if (currentLineItem instanceof Word && previousLineItem instanceof Word) {
                    return i;
                }
                if (currentLineItem instanceof Space) {
                    return i;
                }
                if (currentLineItem instanceof Tag && !((Tag)currentLineItem).descriptor.isInline()) {
                    return i;
                }
                previousLineItem = currentLineItem;
            }
            return -1;
        }

        private LineItem getLastLineItem() {
            return (LineItem)this.lineItems.get(this.lineItems.size() - 1);
        }

        class Space
        extends LineItem {
            public Space() {
                super(" ");
            }
        }

        class Word
        extends LineItem {
            public Word(String text) {
                super(text);
            }
        }

        class EndTag
        extends Tag {
            public EndTag(String text, OutputElementDescriptor descriptor) {
                super(text, descriptor);
            }
        }

        class StartTag
        extends Tag {
            public StartTag(String text, OutputElementDescriptor descriptor) {
                super(text, descriptor);
            }
        }

        abstract class Tag
        extends LineItem {
            final OutputElementDescriptor descriptor;

            public Tag(String text, OutputElementDescriptor descriptor) {
                super(text);
                this.descriptor = descriptor;
            }
        }

        abstract class LineItem {
            final String text;

            public LineItem(String text) {
                this.text = text;
            }
        }
    }

    private class LineRenderer {
        private Line line;

        private LineRenderer() {
            this.line = new Line();
        }

        public void newLines(int count) throws SAXException {
            try {
                if (count == 0) {
                    return;
                }
                if (this.line.getLength() > 0) {
                    this.flushLine(false);
                }
                if (count == 1) {
                    StylingHtmlSerializer.this.writer.write(10);
                } else {
                    for (int i = 0; i < count; ++i) {
                        StylingHtmlSerializer.this.writer.write(10);
                    }
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void writeText(String text) throws SAXException {
            try {
                if (StylingHtmlSerializer.this.inPreElement) {
                    StylingHtmlSerializer.this.writer.write(text);
                } else {
                    List words = this.getWords(text);
                    if (this.startsWithWhitespace(text)) {
                        this.line.addSpace();
                    }
                    if (words.size() > 0) {
                        Iterator wordsIt = words.iterator();
                        boolean firstWord = true;
                        while (wordsIt.hasNext()) {
                            String word = (String)wordsIt.next();
                            if (this.line.getLength() > 0 && this.line.getLength() + word.length() + 1 > ((StylingHtmlSerializer)StylingHtmlSerializer.this).template.maxLineWidth) {
                                if (!this.line.endsOnWordOrSpace()) {
                                    this.writeText(this.line.emptyIfPossibleBeforeWord(), true);
                                } else {
                                    this.writeText(this.line.empty(), true);
                                }
                            }
                            if (!firstWord) {
                                this.line.addSpace();
                            }
                            this.line.addWord(word);
                            firstWord = false;
                        }
                        if (this.endsWithWhitespace(text)) {
                            this.line.addSpace();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        private void writeText(String text, boolean newLine) throws IOException {
            if (text != null) {
                StylingHtmlSerializer.this.writer.write(text);
                if (newLine) {
                    StylingHtmlSerializer.this.writer.write(10);
                }
            }
        }

        private void flushLine(boolean newLine) throws SAXException {
            try {
                this.writeText(this.line.empty(), newLine);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        private boolean startsWithWhitespace(String text) {
            if (text.length() == 0) {
                return false;
            }
            return Character.isWhitespace(text.charAt(0));
        }

        private boolean endsWithWhitespace(String text) {
            if (text.length() == 0) {
                return false;
            }
            return Character.isWhitespace(text.charAt(text.length() - 1));
        }

        public void writeStartTag(String text, OutputElementDescriptor descriptor) throws SAXException {
            try {
                if (StylingHtmlSerializer.this.inPreElement) {
                    StylingHtmlSerializer.this.writer.write(text);
                } else {
                    if (this.line.getLength() > 0 && this.line.getLength() + 1 + text.length() > ((StylingHtmlSerializer)StylingHtmlSerializer.this).template.maxLineWidth) {
                        String toWrite = null;
                        toWrite = descriptor.isInline() ? this.line.emptyIfPossibleBeforeInlineTag() : this.line.empty();
                        this.writeText(toWrite, true);
                    }
                    this.line.addStartTag(text, descriptor);
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void writeEndTag(String text, OutputElementDescriptor descriptor) throws SAXException {
            try {
                if (StylingHtmlSerializer.this.inPreElement) {
                    StylingHtmlSerializer.this.writer.write(text);
                } else {
                    if (this.line.getLength() > 0 && this.line.getLength() + text.length() > ((StylingHtmlSerializer)StylingHtmlSerializer.this).template.maxLineWidth) {
                        String toWrite = null;
                        toWrite = descriptor.isInline() ? this.line.emptyIfPossibleBeforeInlineTag() : this.line.empty();
                        this.writeText(toWrite, true);
                    }
                    this.line.addEndTag(text, descriptor);
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        private List getWords(String text) {
            ArrayList<String> words = new ArrayList<String>();
            int beginWord = -1;
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isWhitespace(text.charAt(i))) {
                    if (beginWord == -1) continue;
                    String newWord = text.substring(beginWord, i);
                    words.add(newWord);
                    beginWord = -1;
                    continue;
                }
                if (beginWord != -1) continue;
                beginWord = i;
            }
            if (beginWord != -1) {
                String newWord = text.substring(beginWord);
                words.add(newWord);
            }
            return words;
        }
    }
}

