/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.locking;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.transaction.locking.GenericLock;
import org.apache.commons.transaction.locking.LockManager;
import org.apache.commons.transaction.locking.MultiLevelLock;
import org.apache.commons.transaction.util.LoggerFacade;

public class GenericLockManager
implements LockManager {
    protected Map globalLocks = new HashMap();
    protected int maxLockLevel = -1;
    protected LoggerFacade logger;

    public GenericLockManager(int maxLockLevel, LoggerFacade logger) throws IllegalArgumentException {
        if (maxLockLevel < 1) {
            throw new IllegalArgumentException("The maximum lock level must be at least 1 (" + maxLockLevel + " was specified)");
        }
        this.maxLockLevel = maxLockLevel;
        this.logger = logger.createLogger("Locking");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelLock getLock(Object resourceId) {
        Map map = this.globalLocks;
        synchronized (map) {
            return (MultiLevelLock)this.globalLocks.get(resourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelLock atomicGetOrCreateLock(Object resourceId) {
        Map map = this.globalLocks;
        synchronized (map) {
            MultiLevelLock lock = this.getLock(resourceId);
            if (lock == null) {
                lock = this.createLock(resourceId);
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLock(MultiLevelLock lock) {
        Map map = this.globalLocks;
        synchronized (map) {
            this.globalLocks.remove(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getLocks() {
        Map map = this.globalLocks;
        synchronized (map) {
            return this.globalLocks.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GenericLock createLock(Object resourceId) {
        Map map = this.globalLocks;
        synchronized (map) {
            GenericLock lock = new GenericLock(resourceId, this.maxLockLevel, this.logger);
            this.globalLocks.put(resourceId, lock);
            return lock;
        }
    }
}

