/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.util;

import java.io.PrintWriter;
import org.apache.commons.transaction.util.LoggerFacade;

public class PrintWriterLogger
implements LoggerFacade {
    protected PrintWriter printWriter;
    protected String name;
    protected boolean debug;

    public PrintWriterLogger(PrintWriter printWriter, String name, boolean debug) {
        this.printWriter = printWriter;
        this.name = name;
        this.debug = debug;
    }

    public LoggerFacade createLogger(String newName) {
        return new PrintWriterLogger(this.printWriter, newName, this.debug);
    }

    public void logInfo(String message) {
        this.log("INFO", message);
    }

    public void logFine(String message) {
        if (this.debug) {
            this.log("FINE", message);
        }
    }

    public boolean isFineEnabled() {
        return this.debug;
    }

    public void logFiner(String message) {
        if (this.debug) {
            this.log("FINER", message);
        }
    }

    public boolean isFinerEnabled() {
        return this.debug;
    }

    public void logFinest(String message) {
        if (this.debug) {
            this.log("FINEST", message);
        }
    }

    public boolean isFinestEnabled() {
        return this.debug;
    }

    public void logWarning(String message) {
        this.log("WARNING", message);
    }

    public void logWarning(String message, Throwable t) {
        this.log("WARNING", message);
        t.printStackTrace(this.printWriter);
    }

    public void logSevere(String message) {
        this.log("SEVERE", message);
    }

    public void logSevere(String message, Throwable t) {
        this.log("SEVERE", message);
        t.printStackTrace(this.printWriter);
    }

    protected void log(String level, String message) {
        this.printWriter.write(this.name + "(" + level + ":" + message);
    }
}

