/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.util.BrokerHelper;

public class Identity
implements Serializable {
    private static final long serialVersionUID = 3182285550574178710L;
    private static final int IS_TRANSIENT = 3;
    private static final int IS_PERMANENT = 17;
    private static final int iConstant = 37;
    private Class m_objectsTopLevelClass;
    private Class m_objectsRealClass = null;
    private Object[] m_pkValues;
    private final int isTransient;
    private transient String m_stringRepresentation = null;
    private transient Integer m_hashCode;

    protected Identity() {
        this.isTransient = 3;
    }

    public Identity(Class realClass, Class topLevel, Object[] pkValues, boolean isTransient) {
        this.m_objectsTopLevelClass = topLevel;
        this.m_objectsRealClass = realClass;
        this.m_pkValues = pkValues;
        this.isTransient = isTransient ? 3 : 17;
        this.checkForPrimaryKeys(null);
    }

    public Identity(Class realClass, Class topLevel, Object[] pkValues) {
        this.m_objectsTopLevelClass = topLevel;
        this.m_objectsRealClass = realClass;
        this.m_pkValues = pkValues;
        this.isTransient = 17;
        this.checkForPrimaryKeys(null);
    }

    public Identity(Object objectToIdentitify, PersistenceBroker targetBroker) {
        this.isTransient = 17;
        this.init(objectToIdentitify, targetBroker, null);
    }

    public Identity(Object objectToIdentitify, PersistenceBroker targetBroker, ClassDescriptor cld) {
        this.isTransient = 17;
        this.init(objectToIdentitify, targetBroker, cld);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Object objectToIdentify, PersistenceBroker targetBroker, ClassDescriptor cld) {
        if (objectToIdentify == null) {
            throw new OJBRuntimeException("Can't create Identity for 'null'-object");
        }
        try {
            IndirectionHandler handler = ProxyHelper.getIndirectionHandler(objectToIdentify);
            Object object = objectToIdentify;
            synchronized (object) {
                if (handler != null) {
                    Identity sourceOID = handler.getIdentity();
                    this.m_objectsTopLevelClass = sourceOID.m_objectsTopLevelClass;
                    this.m_objectsRealClass = sourceOID.m_objectsRealClass;
                    this.m_pkValues = sourceOID.m_pkValues;
                } else {
                    if (cld == null) {
                        cld = targetBroker.getClassDescriptor(objectToIdentify.getClass());
                    }
                    this.m_objectsTopLevelClass = targetBroker.getTopLevelClass(objectToIdentify.getClass());
                    this.m_objectsRealClass = objectToIdentify.getClass();
                    BrokerHelper helper = targetBroker.serviceBrokerHelper();
                    ValueContainer[] pkValues = helper.getValuesForObject(cld.getPkFields(), objectToIdentify, false, true);
                    if (pkValues == null || pkValues.length == 0) {
                        throw this.createException("Can't extract PK value fields", objectToIdentify, null);
                    }
                    this.m_pkValues = helper.extractValueArray(pkValues);
                }
            }
            this.checkForPrimaryKeys(objectToIdentify);
        }
        catch (ClassNotPersistenceCapableException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.createException("Can not init Identity for given object.", objectToIdentify, e);
        }
    }

    public static Identity fromByteArray(byte[] anArray) throws PersistenceBrokerException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(anArray);
            GZIPInputStream gis = new GZIPInputStream(bais);
            ObjectInputStream ois = new ObjectInputStream(gis);
            Identity result = (Identity)ois.readObject();
            ois.close();
            gis.close();
            bais.close();
            return result;
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
    }

    public boolean isTransient() {
        return this.isTransient == 3;
    }

    public Class getObjectsTopLevelClass() {
        return this.m_objectsTopLevelClass;
    }

    public Class getObjectsRealClass() {
        return this.m_objectsRealClass;
    }

    public void setObjectsRealClass(Class objectsRealClass) {
        this.m_objectsRealClass = objectsRealClass;
    }

    public byte[] serialize() throws PersistenceBrokerException {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(bao);
            ObjectOutputStream oos = new ObjectOutputStream(gos);
            oos.writeObject(this);
            oos.close();
            gos.close();
            bao.close();
            return bao.toByteArray();
        }
        catch (Exception ignored) {
            throw new PersistenceBrokerException(ignored);
        }
    }

    public String toString() {
        if (this.m_stringRepresentation == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.m_objectsTopLevelClass.getName());
            for (int i = 0; i < this.m_pkValues.length; ++i) {
                buf.append(i == 0 ? "{" : ",");
                buf.append(this.m_pkValues[i]);
            }
            buf.append("}");
            if (this.isTransient == 3) {
                buf.append("-transient");
            }
            this.m_stringRepresentation = buf.toString();
        }
        return this.m_stringRepresentation;
    }

    protected void checkForPrimaryKeys(Object realObject) throws ClassNotPersistenceCapableException {
        if (this.m_pkValues == null || this.m_pkValues.length == 0) {
            throw this.createException("OJB needs at least one primary key attribute for class: ", realObject, null);
        }
    }

    public Object[] getPrimaryKeyValues() {
        return this.m_pkValues;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof Identity) {
            Identity id = (Identity)obj;
            boolean bl = result = this.m_objectsTopLevelClass.equals(id.m_objectsTopLevelClass) && this.isTransient == id.isTransient;
            if (result) {
                Object[] otherPkValues = id.m_pkValues;
                boolean bl2 = result = this.m_pkValues.length == otherPkValues.length;
                if (result) {
                    for (int i = 0; result && i < this.m_pkValues.length; ++i) {
                        boolean bl3 = this.m_pkValues[i] == null ? otherPkValues[i] == null : (result = this.m_pkValues[i].equals(otherPkValues[i]));
                        if (result || !(this.m_pkValues[i] instanceof byte[]) || !(otherPkValues[i] instanceof byte[])) continue;
                        result = Arrays.equals((byte[])this.m_pkValues[i], (byte[])otherPkValues[i]);
                    }
                }
            }
        }
        return result;
    }

    public int hashCode() {
        if (this.m_hashCode == null) {
            int iTotal = this.isTransient;
            for (int i = 0; i < this.m_pkValues.length; ++i) {
                Object obj = this.m_pkValues[i];
                iTotal = obj instanceof byte[] ? iTotal * 37 + ((byte[])obj).length : iTotal * 37 + (obj != null ? obj.hashCode() : 0);
            }
            iTotal = iTotal * 37 + this.m_objectsTopLevelClass.hashCode();
            this.m_hashCode = new Integer(iTotal);
        }
        return this.m_hashCode;
    }

    private ClassNotPersistenceCapableException createException(String msg, Object objectToIdentify, Exception e) {
        String eol = SystemUtils.LINE_SEPARATOR;
        if (msg == null) {
            msg = "Unexpected error:";
        }
        if (e != null) {
            return new ClassNotPersistenceCapableException(msg + eol + "objectTopLevelClass=" + (this.m_objectsTopLevelClass != null ? this.m_objectsTopLevelClass.getName() : null) + eol + "objectRealClass=" + (this.m_objectsRealClass != null ? this.m_objectsRealClass.getName() : null) + eol + "pkValues=" + (this.m_pkValues != null ? ArrayUtils.toString((Object)this.m_pkValues) : null) + (objectToIdentify != null ? eol + "object to identify: " + objectToIdentify : ""), e);
        }
        return new ClassNotPersistenceCapableException(msg + eol + "objectTopLevelClass=" + (this.m_objectsTopLevelClass != null ? this.m_objectsTopLevelClass.getName() : null) + eol + "objectRealClass=" + (this.m_objectsRealClass != null ? this.m_objectsRealClass.getName() : null) + eol + "pkValues=" + (this.m_pkValues != null ? ArrayUtils.toString((Object)this.m_pkValues) : null) + eol + "object to identify: " + objectToIdentify);
    }
}

