/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerEvent;

public final class PBStateEvent
extends PersistenceBrokerEvent {
    public static final int KEY_BEFORE_CLOSE = 1;
    public static final int KEY_BEFORE_BEGIN = 2;
    public static final int KEY_BEFORE_COMMIT = 3;
    public static final int KEY_BEFORE_ROLLBACK = 4;
    public static final int KEY_AFTER_BEGIN = 5;
    public static final int KEY_AFTER_COMMIT = 6;
    public static final int KEY_AFTER_OPEN = 7;
    public static final int KEY_AFTER_ROLLBACK = 8;
    private Type eventType;

    public PBStateEvent(PersistenceBroker broker, Type eventType) {
        super(broker);
        this.eventType = eventType;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this);
        buf.append("type", (Object)this.eventType.toString()).append("source object", this.getSource());
        return buf.toString();
    }

    public Type getEventType() {
        return this.eventType;
    }

    public static class Type {
        public static final Type BEFORE_BEGIN = new Type(2);
        public static final Type AFTER_BEGIN = new Type(5);
        public static final Type BEFORE_COMMIT = new Type(3);
        public static final Type AFTER_COMMIT = new Type(6);
        public static final Type BEFORE_ROLLBACK = new Type(4);
        public static final Type AFTER_ROLLBACK = new Type(8);
        public static final Type AFTER_OPEN = new Type(7);
        public static final Type BEFORE_CLOSE = new Type(1);
        private int type;

        protected Type(int type) {
            this.type = type;
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PBStateEvent)) {
                return false;
            }
            return this.type == ((Type)obj).type;
        }

        public final int hashCode() {
            return this.type;
        }

        public final int typeId() {
            return this.type;
        }

        public String toString() {
            return this.getClass().getName() + " [type= " + this.typeAsName(this.type) + "]";
        }

        private String typeAsName(int aType) {
            if (aType == 5) {
                return "AFTER_BEGIN";
            }
            if (aType == 6) {
                return "AFTER_COMMIT";
            }
            if (aType == 7) {
                return "AFTER_OPEN";
            }
            if (aType == 8) {
                return "AFTER_ROLLBACK";
            }
            if (aType == 2) {
                return "BEFORE_BEGIN";
            }
            if (aType == 1) {
                return "BEFORE_CLOSE";
            }
            if (aType == 3) {
                return "BEFORE_COMMIT";
            }
            if (aType == 4) {
                return "BEFORE_ROLLBACK";
            }
            throw new OJBRuntimeException("Could not find type " + aType);
        }
    }
}

