/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class BasePrefetcher
implements RelationshipPrefetcher {
    protected static final int IN_LIMIT = BasePrefetcher.getPrefetchInLimit();
    private Logger logger;
    private PersistenceBrokerImpl broker;
    protected ClassDescriptor itemClassDesc;
    protected final int pkLimit;

    private static int getPrefetchInLimit() {
        try {
            PersistenceBrokerConfiguration config = (PersistenceBrokerConfiguration)((Object)PersistenceBrokerFactory.getConfigurator().getConfigurationFor(null));
            return config.getSqlInLimit();
        }
        catch (ConfigurationException e) {
            return 200;
        }
    }

    public BasePrefetcher(PersistenceBrokerImpl aBroker, Class anItemClass) {
        this.broker = aBroker;
        this.itemClassDesc = aBroker.getDescriptorRepository().getDescriptorFor(anItemClass);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.pkLimit = BasePrefetcher.getPrefetchInLimit() / this.getItemClassDescriptor().getPkFields().length;
    }

    public int getLimit() {
        return this.pkLimit;
    }

    protected abstract void associateBatched(Collection var1, Collection var2);

    public void prefetchRelationship(Collection owners) {
        ArrayList children = new ArrayList();
        Query[] queries = this.buildPrefetchQueries(owners, children);
        for (int i = 0; i < queries.length; ++i) {
            Iterator iter = this.getBroker().getIteratorByQuery(queries[i]);
            while (iter.hasNext()) {
                children.add(iter.next());
            }
        }
        this.getBroker().getReferenceBroker().performRetrievalTasks();
        this.associateBatched(owners, children);
    }

    protected QueryByCriteria buildPrefetchQuery(Collection ids, FieldDescriptor[] fields) {
        return this.buildPrefetchQuery(this.getItemClassDescriptor().getClassOfObject(), ids, fields);
    }

    protected Criteria buildPrefetchCriteria(Collection ids, FieldDescriptor[] fields) {
        if (fields.length == 1) {
            return this.buildPrefetchCriteriaSingleKey(ids, fields[0]);
        }
        return this.buildPrefetchCriteriaMultipleKeys(ids, fields);
    }

    protected QueryByCriteria buildPrefetchQuery(Class clazz, Collection ids, FieldDescriptor[] fields) {
        return QueryFactory.newQuery(clazz, this.buildPrefetchCriteria(ids, fields));
    }

    private Criteria buildPrefetchCriteriaSingleKey(Collection ids, FieldDescriptor field) {
        Criteria crit = new Criteria();
        ArrayList<Object> values = new ArrayList<Object>(ids.size());
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            Identity id = (Identity)iter.next();
            values.add(id.getPrimaryKeyValues()[0]);
        }
        switch (values.size()) {
            case 0: {
                break;
            }
            case 1: {
                crit.addEqualTo(field.getAttributeName(), values.get(0));
                break;
            }
            default: {
                crit.addIn(field.getAttributeName(), values);
            }
        }
        return crit;
    }

    private Criteria buildPrefetchCriteriaMultipleKeys(Collection ids, FieldDescriptor[] fields) {
        Criteria crit = new Criteria();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            Criteria c = new Criteria();
            Identity id = (Identity)iter.next();
            Object[] val = id.getPrimaryKeyValues();
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) {
                    c.addIsNull(fields[i].getAttributeName());
                    continue;
                }
                c.addEqualTo(fields[i].getAttributeName(), val[i]);
            }
            crit.addOrCriteria(c);
        }
        return crit;
    }

    protected DescriptorRepository getDescriptorRepository() {
        return this.getBroker().getDescriptorRepository();
    }

    public ClassDescriptor getItemClassDescriptor() {
        return this.itemClassDesc;
    }

    protected abstract Query[] buildPrefetchQueries(Collection var1, Collection var2);

    protected PersistenceBrokerImpl getBroker() {
        return this.broker;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

