/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.IdentityFactory;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcherImpl;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.collections.RemovalAwareCollection;
import org.apache.ojb.broker.util.collections.RemovalAwareList;
import org.apache.ojb.broker.util.collections.RemovalAwareSet;

public class CollectionPrefetcher
extends RelationshipPrefetcherImpl {
    static /* synthetic */ Class class$org$apache$ojb$broker$ManageableCollection;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareCollection;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareList;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareSet;

    public CollectionPrefetcher(PersistenceBrokerImpl aBroker, ObjectReferenceDescriptor anOrd) {
        super(aBroker, anOrd);
    }

    protected Query[] buildPrefetchQueries(Collection owners, Collection children) {
        ClassDescriptor cld = this.getOwnerClassDescriptor();
        Class topLevelClass = this.getBroker().getTopLevelClass(cld.getClassOfObject());
        BrokerHelper helper = this.getBroker().serviceBrokerHelper();
        ArrayList<Query> queries = new ArrayList<Query>(owners.size());
        HashSet<Identity> idsSubset = new HashSet<Identity>(owners.size());
        Iterator iter = owners.iterator();
        while (iter.hasNext()) {
            Object owner = iter.next();
            Object[] fkValues = helper.extractValueArray(helper.getKeyValues(cld, owner));
            Identity id = this.getBroker().serviceIdentity().buildIdentity(null, topLevelClass, fkValues);
            idsSubset.add(id);
            if (idsSubset.size() != this.pkLimit) continue;
            queries.add(this.buildPrefetchQuery(idsSubset));
            idsSubset.clear();
        }
        if (idsSubset.size() > 0) {
            queries.add(this.buildPrefetchQuery(idsSubset));
        }
        return queries.toArray(new Query[queries.size()]);
    }

    protected Query buildPrefetchQuery(Collection ids) {
        CollectionDescriptor cds = this.getCollectionDescriptor();
        QueryByCriteria query = this.buildPrefetchQuery(ids, cds.getForeignKeyFieldDescriptors(this.getItemClassDescriptor()));
        if (!cds.getOrderBy().isEmpty()) {
            Iterator iter = cds.getOrderBy().iterator();
            while (iter.hasNext()) {
                query.addOrderBy((FieldHelper)iter.next());
            }
        }
        return query;
    }

    protected void associateBatched(Collection owners, Collection children) {
        CollectionDescriptor cds = this.getCollectionDescriptor();
        PersistentField field = cds.getPersistentField();
        PersistenceBrokerImpl pb = this.getBroker();
        Class ownerTopLevelClass = pb.getTopLevelClass(this.getOwnerClassDescriptor().getClassOfObject());
        Class collectionClass = cds.getCollectionClass();
        HashMap ownerIdsToLists = new HashMap(owners.size());
        IdentityFactory identityFactory = pb.serviceIdentity();
        Iterator it = owners.iterator();
        while (it.hasNext()) {
            Object owner = it.next();
            ownerIdsToLists.put(identityFactory.buildIdentity(this.getOwnerClassDescriptor(), owner), new ArrayList());
        }
        it = children.iterator();
        while (it.hasNext()) {
            ClassDescriptor cld;
            Object child = it.next();
            Object[] fkValues = cds.getForeignKeyValues(child, cld = this.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(child)));
            Identity ownerId = identityFactory.buildIdentity(null, ownerTopLevelClass, fkValues);
            List list = (List)ownerIdsToLists.get(ownerId);
            if (list == null) continue;
            list.add(child);
        }
        it = owners.iterator();
        while (it.hasNext()) {
            Object value;
            Object result;
            Object owner = it.next();
            Identity ownerId = identityFactory.buildIdentity(owner);
            List list = (List)ownerIdsToLists.get(ownerId);
            if (collectionClass == null && field.getType().isArray()) {
                int length = list.size();
                Class<?> itemtype = field.getType().getComponentType();
                result = Array.newInstance(itemtype, length);
                for (int j = 0; j < length; ++j) {
                    Array.set(result, j, list.get(j));
                }
            } else {
                ManageableCollection col = this.createCollection(cds, collectionClass);
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    col.ojbAdd(it2.next());
                }
                result = col;
            }
            if ((value = field.get(owner)) instanceof CollectionProxyDefaultImpl && result instanceof Collection) {
                ((CollectionProxyDefaultImpl)value).setData((Collection)result);
                continue;
            }
            field.set(owner, result);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ManageableCollection createCollection(CollectionDescriptor desc, Class collectionClass) {
        void var4_4;
        ManageableCollection col;
        Class fieldType = desc.getPersistentField().getType();
        if (collectionClass == null) {
            if ((class$org$apache$ojb$broker$ManageableCollection == null ? (class$org$apache$ojb$broker$ManageableCollection = CollectionPrefetcher.class$("org.apache.ojb.broker.ManageableCollection")) : class$org$apache$ojb$broker$ManageableCollection).isAssignableFrom(fieldType)) {
                try {
                    col = (ManageableCollection)fieldType.newInstance();
                    return var4_4;
                }
                catch (Exception e) {
                    throw new OJBRuntimeException("Cannot instantiate the default collection type " + fieldType.getName() + " of collection " + desc.getAttributeName() + " in type " + desc.getClassDescriptor().getClassNameOfObject());
                }
            } else if (fieldType.isAssignableFrom(class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = CollectionPrefetcher.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection)) {
                col = new RemovalAwareCollection();
                return var4_4;
            } else if (fieldType.isAssignableFrom(class$org$apache$ojb$broker$util$collections$RemovalAwareList == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareList = CollectionPrefetcher.class$("org.apache.ojb.broker.util.collections.RemovalAwareList")) : class$org$apache$ojb$broker$util$collections$RemovalAwareList)) {
                col = new RemovalAwareList();
                return var4_4;
            } else {
                if (!fieldType.isAssignableFrom(class$org$apache$ojb$broker$util$collections$RemovalAwareSet == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareSet = CollectionPrefetcher.class$("org.apache.ojb.broker.util.collections.RemovalAwareSet")) : class$org$apache$ojb$broker$util$collections$RemovalAwareSet)) throw new MetadataException("Cannot determine a default collection type for collection " + desc.getAttributeName() + " in type " + desc.getClassDescriptor().getClassNameOfObject());
                col = new RemovalAwareSet();
            }
            return var4_4;
        }
        try {
            col = (ManageableCollection)collectionClass.newInstance();
            return var4_4;
        }
        catch (Exception e) {
            throw new OJBRuntimeException("Cannot instantiate the collection class " + collectionClass.getName() + " of collection " + desc.getAttributeName() + " in type " + desc.getClassDescriptor().getClassNameOfObject());
        }
    }

    protected CollectionDescriptor getCollectionDescriptor() {
        return (CollectionDescriptor)this.getObjectReferenceDescriptor();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

