/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.accesslayer.sql.SelectStatement;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.ExceptionHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class JdbcAccessImpl
implements JdbcAccess {
    protected Logger logger;
    protected PersistenceBroker broker;

    public JdbcAccessImpl(PersistenceBroker broker) {
        this.broker = broker;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    private Platform getPlatform() {
        return this.broker.serviceConnectionManager().getSupportedPlatform();
    }

    public void executeDelete(ClassDescriptor cld, Object obj) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeDelete: " + obj);
        }
        StatementManagerIF sm = this.broker.serviceStatementManager();
        PreparedStatement stmt = null;
        try {
            stmt = sm.getDeleteStatement(cld);
            if (stmt == null) {
                this.logger.error("getDeleteStatement returned a null statement");
                throw new PersistenceBrokerException("JdbcAccessImpl: getDeleteStatement returned a null statement");
            }
            sm.bindDelete(stmt, cld, obj);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeDelete: " + stmt);
            }
            if (stmt.executeUpdate() == 0 && cld.isLocking()) {
                throw new OptimisticLockException("Object has been modified or deleted by someone else", obj);
            }
            this.harvestReturnValues(cld.getDeleteProcedure(), obj, stmt);
        }
        catch (OptimisticLockException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("OptimisticLockException during the execution of delete: " + e.getMessage(), (Throwable)((Object)e));
            }
            throw e;
        }
        catch (PersistenceBrokerException e) {
            this.logger.error("PersistenceBrokerException during the execution of delete: " + e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (SQLException e) {
            String sql = this.broker.serviceSqlGenerator().getPreparedDeleteStatement(cld).getStatement();
            throw ExceptionHelper.generateException(e, sql, cld, this.logger, obj);
        }
        finally {
            sm.closeResources(stmt, null);
        }
    }

    public void executeDelete(Query query, ClassDescriptor cld) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeDelete (by Query): " + query);
        }
        StatementManagerIF sm = this.broker.serviceStatementManager();
        PreparedStatement stmt = null;
        String sql = this.broker.serviceSqlGenerator().getPreparedDeleteStatement(query, cld).getStatement();
        try {
            stmt = sm.getPreparedStatement(cld, sql, false, -1, cld.getDeleteProcedure() != null);
            sm.bindStatement(stmt, query, cld, 1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeDelete (by Query): " + stmt);
            }
            stmt.executeUpdate();
            sm.closeResources(stmt, null);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.generateException(e, sql, cld, null, this.logger);
            }
            catch (Throwable throwable) {
                sm.closeResources(stmt, null);
                throw throwable;
            }
        }
    }

    public void executeInsert(ClassDescriptor cld, Object obj) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeInsert: " + obj);
        }
        StatementManagerIF sm = this.broker.serviceStatementManager();
        PreparedStatement stmt = null;
        try {
            stmt = sm.getInsertStatement(cld);
            if (stmt == null) {
                this.logger.error("getInsertStatement returned a null statement");
                throw new PersistenceBrokerException("getInsertStatement returned a null statement");
            }
            this.assignAutoincrementSequences(cld, obj);
            sm.bindInsert(stmt, cld, obj);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeInsert: " + stmt);
            }
            stmt.executeUpdate();
            this.assignAutoincrementIdentityColumns(cld, obj);
            this.harvestReturnValues(cld.getInsertProcedure(), obj, stmt);
        }
        catch (PersistenceBrokerException e) {
            this.logger.error("PersistenceBrokerException during the execution of the insert: " + e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (SequenceManagerException e) {
            throw new PersistenceBrokerException("Error while try to assign identity value", (Throwable)((Object)e));
        }
        catch (SQLException e) {
            String sql = this.broker.serviceSqlGenerator().getPreparedInsertStatement(cld).getStatement();
            throw ExceptionHelper.generateException(e, sql, cld, this.logger, obj);
        }
        finally {
            sm.closeResources(stmt, null);
        }
    }

    public ResultSetAndStatement executeQuery(Query query, ClassDescriptor cld) throws PersistenceBrokerException {
        boolean scrollable;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeQuery: " + query);
        }
        boolean bl = scrollable = query.getStartAtIndex() > 0 || query.getEndAtIndex() > 0;
        if (query != null && query.getPrefetchedRelationships() != null && !query.getPrefetchedRelationships().isEmpty()) {
            scrollable = true;
        }
        StatementManagerIF sm = this.broker.serviceStatementManager();
        SelectStatement sql = this.broker.serviceSqlGenerator().getPreparedSelectStatement(query, cld);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int queryFetchSize = query.getFetchSize();
            boolean isStoredProcedure = this.isStoredProcedure(sql.getStatement());
            stmt = sm.getPreparedStatement(cld, sql.getStatement(), scrollable, queryFetchSize, isStoredProcedure);
            if (isStoredProcedure) {
                this.getPlatform().registerOutResultSet((CallableStatement)stmt, 1);
                sm.bindStatement(stmt, query, cld, 2);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("executeQuery: " + stmt);
                }
                stmt.execute();
                rs = (ResultSet)((CallableStatement)stmt).getObject(1);
            } else {
                sm.bindStatement(stmt, query, cld, 1);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("executeQuery: " + stmt);
                }
                rs = stmt.executeQuery();
            }
            return new ResultSetAndStatement(sm, stmt, rs, sql);
        }
        catch (PersistenceBrokerException e) {
            sm.closeResources(stmt, rs);
            this.logger.error("PersistenceBrokerException during the execution of the query: " + e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (SQLException e) {
            sm.closeResources(stmt, rs);
            throw ExceptionHelper.generateException(e, sql.getStatement(), null, this.logger, null);
        }
    }

    public ResultSetAndStatement executeSQL(String sqlStatement, ClassDescriptor cld, boolean scrollable) throws PersistenceBrokerException {
        return this.executeSQL(sqlStatement, cld, null, scrollable);
    }

    public ResultSetAndStatement executeSQL(final String sql, ClassDescriptor cld, ValueContainer[] values, boolean scrollable) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeSQL: " + sql);
        }
        boolean isStoredprocedure = this.isStoredProcedure(sql);
        StatementManagerIF sm = this.broker.serviceStatementManager();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = sm.getPreparedStatement(cld, sql, scrollable, 0, isStoredprocedure);
            if (isStoredprocedure) {
                this.getPlatform().registerOutResultSet((CallableStatement)stmt, 1);
                sm.bindValues(stmt, values, 2);
                stmt.execute();
                rs = (ResultSet)((CallableStatement)stmt).getObject(1);
            } else {
                sm.bindValues(stmt, values, 1);
                rs = stmt.executeQuery();
            }
            return new ResultSetAndStatement(sm, stmt, rs, new SelectStatement(){

                public Query getQueryInstance() {
                    return null;
                }

                public int getColumnIndex(FieldDescriptor fld) {
                    return Integer.MIN_VALUE;
                }

                public String getStatement() {
                    return sql;
                }
            });
        }
        catch (PersistenceBrokerException e) {
            sm.closeResources(stmt, rs);
            this.logger.error("PersistenceBrokerException during the execution of the SQL query: " + e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (SQLException e) {
            sm.closeResources(stmt, rs);
            throw ExceptionHelper.generateException(e, sql, cld, values, this.logger, null);
        }
    }

    public int executeUpdateSQL(String sqlStatement, ClassDescriptor cld) throws PersistenceBrokerException {
        return this.executeUpdateSQL(sqlStatement, cld, null, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdateSQL(String sqlStatement, ClassDescriptor cld, ValueContainer[] values1, ValueContainer[] values2) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeUpdateSQL: " + sqlStatement);
        }
        PreparedStatement stmt = null;
        StatementManagerIF sm = this.broker.serviceStatementManager();
        try {
            stmt = sm.getPreparedStatement(cld, sqlStatement, false, -1, this.isStoredProcedure(sqlStatement));
            int index = sm.bindValues(stmt, values1, 1);
            sm.bindValues(stmt, values2, index);
            int result = stmt.executeUpdate();
            sm.closeResources(stmt, null);
            return result;
        }
        catch (PersistenceBrokerException e) {
            try {
                this.logger.error("PersistenceBrokerException during the execution of the Update SQL query: " + e.getMessage(), (Throwable)((Object)e));
                throw e;
                catch (SQLException e2) {
                    ValueContainer[] tmp = this.addValues(values1, values2);
                    throw ExceptionHelper.generateException(e2, sqlStatement, cld, tmp, this.logger, null);
                }
            }
            catch (Throwable throwable) {
                sm.closeResources(stmt, null);
                throw throwable;
            }
        }
    }

    private ValueContainer[] addValues(ValueContainer[] target, ValueContainer[] source) {
        ValueContainer[] newArray;
        if (source != null && source.length > 0) {
            if (target != null) {
                newArray = new ValueContainer[target.length + source.length];
                System.arraycopy(target, 0, newArray, 0, target.length);
                System.arraycopy(source, 0, newArray, target.length, source.length);
            } else {
                newArray = source;
            }
        } else {
            newArray = target;
        }
        return newArray;
    }

    public void executeUpdate(ClassDescriptor cld, Object obj) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeUpdate: " + obj);
        }
        if (cld.getNonPkRwFields().length == 0) {
            return;
        }
        StatementManagerIF sm = this.broker.serviceStatementManager();
        PreparedStatement stmt = null;
        ValueContainer[] oldLockingValues = cld.getCurrentLockingValues(obj);
        try {
            stmt = sm.getUpdateStatement(cld);
            if (stmt == null) {
                this.logger.error("getUpdateStatement returned a null statement");
                throw new PersistenceBrokerException("getUpdateStatement returned a null statement");
            }
            sm.bindUpdate(stmt, cld, obj);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeUpdate: " + stmt);
            }
            if (stmt.executeUpdate() == 0 && cld.isLocking()) {
                throw new OptimisticLockException("Object has been modified by someone else", obj);
            }
            this.harvestReturnValues(cld.getUpdateProcedure(), obj, stmt);
        }
        catch (OptimisticLockException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("OptimisticLockException during the execution of update: " + e.getMessage(), (Throwable)((Object)e));
            }
            throw e;
        }
        catch (PersistenceBrokerException e) {
            this.setLockingValues(cld, obj, oldLockingValues);
            this.logger.error("PersistenceBrokerException during the execution of the update: " + e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (SQLException e) {
            String sql = this.broker.serviceSqlGenerator().getPreparedUpdateStatement(cld).getStatement();
            throw ExceptionHelper.generateException(e, sql, cld, this.logger, obj);
        }
        finally {
            sm.closeResources(stmt, null);
        }
    }

    public Object materializeObject(ClassDescriptor cld, Identity oid) throws PersistenceBrokerException {
        StatementManagerIF sm = this.broker.serviceStatementManager();
        SelectStatement sql = this.broker.serviceSqlGenerator().getPreparedSelectByPkStatement(cld);
        Object result = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = sm.getSelectByPKStatement(cld);
            if (stmt == null) {
                this.logger.error("getSelectByPKStatement returned a null statement");
                throw new PersistenceBrokerException("getSelectByPKStatement returned a null statement");
            }
            sm.bindSelect(stmt, oid, cld, false);
            rs = stmt.executeQuery();
            ResultSetAndStatement rs_stmt = new ResultSetAndStatement(this.broker.serviceStatementManager(), stmt, rs, sql);
            if (rs.next()) {
                HashMap row = new HashMap();
                cld.getRowReader().readObjectArrayFrom(rs_stmt, row);
                result = cld.getRowReader().readObjectFrom(row);
            }
            rs_stmt.close();
        }
        catch (PersistenceBrokerException e) {
            sm.closeResources(stmt, rs);
            this.logger.error("PersistenceBrokerException during the execution of materializeObject: " + e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (SQLException e) {
            sm.closeResources(stmt, rs);
            throw ExceptionHelper.generateException(e, sql.getStatement(), cld, this.logger, null);
        }
        return result;
    }

    private void setLockingValues(ClassDescriptor cld, Object obj, ValueContainer[] oldLockingValues) {
        FieldDescriptor[] fields = cld.getLockingFields();
        for (int i = 0; i < fields.length; ++i) {
            PersistentField field = fields[i].getPersistentField();
            Object lockVal = oldLockingValues[i].getValue();
            field.set(obj, lockVal);
        }
    }

    private void harvestReturnValues(ProcedureDescriptor proc, Object obj, PreparedStatement stmt) throws PersistenceBrokerSQLException {
        if (proc == null || !proc.hasReturnValues()) {
            return;
        }
        CallableStatement callable = (CallableStatement)stmt;
        int index = 0;
        if (proc.hasReturnValue()) {
            this.harvestReturnValue(obj, callable, proc.getReturnValueFieldRef(), ++index);
        }
        Iterator iter = proc.getArguments().iterator();
        while (iter.hasNext()) {
            ++index;
            ArgumentDescriptor arg = (ArgumentDescriptor)iter.next();
            if (!arg.getIsReturnedByProcedure()) continue;
            this.harvestReturnValue(obj, callable, arg.getFieldRef(), index);
        }
    }

    private void harvestReturnValue(Object obj, CallableStatement callable, FieldDescriptor fmd, int index) throws PersistenceBrokerSQLException {
        try {
            if (callable != null && fmd != null && obj != null) {
                Object value = fmd.getJdbcType().getObjectFromColumn(callable, index);
                fmd.getPersistentField().set(obj, fmd.getFieldConversion().sqlToJava(value));
            }
        }
        catch (SQLException e) {
            String msg = "SQLException during the execution of harvestReturnValue class=" + obj.getClass().getName() + "," + " field=" + fmd.getAttributeName() + " : " + e.getMessage();
            this.logger.error(msg, e);
            throw new PersistenceBrokerSQLException(msg, e);
        }
    }

    protected boolean isStoredProcedure(String sql) {
        int k = 0;
        for (int i = 0; k < 3 && i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == ' ') continue;
            switch (k) {
                case 0: {
                    if (c == '{') break;
                    return false;
                }
                case 1: {
                    if (c == '?' || c == 'c') break;
                    return false;
                }
                case 2: {
                    if (c == '=' || c == 'a') break;
                    return false;
                }
            }
            ++k;
        }
        return true;
    }

    protected void assignAutoincrementSequences(ClassDescriptor cld, Object target) throws SequenceManagerException {
        FieldDescriptor[] fields = cld.getFieldDescriptor(false);
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor field = fields[i];
            if (!field.isAutoIncrement() || field.isAccessReadOnly()) continue;
            Object value = field.getPersistentField().get(target);
            if (!this.broker.serviceBrokerHelper().representsNull(field, value)) continue;
            Object id = this.broker.serviceSequenceManager().getUniqueValue(field);
            field.getPersistentField().set(target, id);
        }
    }

    protected void assignAutoincrementIdentityColumns(ClassDescriptor cld, Object target) throws SequenceManagerException {
        if (cld.useIdentityColumnField()) {
            this.broker.serviceSequenceManager().afterStore(this, cld, target);
        }
    }
}

