/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.accesslayer.CollectionPrefetcher;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByMtoNCriteria;
import org.apache.ojb.broker.query.ReportQueryByMtoNCriteria;

public class MtoNCollectionPrefetcher
extends CollectionPrefetcher {
    public MtoNCollectionPrefetcher(PersistenceBrokerImpl aBroker, ObjectReferenceDescriptor anOrd) {
        super(aBroker, anOrd);
    }

    public void prefetchRelationship(Collection owners) {
        ArrayList children = new ArrayList();
        ArrayList mnImplementors = new ArrayList();
        Query[] queries = this.buildPrefetchQueries(owners, children);
        Query[] mnQueries = this.buildMtoNImplementorQueries(owners, children);
        for (int i = 0; i < queries.length; ++i) {
            Iterator iter = this.getBroker().getIteratorByQuery(queries[i]);
            while (iter.hasNext()) {
                Object aChild = iter.next();
                if (children.contains(aChild)) continue;
                children.add(aChild);
            }
            Iterator mnIter = this.getBroker().getReportQueryIteratorByQuery(mnQueries[i]);
            while (mnIter.hasNext()) {
                mnImplementors.add(mnIter.next());
            }
        }
        this.associateBatched(owners, children, mnImplementors);
    }

    protected Query buildPrefetchQuery(Collection ids) {
        CollectionDescriptor cds = this.getCollectionDescriptor();
        String[] indFkCols = this.getFksToThisClass();
        String[] indItemFkCols = this.getFksToItemClass();
        FieldDescriptor[] itemPkFields = this.getItemClassDescriptor().getPkFields();
        Criteria crit = this.buildPrefetchCriteria(ids, indFkCols, indItemFkCols, itemPkFields);
        return new QueryByMtoNCriteria(cds.getItemClass(), cds.getIndirectionTable(), crit, false);
    }

    protected Query buildMtoNImplementorQuery(Collection ids) {
        int i;
        String[] indFkCols = this.getFksToThisClass();
        String[] indItemFkCols = this.getFksToItemClass();
        FieldDescriptor[] pkFields = this.getOwnerClassDescriptor().getPkFields();
        FieldDescriptor[] itemPkFields = this.getItemClassDescriptor().getPkFields();
        String[] cols = new String[indFkCols.length + indItemFkCols.length];
        int[] jdbcTypes = new int[indFkCols.length + indItemFkCols.length];
        System.arraycopy(indFkCols, 0, cols, 0, indFkCols.length);
        System.arraycopy(indItemFkCols, 0, cols, indFkCols.length, indItemFkCols.length);
        Criteria crit = this.buildPrefetchCriteria(ids, indFkCols, indItemFkCols, itemPkFields);
        for (i = 0; i < pkFields.length; ++i) {
            jdbcTypes[i] = pkFields[i].getJdbcType().getType();
        }
        for (i = 0; i < itemPkFields.length; ++i) {
            jdbcTypes[pkFields.length + i] = itemPkFields[i].getJdbcType().getType();
        }
        ReportQueryByMtoNCriteria q = new ReportQueryByMtoNCriteria(this.getItemClassDescriptor().getClassOfObject(), cols, crit, false);
        q.setIndirectionTable(this.getCollectionDescriptor().getIndirectionTable());
        q.setJdbcTypes(jdbcTypes);
        CollectionDescriptor cds = this.getCollectionDescriptor();
        if (!cds.getOrderBy().isEmpty()) {
            Iterator iter = cds.getOrderBy().iterator();
            while (iter.hasNext()) {
                q.addOrderBy((FieldHelper)iter.next());
            }
        }
        return q;
    }

    private String[] getFksToThisClass() {
        String indTable = this.getCollectionDescriptor().getIndirectionTable();
        String[] fks = this.getCollectionDescriptor().getFksToThisClass();
        String[] result = new String[fks.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = indTable + "." + fks[i];
        }
        return result;
    }

    private String[] getFksToItemClass() {
        String indTable = this.getCollectionDescriptor().getIndirectionTable();
        String[] fks = this.getCollectionDescriptor().getFksToItemClass();
        String[] result = new String[fks.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = indTable + "." + fks[i];
        }
        return result;
    }

    protected Query[] buildMtoNImplementorQueries(Collection owners, Collection children) {
        ClassDescriptor cld = this.getOwnerClassDescriptor();
        PersistenceBrokerImpl pb = this.getBroker();
        ArrayList<Query> queries = new ArrayList<Query>(owners.size());
        HashSet<Identity> idsSubset = new HashSet<Identity>(owners.size());
        Iterator iter = owners.iterator();
        while (iter.hasNext()) {
            Object owner = iter.next();
            Identity id = pb.serviceIdentity().buildIdentity(cld, owner);
            idsSubset.add(id);
            if (idsSubset.size() != this.pkLimit) continue;
            queries.add(this.buildMtoNImplementorQuery(idsSubset));
            idsSubset.clear();
        }
        if (idsSubset.size() > 0) {
            queries.add(this.buildMtoNImplementorQuery(idsSubset));
        }
        return queries.toArray(new Query[queries.size()]);
    }

    private Criteria buildPrefetchCriteria(Collection ids, String[] fkCols, String[] itemFkCols, FieldDescriptor[] itemPkFields) {
        if (fkCols.length == 1 && itemFkCols.length == 1) {
            return this.buildPrefetchCriteriaSingleKey(ids, fkCols[0], itemFkCols[0], itemPkFields[0]);
        }
        return this.buildPrefetchCriteriaMultipleKeys(ids, fkCols, itemFkCols, itemPkFields);
    }

    private Criteria buildPrefetchCriteriaSingleKey(Collection ids, String fkCol, String itemFkCol, FieldDescriptor itemPkField) {
        Criteria crit = new Criteria();
        ArrayList<Object> values = new ArrayList<Object>(ids.size());
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            Identity id = (Identity)iter.next();
            values.add(id.getPrimaryKeyValues()[0]);
        }
        switch (values.size()) {
            case 0: {
                break;
            }
            case 1: {
                crit.addEqualTo(fkCol, values.get(0));
                break;
            }
            default: {
                crit.addIn(fkCol, values);
            }
        }
        crit.addEqualToField(itemPkField.getAttributeName(), itemFkCol);
        return crit;
    }

    private Criteria buildPrefetchCriteriaMultipleKeys(Collection ids, String[] fkCols, String[] itemFkCols, FieldDescriptor[] itemPkFields) {
        Criteria crit = new Criteria();
        Criteria critValue = new Criteria();
        Iterator iter = ids.iterator();
        for (int i = 0; i < itemPkFields.length; ++i) {
            crit.addEqualToField(itemPkFields[i].getAttributeName(), itemFkCols[i]);
        }
        while (iter.hasNext()) {
            Criteria c = new Criteria();
            Identity id = (Identity)iter.next();
            Object[] val = id.getPrimaryKeyValues();
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) {
                    c.addIsNull(fkCols[i]);
                    continue;
                }
                c.addEqualTo(fkCols[i], val[i]);
            }
            critValue.addOrCriteria(c);
        }
        crit.addAndCriteria(critValue);
        return crit;
    }

    private FieldConversion[] getPkFieldConversion(ClassDescriptor cld) {
        FieldDescriptor[] pks = cld.getPkFields();
        FieldConversion[] fc = new FieldConversion[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            fc[i] = pks[i].getFieldConversion();
        }
        return fc;
    }

    private Object[] convert(FieldConversion[] fcs, Object[] values) {
        Object[] convertedValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            convertedValues[i] = fcs[i].sqlToJava(values[i]);
        }
        return convertedValues;
    }

    protected void associateBatched(Collection owners, Collection children, Collection mToNImplementors) {
        Collection list;
        Identity oid;
        CollectionDescriptor cds = this.getCollectionDescriptor();
        PersistentField field = cds.getPersistentField();
        PersistenceBrokerImpl pb = this.getBroker();
        Class ownerTopLevelClass = pb.getTopLevelClass(this.getOwnerClassDescriptor().getClassOfObject());
        Class childTopLevelClass = pb.getTopLevelClass(this.getItemClassDescriptor().getClassOfObject());
        Class collectionClass = cds.getCollectionClass();
        HashMap childMap = new HashMap();
        HashMap ownerIdsToLists = new HashMap();
        FieldConversion[] ownerFc = this.getPkFieldConversion(this.getOwnerClassDescriptor());
        FieldConversion[] childFc = this.getPkFieldConversion(this.getItemClassDescriptor());
        Iterator it = owners.iterator();
        while (it.hasNext()) {
            Object owner = it.next();
            oid = pb.serviceIdentity().buildIdentity(owner);
            ownerIdsToLists.put(oid, new ArrayList());
        }
        it = children.iterator();
        while (it.hasNext()) {
            Object child = it.next();
            oid = pb.serviceIdentity().buildIdentity(child);
            childMap.put(oid, child);
        }
        int ownerPkLen = this.getOwnerClassDescriptor().getPkFields().length;
        int childPkLen = this.getItemClassDescriptor().getPkFields().length;
        Object[] ownerPk = new Object[ownerPkLen];
        Object[] childPk = new Object[childPkLen];
        Iterator it2 = mToNImplementors.iterator();
        while (it2.hasNext()) {
            Object[] mToN = (Object[])it2.next();
            System.arraycopy(mToN, 0, ownerPk, 0, ownerPkLen);
            System.arraycopy(mToN, ownerPkLen, childPk, 0, childPkLen);
            ownerPk = this.convert(ownerFc, ownerPk);
            childPk = this.convert(childFc, childPk);
            Identity ownerId = pb.serviceIdentity().buildIdentity(null, ownerTopLevelClass, ownerPk);
            Identity childId = pb.serviceIdentity().buildIdentity(null, childTopLevelClass, childPk);
            list = (Collection)ownerIdsToLists.get(ownerId);
            Object child = childMap.get(childId);
            list.add(child);
        }
        it2 = owners.iterator();
        while (it2.hasNext()) {
            Object value;
            Object result;
            Object owner = it2.next();
            Identity ownerId = pb.serviceIdentity().buildIdentity(owner);
            list = (List)ownerIdsToLists.get(ownerId);
            if (collectionClass == null && field.getType().isArray()) {
                int length = list.size();
                Class<?> itemtype = field.getType().getComponentType();
                result = Array.newInstance(itemtype, length);
                for (int j = 0; j < length; ++j) {
                    Array.set(result, j, list.get(j));
                }
            } else {
                ManageableCollection col = this.createCollection(cds, collectionClass);
                Iterator it22 = list.iterator();
                while (it22.hasNext()) {
                    col.ojbAdd(it22.next());
                }
                result = col;
            }
            if ((value = field.get(owner)) instanceof CollectionProxyDefaultImpl && result instanceof Collection) {
                ((CollectionProxyDefaultImpl)value).setData((Collection)result);
                continue;
            }
            field.set(owner, result);
        }
    }
}

