/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.OJBIterator;

public class PagingIterator
implements OJBIterator {
    private final OJBIterator m_iterator;
    private int m_startAt;
    private int m_endAt;
    private int m_rowLimit;
    private int m_fullSize;
    private int m_currentCursorPosition;

    public PagingIterator(OJBIterator anIterator, int startAt, int endAt) {
        if (endAt != 0 && startAt > endAt) {
            throw new PersistenceBrokerException("startAt must be less than endAt.");
        }
        this.m_iterator = anIterator;
        this.m_fullSize = this.m_iterator.size();
        this.m_startAt = startAt == 0 ? 1 : startAt;
        this.m_endAt = endAt == 0 ? this.m_fullSize : Math.min(endAt, this.m_fullSize);
        this.m_rowLimit = Math.max(0, this.m_endAt - this.m_startAt + 1);
        this.m_currentCursorPosition = this.m_startAt - 1;
        this.m_iterator.absolute(this.m_currentCursorPosition);
    }

    public int size() throws PersistenceBrokerException {
        if (this.m_fullSize < this.m_rowLimit) {
            return this.m_fullSize;
        }
        return this.m_rowLimit;
    }

    public int fullSize() throws PersistenceBrokerException {
        return this.m_fullSize;
    }

    public boolean absolute(int row) throws PersistenceBrokerException {
        int newPosition = this.m_startAt - 1 + row;
        if (newPosition < this.m_startAt) {
            newPosition = Math.max(this.m_endAt + row, this.m_startAt - 1);
        }
        if (newPosition > this.m_endAt) {
            newPosition = this.m_endAt;
        }
        this.m_currentCursorPosition = newPosition;
        return this.m_iterator.absolute(newPosition);
    }

    public boolean relative(int row) throws PersistenceBrokerException {
        return this.absolute(this.m_currentCursorPosition - (this.m_startAt - 1) + row);
    }

    public void releaseDbResources() {
        this.m_iterator.releaseDbResources();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove not supported by PagingIterator");
    }

    public boolean hasNext() {
        if (this.m_currentCursorPosition < this.m_endAt) {
            return true;
        }
        this.releaseDbResources();
        return false;
    }

    public Object next() {
        ++this.m_currentCursorPosition;
        return this.m_iterator.next();
    }

    public void disableLifeCycleEvents() {
        this.m_iterator.disableLifeCycleEvents();
    }
}

