/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.StatementsForClassIF;
import org.apache.ojb.broker.accesslayer.sql.SqlGenerator;
import org.apache.ojb.broker.accesslayer.sql.SqlGeneratorFactory;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ConnectionPoolDescriptor;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.ExceptionHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class StatementsForClassImpl
implements StatementsForClassIF {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$StatementsForClassImpl == null ? (class$org$apache$ojb$broker$accesslayer$StatementsForClassImpl = StatementsForClassImpl.class$("org.apache.ojb.broker.accesslayer.StatementsForClassImpl")) : class$org$apache$ojb$broker$accesslayer$StatementsForClassImpl);
    protected final ClassDescriptor classDescriptor;
    protected final SqlGenerator sqlGenerator;
    protected final Platform platform;
    protected final Class clazz;
    protected final int fetchSize;
    private String deleteSql;
    private String insertSql;
    private String updateSql;
    private String selectByPKSql;
    protected boolean FORCEJDBC1_0 = false;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$StatementsForClassImpl;

    public StatementsForClassImpl(JdbcConnectionDescriptor jcd, ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.clazz = classDescriptor.getClassOfObject();
        this.platform = PlatformFactory.getPlatformFor(jcd);
        this.sqlGenerator = SqlGeneratorFactory.getInstance().createSqlGenerator(this.platform);
        ConnectionPoolDescriptor cpd = jcd.getConnectionPoolDescriptor();
        this.fetchSize = cpd.getFetchSize();
        double level = jcd.getJdbcLevel();
        this.FORCEJDBC1_0 = level == 1.0;
    }

    protected boolean usePreparedDeleteStatement() {
        return this.classDescriptor.getDeleteProcedure() == null || !this.classDescriptor.getDeleteProcedure().hasReturnValues();
    }

    public PreparedStatement getDeleteStmt(Connection con) throws SQLException {
        if (this.deleteSql == null) {
            this.deleteSql = this.sqlGenerator.getPreparedDeleteStatement(this.classDescriptor).getStatement();
        }
        try {
            return this.prepareStatement(con, this.deleteSql, false, this.usePreparedDeleteStatement(), -1);
        }
        catch (SQLException ex) {
            this.log.error("Can't prepare delete statement: " + this.deleteSql, ex);
            throw ex;
        }
    }

    public Statement getGenericStmt(Connection con, boolean scrollable) throws PersistenceBrokerSQLException {
        Statement stmt;
        try {
            stmt = this.createStatement(con, scrollable, 0);
        }
        catch (SQLException ex) {
            throw ExceptionHelper.generateException("Can't prepare statement:", ex, null, this.log);
        }
        return stmt;
    }

    protected boolean usePreparedInsertStatement() {
        return this.classDescriptor.getInsertProcedure() == null || !this.classDescriptor.getInsertProcedure().hasReturnValues();
    }

    public PreparedStatement getInsertStmt(Connection con) throws SQLException {
        if (this.insertSql == null) {
            this.insertSql = this.sqlGenerator.getPreparedInsertStatement(this.classDescriptor).getStatement();
        }
        try {
            return this.prepareStatement(con, this.insertSql, false, this.usePreparedInsertStatement(), -1);
        }
        catch (SQLException ex) {
            this.log.error("Can't prepare insert statement: " + this.insertSql, ex);
            throw ex;
        }
    }

    public PreparedStatement getPreparedStmt(Connection con, String sql, boolean scrollable, int explicitFetchSizeHint, boolean callableStmt) throws PersistenceBrokerSQLException {
        PreparedStatement stmt;
        try {
            stmt = this.prepareStatement(con, sql, scrollable, !callableStmt, explicitFetchSizeHint);
        }
        catch (SQLException ex) {
            throw ExceptionHelper.generateException("Can't prepare statement:", ex, sql, this.log);
        }
        return stmt;
    }

    public PreparedStatement getSelectByPKStmt(Connection con) throws SQLException {
        if (this.selectByPKSql == null) {
            this.selectByPKSql = this.sqlGenerator.getPreparedSelectByPkStatement(this.classDescriptor).getStatement();
        }
        try {
            return this.prepareStatement(con, this.selectByPKSql, false, true, 1);
        }
        catch (SQLException ex) {
            this.log.error(ex);
            throw ex;
        }
    }

    protected boolean usePreparedUpdateStatement() {
        return this.classDescriptor.getUpdateProcedure() == null || !this.classDescriptor.getUpdateProcedure().hasReturnValues();
    }

    public PreparedStatement getUpdateStmt(Connection con) throws SQLException {
        if (this.updateSql == null) {
            this.updateSql = this.sqlGenerator.getPreparedUpdateStatement(this.classDescriptor).getStatement();
        }
        try {
            return this.prepareStatement(con, this.updateSql, false, this.usePreparedUpdateStatement(), -1);
        }
        catch (SQLException ex) {
            this.log.error("Can't prepare update statement: " + this.updateSql, ex);
            throw ex;
        }
    }

    protected PreparedStatement prepareStatement(Connection con, String sql, boolean scrollable, boolean createPreparedStatement, int explicitFetchSizeHint) throws SQLException {
        PreparedStatement result;
        try {
            if (!this.FORCEJDBC1_0) {
                if (createPreparedStatement) {
                    result = con.prepareStatement(sql, scrollable ? 1004 : 1003, 1007);
                    this.afterJdbc2CapableStatementCreate(result, explicitFetchSizeHint);
                } else {
                    result = con.prepareCall(sql, scrollable ? 1004 : 1003, 1007);
                }
            } else {
                result = createPreparedStatement ? con.prepareStatement(sql) : con.prepareCall(sql);
            }
        }
        catch (AbstractMethodError err) {
            this.log.warn("Used driver seems not JDBC 2.0 compatible, use the JDBC 1.0 mode", err);
            result = createPreparedStatement ? con.prepareStatement(sql) : con.prepareCall(sql);
            this.FORCEJDBC1_0 = true;
        }
        catch (SQLException eSql) {
            if (eSql.getClass().getName().equals("interbase.interclient.DriverNotCapableException")) {
                this.log.warn("JDBC 2.0 problems with this interbase driver, we use the JDBC 1.0 mode");
                result = createPreparedStatement ? con.prepareStatement(sql) : con.prepareCall(sql);
                this.FORCEJDBC1_0 = true;
            }
            throw eSql;
        }
        try {
            if (!ProxyHelper.isNormalOjbProxy(result)) {
                this.platform.afterStatementCreate(result);
            }
        }
        catch (PlatformException e) {
            this.log.error("Platform dependend failure", (Throwable)((Object)e));
        }
        return result;
    }

    private Statement createStatement(Connection con, boolean scrollable, int explicitFetchSizeHint) throws SQLException {
        Statement result;
        try {
            if (!this.FORCEJDBC1_0) {
                result = con.createStatement(scrollable ? 1004 : 1003, 1007);
                this.afterJdbc2CapableStatementCreate(result, explicitFetchSizeHint);
            } else {
                result = con.createStatement();
            }
        }
        catch (AbstractMethodError err) {
            this.log.warn("Used driver seems not JDBC 2.0 compatible, use the JDBC 1.0 mode", err);
            result = con.createStatement();
            this.FORCEJDBC1_0 = true;
        }
        catch (SQLException eSql) {
            if (eSql.getClass().getName().equals("interbase.interclient.DriverNotCapableException")) {
                this.log.warn("JDBC 2.0 problems with this interbase driver, we use the JDBC 1.0 mode");
                this.FORCEJDBC1_0 = true;
                result = con.createStatement();
            }
            throw eSql;
        }
        try {
            this.platform.afterStatementCreate(result);
        }
        catch (PlatformException e) {
            this.log.error("Platform dependend failure", (Throwable)((Object)e));
        }
        return result;
    }

    private void afterJdbc2CapableStatementCreate(Statement stmt, int explicitFetchSizeHint) throws SQLException {
        int fetchSizeHint;
        if (stmt != null && (fetchSizeHint = explicitFetchSizeHint == -1 ? -1 : (explicitFetchSizeHint != 0 ? explicitFetchSizeHint : this.fetchSize)) > 0) {
            stmt.setFetchSize(this.fetchSize);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

