/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceIdentityMap;
import org.apache.ojb.broker.accesslayer.sql.SelectStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteByPkStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteByQuery;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlExistStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlGenerator;
import org.apache.ojb.broker.accesslayer.sql.SqlInsertMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlInsertStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlProcedureStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectByPkStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlUpdateStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DeleteProcedureDescriptor;
import org.apache.ojb.broker.metadata.InsertProcedureDescriptor;
import org.apache.ojb.broker.metadata.UpdateProcedureDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.BetweenCriteria;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.ExistsCriteria;
import org.apache.ojb.broker.query.FieldCriteria;
import org.apache.ojb.broker.query.InCriteria;
import org.apache.ojb.broker.query.NullCriteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.query.SqlCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class SqlGeneratorDefaultImpl
implements SqlGenerator {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl == null ? (class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl = SqlGeneratorDefaultImpl.class$("org.apache.ojb.broker.accesslayer.sql.SqlGeneratorDefaultImpl")) : class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl);
    private Platform m_platform;
    private Map sqlForClass = new ReferenceIdentityMap(2, 0);
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl;

    public SqlGeneratorDefaultImpl(Platform platform) {
        this.m_platform = platform;
    }

    public SqlStatement getPreparedDeleteStatement(ClassDescriptor cld) {
        SqlForClass sfc = this.getSqlForClass(cld);
        SqlStatement sql = sfc.getDeleteSql();
        if (sql == null) {
            DeleteProcedureDescriptor pd = cld.getDeleteProcedure();
            sql = pd == null ? new SqlDeleteByPkStatement(cld, this.logger) : new SqlProcedureStatement(pd, this.logger);
            sfc.setDeleteSql(sql);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + sql.getStatement());
            }
        }
        return sql;
    }

    public SqlStatement getPreparedInsertStatement(ClassDescriptor cld) {
        SqlForClass sfc = this.getSqlForClass(cld);
        SqlStatement sql = sfc.getInsertSql();
        if (sql == null) {
            InsertProcedureDescriptor pd = cld.getInsertProcedure();
            sql = pd == null ? new SqlInsertStatement(cld, this.logger) : new SqlProcedureStatement(pd, this.logger);
            sfc.setInsertSql(sql);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + sql.getStatement());
            }
        }
        return sql;
    }

    public SelectStatement getPreparedSelectByPkStatement(ClassDescriptor cld) {
        SqlForClass sfc = this.getSqlForClass(cld);
        SelectStatement sql = sfc.getSelectByPKSql();
        if (sql == null) {
            sql = new SqlSelectByPkStatement(this.m_platform, cld, this.logger);
            sfc.setSelectByPKSql(sql);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + sql.getStatement());
            }
        }
        return sql;
    }

    public SqlStatement getPreparedExistsStatement(ClassDescriptor cld) {
        SqlForClass sfc = this.getSqlForClass(cld);
        SqlStatement sql = sfc.getSelectExists();
        if (sql == null) {
            sql = new SqlExistStatement(cld, this.logger);
            sfc.setSelectExists(sql);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + sql.getStatement());
            }
        }
        return sql;
    }

    public SelectStatement getPreparedSelectStatement(Query query, ClassDescriptor cld) {
        SqlSelectStatement sql = new SqlSelectStatement(this.m_platform, cld, query, this.logger);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + sql.getStatement());
        }
        return sql;
    }

    public SqlStatement getPreparedUpdateStatement(ClassDescriptor cld) {
        SqlForClass sfc = this.getSqlForClass(cld);
        SqlStatement result = sfc.getUpdateSql();
        if (result == null) {
            UpdateProcedureDescriptor pd = cld.getUpdateProcedure();
            result = pd == null ? new SqlUpdateStatement(cld, this.logger) : new SqlProcedureStatement(pd, this.logger);
            sfc.setUpdateSql(result);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + result.getStatement());
            }
        }
        return result;
    }

    public String getInsertMNStatement(String table, String[] pkColumns1, String[] pkColumns2) {
        String[] cols = new String[pkColumns1.length + pkColumns2.length];
        System.arraycopy(pkColumns1, 0, cols, 0, pkColumns1.length);
        System.arraycopy(pkColumns2, 0, cols, pkColumns1.length, pkColumns2.length);
        SqlInsertMNStatement sql = new SqlInsertMNStatement(table, cols, this.logger);
        String result = sql.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + result);
        }
        return result;
    }

    public String getSelectMNStatement(String table, String[] selectColumns, String[] columns) {
        SqlSelectMNStatement sql = new SqlSelectMNStatement(table, selectColumns, columns, this.logger);
        String result = sql.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + result);
        }
        return result;
    }

    public String getDeleteMNStatement(String table, String[] pkColumns1, String[] pkColumns2) {
        String[] cols;
        if (pkColumns2 == null) {
            cols = pkColumns1;
        } else {
            cols = new String[pkColumns1.length + pkColumns2.length];
            System.arraycopy(pkColumns1, 0, cols, 0, pkColumns1.length);
            System.arraycopy(pkColumns2, 0, cols, pkColumns1.length, pkColumns2.length);
        }
        SqlDeleteMNStatement sql = new SqlDeleteMNStatement(table, cols, this.logger);
        String result = sql.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + result);
        }
        return result;
    }

    public SelectStatement getSelectStatementDep(Query query, ClassDescriptor cld) {
        return this.getPreparedSelectStatement(query, cld);
    }

    public String asSQLStatement(Criteria crit, ClassDescriptor cld) {
        Enumeration e = crit.getElements();
        StringBuffer statement = new StringBuffer();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Criteria) {
                String addAtEnd;
                String addAtStart;
                Criteria pc = (Criteria)o;
                if (pc.isEmbraced()) {
                    addAtStart = " (";
                    addAtEnd = ") ";
                } else {
                    addAtStart = "";
                    addAtEnd = "";
                }
                switch (pc.getType()) {
                    case 0: {
                        statement.append(" OR ").append(addAtStart);
                        statement.append(this.asSQLStatement(pc, cld));
                        statement.append(addAtEnd);
                        break;
                    }
                    case 1: {
                        statement.insert(0, "( ");
                        statement.append(") ");
                        statement.append(" AND ").append(addAtStart);
                        statement.append(this.asSQLStatement(pc, cld));
                        statement.append(addAtEnd);
                    }
                }
                continue;
            }
            SelectionCriteria c = (SelectionCriteria)o;
            if (statement.length() == 0) {
                statement.append(this.asSQLClause(c, cld));
                continue;
            }
            statement.insert(0, "(");
            statement.append(") ");
            statement.append(" AND ");
            statement.append(this.asSQLClause(c, cld));
        }
        if (statement.length() == 0) {
            return null;
        }
        return statement.toString();
    }

    protected String asSQLClause(SelectionCriteria c, ClassDescriptor cld) {
        if (c instanceof FieldCriteria) {
            return this.toSQLClause((FieldCriteria)c, cld);
        }
        if (c instanceof NullCriteria) {
            return this.toSQLClause((NullCriteria)c);
        }
        if (c instanceof BetweenCriteria) {
            return this.toSQLClause((BetweenCriteria)c, cld);
        }
        if (c instanceof InCriteria) {
            return this.toSQLClause((InCriteria)c);
        }
        if (c instanceof SqlCriteria) {
            return this.toSQLClause((SqlCriteria)c);
        }
        if (c instanceof ExistsCriteria) {
            return this.toSQLClause((ExistsCriteria)c, cld);
        }
        return this.toSQLClause(c, cld);
    }

    private String toSqlClause(Object attributeOrQuery, ClassDescriptor cld) {
        String result;
        if (attributeOrQuery instanceof Query) {
            Query q = (Query)attributeOrQuery;
            result = this.getPreparedSelectStatement(q, cld.getRepository().getDescriptorFor(q.getSearchClass())).getStatement();
        } else {
            result = (String)attributeOrQuery;
        }
        return result;
    }

    private String toSQLClause(NullCriteria c) {
        String colName = (String)c.getAttribute();
        return colName + c.getClause();
    }

    private String toSQLClause(FieldCriteria c, ClassDescriptor cld) {
        String colName = this.toSqlClause(c.getAttribute(), cld);
        return colName + c.getClause() + c.getValue();
    }

    private String toSQLClause(BetweenCriteria c, ClassDescriptor cld) {
        String colName = this.toSqlClause(c.getAttribute(), cld);
        return colName + c.getClause() + " ? AND ? ";
    }

    private String toSQLClause(InCriteria c) {
        StringBuffer buf = new StringBuffer();
        Collection values = (Collection)c.getValue();
        int size = values.size();
        buf.append(c.getAttribute());
        buf.append(c.getClause());
        buf.append("(");
        for (int i = 0; i < size - 1; ++i) {
            buf.append("?,");
        }
        buf.append("?)");
        return buf.toString();
    }

    private String toSQLClause(SelectionCriteria c, ClassDescriptor cld) {
        String colName = this.toSqlClause(c.getAttribute(), cld);
        return colName + c.getClause() + " ? ";
    }

    private String toSQLClause(SqlCriteria c) {
        return c.getClause();
    }

    private String toSQLClause(ExistsCriteria c, ClassDescriptor cld) {
        StringBuffer buf = new StringBuffer();
        Query subQuery = (Query)c.getValue();
        buf.append(c.getClause());
        buf.append(" (");
        if (cld != null) {
            buf.append(this.getPreparedSelectStatement(subQuery, cld.getRepository().getDescriptorFor(subQuery.getSearchClass())));
        } else {
            buf.append(subQuery);
        }
        buf.append(")");
        return buf.toString();
    }

    public SqlStatement getPreparedDeleteStatement(Query query, ClassDescriptor cld) {
        return new SqlDeleteByQuery(this.m_platform, cld, query, this.logger);
    }

    public Platform getPlatform() {
        return this.m_platform;
    }

    protected SqlForClass getSqlForClass(ClassDescriptor cld) {
        SqlForClass result = (SqlForClass)this.sqlForClass.get(cld);
        if (result == null) {
            result = this.newInstanceSqlForClass();
            this.sqlForClass.put(cld, result);
        }
        return result;
    }

    protected SqlForClass newInstanceSqlForClass() {
        return new SqlForClass();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SqlForClass {
        private SqlStatement deleteSql;
        private SqlStatement insertSql;
        private SqlStatement updateSql;
        private SelectStatement selectByPKSql;
        private SqlStatement selectExists;

        public SqlStatement getDeleteSql() {
            return this.deleteSql;
        }

        public void setDeleteSql(SqlStatement deleteSql) {
            this.deleteSql = deleteSql;
        }

        public SqlStatement getInsertSql() {
            return this.insertSql;
        }

        public void setInsertSql(SqlStatement insertSql) {
            this.insertSql = insertSql;
        }

        public SqlStatement getUpdateSql() {
            return this.updateSql;
        }

        public void setUpdateSql(SqlStatement updateSql) {
            this.updateSql = updateSql;
        }

        public SelectStatement getSelectByPKSql() {
            return this.selectByPKSql;
        }

        public void setSelectByPKSql(SelectStatement selectByPKSql) {
            this.selectByPKSql = selectByPKSql;
        }

        public SqlStatement getSelectExists() {
            return this.selectExists;
        }

        public void setSelectExists(SqlStatement selectExists) {
            this.selectExists = selectExists;
        }
    }
}

