/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.ojb.broker.accesslayer.sql.SelectStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlQueryStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQuery;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;

public class SqlSelectStatement
extends SqlQueryStatement
implements SelectStatement {
    private WeakReference fieldsForSelect;

    public SqlSelectStatement(Platform pf, ClassDescriptor cld, Query query, Logger logger) {
        super(pf, cld, query, logger);
    }

    public SqlSelectStatement(SqlQueryStatement parent, Platform pf, ClassDescriptor cld, Query query, Logger logger) {
        super(parent, pf, cld, query, logger);
    }

    protected void appendColumn(SqlQueryStatement.TableAlias anAlias, FieldDescriptor field, StringBuffer buf) {
        buf.append(anAlias.alias);
        buf.append(".");
        buf.append(field.getColumnName());
    }

    protected List appendListOfColumnsForSelect(StringBuffer buf) {
        FieldDescriptor[] fieldDescriptors = this.getFieldsForSelect();
        ArrayList<String> columnList = new ArrayList<String>();
        SqlQueryStatement.TableAlias searchAlias = this.getSearchTable();
        for (int i = 0; i < fieldDescriptors.length; ++i) {
            FieldDescriptor field = fieldDescriptors[i];
            SqlQueryStatement.TableAlias alias = this.getTableAliasForClassDescriptor(field.getClassDescriptor());
            if (alias == null) {
                alias = searchAlias;
            }
            if (i > 0) {
                buf.append(",");
            }
            this.appendColumn(alias, field, buf);
            columnList.add(field.getAttributeName());
        }
        this.appendClazzColumnForSelect(buf);
        return columnList;
    }

    private ClassDescriptor[] getMultiJoinedClassDescriptors(ClassDescriptor cld) {
        DescriptorRepository repository = cld.getRepository();
        Class[] multiJoinedClasses = repository.getSubClassesMultipleJoinedTables(cld, true);
        ClassDescriptor[] result = new ClassDescriptor[multiJoinedClasses.length];
        for (int i = 0; i < multiJoinedClasses.length; ++i) {
            result[i] = repository.getDescriptorFor(multiJoinedClasses[i]);
        }
        return result;
    }

    private void appendClazzColumnForSelect(StringBuffer buf) {
        ClassDescriptor cld = this.getSearchClassDescriptor();
        ClassDescriptor[] clds = this.getMultiJoinedClassDescriptors(cld);
        if (clds.length == 0) {
            return;
        }
        buf.append(",CASE");
        for (int i = clds.length; i > 0; --i) {
            buf.append(" WHEN ");
            ClassDescriptor subCld = clds[i - 1];
            FieldDescriptor[] fieldDescriptors = subCld.getPkFields();
            SqlQueryStatement.TableAlias alias = this.getTableAliasForClassDescriptor(subCld);
            for (int j = 0; j < fieldDescriptors.length; ++j) {
                FieldDescriptor field = fieldDescriptors[j];
                if (j > 0) {
                    buf.append(" AND ");
                }
                this.appendColumn(alias, field, buf);
                buf.append(" IS NOT NULL");
            }
            buf.append(" THEN '").append(subCld.getClassNameOfObject()).append("'");
        }
        buf.append(" ELSE '").append(cld.getClassNameOfObject()).append("'");
        buf.append(" END AS OJB_CLAZZ");
    }

    protected FieldDescriptor[] getFieldsForSelect() {
        if (this.fieldsForSelect == null || this.fieldsForSelect.get() == null) {
            this.fieldsForSelect = new WeakReference<FieldDescriptor[]>(this.buildFieldsForSelect(this.getSearchClassDescriptor()));
        }
        return (FieldDescriptor[])this.fieldsForSelect.get();
    }

    protected FieldDescriptor[] buildFieldsForSelect(ClassDescriptor cld) {
        int i;
        DescriptorRepository repository = cld.getRepository();
        ListOrderedSet fields = new ListOrderedSet();
        FieldDescriptor[] fds = repository.getFieldDescriptorsForMultiMappedTable(cld);
        for (i = 0; i < fds.length; ++i) {
            fields.add(fds[i]);
        }
        fds = cld.getFieldDescriptor(true);
        for (i = 0; i < fds.length; ++i) {
            fields.add(fds[i]);
        }
        Class[] multiJoinedClasses = repository.getSubClassesMultipleJoinedTables(cld, true);
        for (int c = 0; c < multiJoinedClasses.length; ++c) {
            ClassDescriptor subCld = repository.getDescriptorFor(multiJoinedClasses[c]);
            fds = subCld.getFieldDescriptions();
            for (int i2 = 0; i2 < fds.length; ++i2) {
                fields.add(fds[i2]);
            }
        }
        FieldDescriptor[] result = new FieldDescriptor[fields.size()];
        fields.toArray(result);
        return result;
    }

    protected List appendListOfColumns(String[] columns, StringBuffer buf) {
        ArrayList<String> columnList = new ArrayList<String>();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            this.appendColName(columns[i], false, null, buf);
            columnList.add(columns[i]);
        }
        return columnList;
    }

    protected String buildStatement() {
        StringBuffer stmt = new StringBuffer(1024);
        QueryByCriteria query = this.getQuery();
        boolean first = true;
        List orderByFields = null;
        String[] attributes = null;
        String[] joinAttributes = null;
        Iterator it = this.getJoinTreeToCriteria().entrySet().iterator();
        List columnList = new ArrayList();
        if (query instanceof ReportQuery) {
            attributes = ((ReportQuery)((Object)query)).getAttributes();
            joinAttributes = ((ReportQuery)((Object)query)).getJoinAttributes();
        }
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Criteria whereCrit = (Criteria)entry.getValue();
            Criteria havingCrit = query.getHavingCriteria();
            StringBuffer where = new StringBuffer();
            StringBuffer having = new StringBuffer();
            this.setRoot((SqlQueryStatement.TableAlias)entry.getKey());
            if (whereCrit != null && whereCrit.isEmpty()) {
                whereCrit = null;
            }
            if (havingCrit != null && havingCrit.isEmpty()) {
                havingCrit = null;
            }
            if (first) {
                first = false;
            } else {
                stmt.append(" UNION ");
            }
            stmt.append("SELECT ");
            if (query.isDistinct()) {
                stmt.append("DISTINCT ");
            }
            if (attributes == null || attributes.length == 0) {
                columnList.addAll(this.appendListOfColumnsForSelect(stmt));
            } else {
                columnList.addAll(this.appendListOfColumns(attributes, stmt));
            }
            if (joinAttributes != null && joinAttributes.length > 0) {
                for (int i = 0; i < joinAttributes.length; ++i) {
                    this.getAttributeInfo(joinAttributes[i], false, null, this.getQuery().getPathClasses());
                }
            }
            List groupByFields = query.getGroupBy();
            this.ensureColumns(groupByFields, columnList);
            orderByFields = query.getOrderBy();
            columnList = this.ensureColumns(orderByFields, columnList, stmt);
            ClassDescriptor cld = this.getBaseClassDescriptor();
            ClassDescriptor cldSuper = null;
            if (cld.getSuperClass() != null) {
                cldSuper = cld.getRepository().getDescriptorFor(cld.getSuperClass());
                this.appendSuperClassColumns(cldSuper, stmt);
            }
            stmt.append(" FROM ");
            this.appendTableWithJoins(this.getRoot(), where, stmt);
            if (cld.getSuperClass() != null) {
                this.appendSuperClassJoin(cld, cldSuper, stmt, where);
            }
            this.appendWhereClause(where, whereCrit, stmt);
            this.appendGroupByClause(groupByFields, stmt);
            this.appendHavingClause(having, havingCrit, stmt);
        }
        this.appendOrderByClause(orderByFields, columnList, stmt);
        if (query instanceof ReportQueryByCriteria) {
            ((ReportQueryByCriteria)query).setAttributeFieldDescriptors(this.m_attrToFld);
        }
        return stmt.toString();
    }

    private void appendSuperClassJoin(ClassDescriptor cld, ClassDescriptor cldSuper, StringBuffer stmt, StringBuffer where) {
        stmt.append(",");
        this.appendTable(cldSuper, stmt);
        if (where != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            int superFieldRef = cld.getSuperClassFieldRef();
            FieldDescriptor refField = cld.getFieldDescriptorByIndex(superFieldRef);
            this.appendTable(cldSuper, where);
            where.append(".");
            this.appendField(cldSuper.getAutoIncrementFields()[0], where);
            where.append(" = ");
            this.appendTable(cld, where);
            where.append(".");
            this.appendField(refField, where);
        }
    }

    private void appendSuperClassColumns(ClassDescriptor cldSuper, StringBuffer buf) {
        FieldDescriptor[] fields = cldSuper.getFieldDescriptions();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor field = fields[i];
            if (i > 0) {
                buf.append(",");
            }
            buf.append(cldSuper.getFullTableName());
            buf.append(".");
            buf.append(field.getColumnName());
        }
    }

    protected void appendTable(ClassDescriptor cld, StringBuffer buf) {
        buf.append(cld.getFullTableName());
    }

    protected void appendField(FieldDescriptor fld, StringBuffer buf) {
        buf.append(fld.getColumnName());
    }

    public Query getQueryInstance() {
        return this.getQuery();
    }

    public int getColumnIndex(FieldDescriptor fld) {
        int index = Integer.MIN_VALUE;
        FieldDescriptor[] fields = this.getFieldsForSelect();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equals(fld)) continue;
                index = i + 1;
                break;
            }
        }
        return index;
    }
}

