/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.RuleSetBase;
import org.apache.commons.digester.Rules;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ojb.broker.ant.DataSet;
import org.apache.ojb.broker.ant.DataTaskException;
import org.apache.ojb.broker.ant.PreparedModel;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DdlUtilsDataHandling {
    private Database _dbModel;
    private Platform _platform;
    private PreparedModel _preparedModel;
    private Digester _digester = new Digester();
    static /* synthetic */ Class class$org$apache$ojb$broker$ant$DataSet;

    public DdlUtilsDataHandling() {
        this._digester.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        });
        this._digester.setNamespaceAware(true);
        this._digester.setValidating(false);
        this._digester.setUseContextClassLoader(true);
        this._digester.setRules((Rules)new ExtendedBaseRules());
        this._digester.addRuleSet((RuleSet)new DataRuleSet());
    }

    public void setModel(Database databaseModel, DescriptorRepository objModel) {
        this._dbModel = databaseModel;
        this._preparedModel = new PreparedModel(objModel, databaseModel);
    }

    public void setPlatform(Platform platform) {
        this._platform = platform;
    }

    public void getDataDTD(Writer output) throws DataTaskException {
        try {
            String elementName;
            output.write("<!ELEMENT dataset (\n");
            Iterator it = this._preparedModel.getElementNames();
            while (it.hasNext()) {
                elementName = (String)it.next();
                output.write("    ");
                output.write(elementName);
                output.write("*");
                output.write(it.hasNext() ? " |\n" : "\n");
            }
            output.write(")>\n<!ATTLIST dataset\n    name CDATA #REQUIRED\n>\n");
            it = this._preparedModel.getElementNames();
            while (it.hasNext()) {
                elementName = (String)it.next();
                List classDescs = this._preparedModel.getClassDescriptorsMappingTo(elementName);
                if (classDescs == null) {
                    output.write("\n<!-- Indirection table");
                } else {
                    output.write("\n<!-- Mapped to : ");
                    Iterator classDescIt = classDescs.iterator();
                    while (classDescIt.hasNext()) {
                        ClassDescriptor classDesc = (ClassDescriptor)classDescIt.next();
                        output.write(classDesc.getClassNameOfObject());
                        if (!classDescIt.hasNext()) continue;
                        output.write("\n                 ");
                    }
                }
                output.write(" -->\n<!ELEMENT ");
                output.write(elementName);
                output.write(" EMPTY>\n<!ATTLIST ");
                output.write(elementName);
                output.write("\n");
                Iterator attrIt = this._preparedModel.getAttributeNames(elementName);
                while (attrIt.hasNext()) {
                    String attrName = (String)attrIt.next();
                    output.write("    ");
                    output.write(attrName);
                    output.write(" CDATA #");
                    output.write(this._preparedModel.isRequired(elementName, attrName) ? "REQUIRED" : "IMPLIED");
                    output.write("\n");
                }
                output.write(">\n");
            }
        }
        catch (IOException ex) {
            throw new DataTaskException(ex);
        }
    }

    public void getInsertDataSql(Reader input, Writer output) throws DataTaskException {
        try {
            DataSet set = (DataSet)this._digester.parse(input);
            set.createInsertionSql(this._dbModel, this._platform, output);
        }
        catch (Exception ex) {
            if (ex instanceof DataTaskException) {
                throw (DataTaskException)((Object)ex);
            }
            throw new DataTaskException(ex);
        }
    }

    public void insertData(Reader input, int batchSize) throws DataTaskException {
        try {
            DataSet set = (DataSet)this._digester.parse(input);
            set.insert(this._platform, this._dbModel, batchSize);
        }
        catch (Exception ex) {
            if (ex instanceof DataTaskException) {
                throw (DataTaskException)((Object)ex);
            }
            throw new DataTaskException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class DataRuleSet
    extends RuleSetBase {
        public void addRuleInstances(Digester digester) {
            digester.addObjectCreate("dataset", class$org$apache$ojb$broker$ant$DataSet == null ? (class$org$apache$ojb$broker$ant$DataSet = DdlUtilsDataHandling.class$("org.apache.ojb.broker.ant.DataSet")) : class$org$apache$ojb$broker$ant$DataSet);
            digester.addRule("*/dataset/*", (Rule)new DynaFactoryCreateRule());
        }
    }

    private class DynaFactoryCreateRule
    extends Rule {
        private DynaFactoryCreateRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            DynaBean bean = DdlUtilsDataHandling.this._preparedModel.createBeanFor(name);
            if (bean == null) {
                throw new DataTaskException("Unknown element " + name);
            }
            for (int idx = 0; idx < attributes.getLength(); ++idx) {
                String attrName = attributes.getLocalName(idx);
                String attrValue = attributes.getValue(idx);
                Column column = DdlUtilsDataHandling.this._preparedModel.getColumnFor(name, attrName);
                if (column == null) {
                    throw new DataTaskException("Unknown attribute " + attrName + " of element " + name);
                }
                bean.set(column.getName(), (Object)attrValue);
            }
            DdlUtilsDataHandling.this._digester.push((Object)bean);
        }

        public void end(String namespace, String name) throws Exception {
            DynaBean bean = (DynaBean)DdlUtilsDataHandling.this._digester.pop();
            ((DataSet)DdlUtilsDataHandling.this._digester.peek()).add(bean);
        }
    }
}

