/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.beanutils.DynaBean;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;

public class PreparedModel {
    private Database _schema;
    private TreeMap _elementToTable = new TreeMap();
    private HashMap _elementToClassDescriptors = new HashMap();
    private HashMap _elementToColumnMap = new HashMap();
    private HashMap _elementToRequiredAttributesMap = new HashMap();

    public PreparedModel(DescriptorRepository model, Database schema) {
        this._schema = schema;
        this.prepareModel(model);
    }

    public Iterator getElementNames() {
        return this._elementToTable.keySet().iterator();
    }

    public Iterator getAttributeNames(String elementName) {
        Map columns = this.getColumnsFor(elementName);
        return columns == null ? null : columns.keySet().iterator();
    }

    public Map getRequiredAttributes(String elementName) {
        return (Map)this._elementToRequiredAttributesMap.get(elementName);
    }

    public boolean isRequired(String elementName, String attributeName) {
        Map requiredAttributes = this.getRequiredAttributes(elementName);
        if (requiredAttributes == null) {
            return false;
        }
        Boolean status = (Boolean)requiredAttributes.get(attributeName);
        return status == null ? false : status;
    }

    public Table getTableFor(String elementName) {
        return (Table)this._elementToTable.get(elementName);
    }

    public DynaBean createBeanFor(String elementName) {
        return this._schema.createDynaBeanFor(this.getTableFor(elementName));
    }

    public List getClassDescriptorsMappingTo(String elementName) {
        return (List)this._elementToClassDescriptors.get(elementName);
    }

    public Map getColumnsFor(String elementName) {
        return (Map)this._elementToColumnMap.get(elementName);
    }

    public Column getColumnFor(String elementName, String attrName) {
        Map columns = this.getColumnsFor(elementName);
        if (columns == null) {
            return null;
        }
        return (Column)columns.get(attrName);
    }

    private void prepareModel(DescriptorRepository model) {
        TreeMap result = new TreeMap();
        Iterator it = model.getDescriptorTable().values().iterator();
        while (it.hasNext()) {
            ClassDescriptor classDesc = (ClassDescriptor)it.next();
            if (classDesc.getFullTableName() == null) continue;
            String elementName = this.getElementName(classDesc);
            Table mappedTable = this.getTableFor(elementName);
            TreeMap columnsMap = this.getColumnsFor(elementName);
            HashMap requiredAttributes = this.getRequiredAttributes(elementName);
            ArrayList<ClassDescriptor> classDescs = this.getClassDescriptorsMappingTo(elementName);
            if (mappedTable == null) {
                mappedTable = this._schema.findTable(classDesc.getFullTableName());
                if (mappedTable == null) continue;
                columnsMap = new TreeMap();
                requiredAttributes = new HashMap();
                classDescs = new ArrayList<ClassDescriptor>();
                this._elementToTable.put(elementName, mappedTable);
                this._elementToClassDescriptors.put(elementName, classDescs);
                this._elementToColumnMap.put(elementName, columnsMap);
                this._elementToRequiredAttributesMap.put(elementName, requiredAttributes);
            }
            classDescs.add(classDesc);
            this.extractAttributes(classDesc, mappedTable, columnsMap, requiredAttributes);
        }
        this.extractIndirectionTables(model, this._schema);
    }

    private void extractAttributes(ClassDescriptor classDesc, Table mappedTable, Map columnsMap, Map requiredColumnsMap) {
        FieldDescriptor[] fieldDescs = classDesc.getFieldDescriptions();
        if (fieldDescs != null) {
            for (int idx = 0; idx < fieldDescs.length; ++idx) {
                Column column = mappedTable.findColumn(fieldDescs[idx].getColumnName());
                if (column == null) continue;
                boolean alreadyMapped = false;
                Iterator mappedColumnsIt = columnsMap.values().iterator();
                while (mappedColumnsIt.hasNext()) {
                    if (!column.equals(mappedColumnsIt.next())) continue;
                    alreadyMapped = true;
                    break;
                }
                if (alreadyMapped) continue;
                String shortAttrName = this.getShortAttributeName(fieldDescs[idx].getAttributeName());
                columnsMap.put(shortAttrName, column);
                requiredColumnsMap.put(shortAttrName, fieldDescs[idx].isPrimaryKey() ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    private void extractIndirectionTables(DescriptorRepository model, Database schema) {
        HashMap<String, HashSet<String>> indirectionTables = new HashMap<String, HashSet<String>>();
        Iterator classDescIt = model.getDescriptorTable().values().iterator();
        while (classDescIt.hasNext()) {
            ClassDescriptor classDesc = (ClassDescriptor)classDescIt.next();
            Iterator collDescIt = classDesc.getCollectionDescriptors().iterator();
            while (collDescIt.hasNext()) {
                CollectionDescriptor collDesc = (CollectionDescriptor)collDescIt.next();
                String indirTable = collDesc.getIndirectionTable();
                if (indirTable == null || indirTable.length() <= 0) continue;
                HashSet<String> columns = (HashSet<String>)indirectionTables.get(indirTable);
                if (columns == null) {
                    columns = new HashSet<String>();
                    indirectionTables.put(indirTable, columns);
                }
                columns.addAll(Arrays.asList(collDesc.getFksToThisClass()));
                columns.addAll(Arrays.asList(collDesc.getFksToItemClass()));
            }
        }
        if (indirectionTables.isEmpty()) {
            return;
        }
        Iterator it = indirectionTables.keySet().iterator();
        while (it.hasNext()) {
            String tableName = (String)it.next();
            Set columns = (Set)indirectionTables.get(tableName);
            String elementName = tableName;
            Iterator classDescIt2 = model.getDescriptorTable().values().iterator();
            while (classDescIt2.hasNext()) {
                ClassDescriptor classDesc = (ClassDescriptor)classDescIt2.next();
                if (!tableName.equals(classDesc.getFullTableName())) continue;
                elementName = this.getElementName(classDesc);
                FieldDescriptor[] fieldDescs = classDesc.getFieldDescriptions();
                if (fieldDescs == null) continue;
                for (int idx = 0; idx < fieldDescs.length; ++idx) {
                    columns.remove(fieldDescs[idx].getColumnName());
                }
            }
            Table mappedTable = this.getTableFor(elementName);
            TreeMap<String, Column> columnsMap = this.getColumnsFor(elementName);
            HashMap<String, Boolean> requiredAttributes = this.getRequiredAttributes(elementName);
            if (mappedTable == null) {
                mappedTable = schema.findTable(elementName);
                if (mappedTable == null) continue;
                columnsMap = new TreeMap<String, Column>();
                requiredAttributes = new HashMap<String, Boolean>();
                this._elementToTable.put(elementName, mappedTable);
                this._elementToColumnMap.put(elementName, columnsMap);
                this._elementToRequiredAttributesMap.put(elementName, requiredAttributes);
            }
            Iterator columnIt = columns.iterator();
            while (columnIt.hasNext()) {
                String columnName = (String)columnIt.next();
                Column column = mappedTable.findColumn(columnName);
                if (column == null) continue;
                columnsMap.put(columnName, column);
                requiredAttributes.put(columnName, Boolean.TRUE);
            }
        }
    }

    private String getElementName(ClassDescriptor classDesc) {
        String elementName = classDesc.getClassNameOfObject().replace('$', '_');
        elementName = elementName.substring(elementName.lastIndexOf(46) + 1);
        Table table = this.getTableFor(elementName);
        int suffix = 0;
        while (table != null && !table.getName().equals(classDesc.getFullTableName())) {
            table = this.getTableFor(elementName + "-" + ++suffix);
        }
        if (suffix > 0) {
            elementName = elementName + "-" + suffix;
        }
        return elementName;
    }

    private String getShortAttributeName(String attrName) {
        return attrName.substring(attrName.lastIndexOf(58) + 1);
    }
}

