/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ddlutils.model.Database;
import org.apache.ojb.broker.ant.Command;
import org.apache.ojb.broker.ant.DdlUtilsDataHandling;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class WriteDataSqlToFileCommand
extends Command {
    private File _singleDataFile = null;
    private ArrayList _fileSets = new ArrayList();
    private File _outputFile;

    public void addConfiguredFileset(FileSet fileset) {
        this._fileSets.add(fileset);
    }

    public void setDataFile(File dataFile) {
        this._singleDataFile = dataFile;
    }

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    public void execute(Task task, Database dbModel, DescriptorRepository objModel) throws BuildException {
        try {
            DdlUtilsDataHandling handling = new DdlUtilsDataHandling();
            PrintWriter writer = new PrintWriter((Writer)new FileWriter(this._outputFile), true);
            handling.setModel(dbModel, objModel);
            handling.setPlatform(this.getPlatform());
            if (this._singleDataFile != null) {
                this.readSingleDataFile(task, handling, this._singleDataFile, writer);
            } else {
                Iterator it = this._fileSets.iterator();
                while (it.hasNext()) {
                    FileSet fileSet = (FileSet)it.next();
                    File fileSetDir = fileSet.getDir(task.getProject());
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(task.getProject());
                    String[] files = scanner.getIncludedFiles();
                    for (int idx = 0; files != null && idx < files.length; ++idx) {
                        this.readSingleDataFile(task, handling, new File(fileSetDir, files[idx]), writer);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException((Throwable)ex);
        }
    }

    private void readSingleDataFile(Task task, DdlUtilsDataHandling handling, File dataFile, Writer output) {
        block8: {
            if (!dataFile.exists()) {
                task.log("Could not find data file " + dataFile.getAbsolutePath(), 0);
            } else if (!dataFile.isFile()) {
                task.log("Path " + dataFile.getAbsolutePath() + " does not denote a data file", 0);
            } else if (!dataFile.canRead()) {
                task.log("Could not read data file " + dataFile.getAbsolutePath(), 0);
            } else {
                try {
                    FileReader reader = new FileReader(dataFile.getAbsolutePath());
                    handling.getInsertDataSql(reader, output);
                    output.flush();
                    output.close();
                    task.log("Read data file " + dataFile.getAbsolutePath(), 2);
                }
                catch (Exception ex) {
                    if (!this.isFailOnError()) break block8;
                    throw new BuildException("Could not read data file " + dataFile.getAbsolutePath(), (Throwable)ex);
                }
            }
        }
    }
}

