/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheEmptyImpl;
import org.apache.ojb.broker.cache.ObjectCacheInternal;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

class CacheDistributor
implements ObjectCacheInternal {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$cache$CacheDistributor == null ? (class$org$apache$ojb$broker$cache$CacheDistributor = CacheDistributor.class$("org.apache.ojb.broker.cache.CacheDistributor")) : class$org$apache$ojb$broker$cache$CacheDistributor);
    private static final String DESCRIPTOR_BASED_CACHES = "descriptorBasedCaches";
    public static final String CACHE_EXCLUDES_STRING = "cacheExcludes";
    private static final String DELIMITER_FOR_EXCLUDE = ",";
    private static final ObjectCacheInternal DUMMY_CACHE = new ObjectCacheInternalWrapper(new ObjectCacheEmptyImpl(null, null));
    private Map caches = new HashMap();
    private List excludedPackages;
    private final PersistenceBroker broker;
    private boolean descriptorBasedCaches;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$CacheDistributor;
    static /* synthetic */ Class class$org$apache$ojb$broker$PersistenceBroker;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheInternal;

    public CacheDistributor(PersistenceBroker broker) {
        this.broker = broker;
        this.descriptorBasedCaches = OjbConfigurator.getInstance().getConfigurationFor(null).getBoolean(DESCRIPTOR_BASED_CACHES, false);
        String exclude = broker.serviceConnectionManager().getConnectionDescriptor().getAttribute(CACHE_EXCLUDES_STRING);
        if (exclude != null && (exclude = exclude.trim()).length() > 0) {
            this.excludedPackages = this.createExcludedPackagesList(exclude);
            log.info("Packages to exclude from caching: " + this.excludedPackages);
        }
    }

    public void cache(Identity oid, Object obj) {
        this.getCache(oid.getObjectsTopLevelClass()).cache(oid, obj);
    }

    public boolean cacheIfNew(Identity oid, Object obj) {
        return this.getCache(oid.getObjectsTopLevelClass()).cacheIfNew(oid, obj);
    }

    public Object lookup(Identity oid) {
        return this.getCache(oid.getObjectsTopLevelClass()).lookup(oid);
    }

    public void remove(Identity oid) {
        this.getCache(oid.getObjectsTopLevelClass()).remove(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.caches;
        synchronized (map) {
            Iterator it = this.caches.values().iterator();
            ObjectCache oc = null;
            while (it.hasNext()) {
                oc = (ObjectCache)it.next();
                try {
                    oc.clear();
                }
                catch (Exception e) {
                    log.error("Error while call method 'clear()' on '" + oc + "'", e);
                }
            }
        }
    }

    public void doInternalCache(Identity oid, Object obj, int type) {
        this.getCache(oid.getObjectsTopLevelClass()).doInternalCache(oid, obj, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectCacheInternal getCache(Class targetClass) {
        boolean useConnectionLevelCache = false;
        ObjectCacheInternal retval = null;
        ObjectCacheDescriptor ocd = this.searchInClassDescriptor(targetClass);
        if (ocd == null) {
            ocd = this.searchInJdbcConnectionDescriptor();
            useConnectionLevelCache = true;
        }
        if (ocd == null) {
            throw new OJBRuntimeException("No object cache descriptor found for " + targetClass + ", using PBKey " + this.broker.getPBKey() + ". Please set a cache descriptor in jdbc-connection-descriptor or in class-descriptor");
        }
        if (!useConnectionLevelCache) {
            if (!this.descriptorBasedCaches) {
                Map map = this.caches;
                synchronized (map) {
                    retval = this.lookupCache(targetClass);
                    if (retval == null) {
                        if (log.isEnabledFor(2)) {
                            String eol = SystemUtils.LINE_SEPARATOR;
                            log.info(eol + "<====" + eol + "Setup new object cache instance on CLASS LEVEL for" + eol + "PersistenceBroker: " + this.broker + eol + "descriptorBasedCache: " + this.descriptorBasedCaches + eol + "Class: " + targetClass + eol + "ObjectCache: " + ocd + eol + "====>");
                        }
                        retval = this.prepareAndAddCache(targetClass, ocd);
                    }
                }
            } else {
                Map map = this.caches;
                synchronized (map) {
                    retval = this.lookupCache(ocd);
                    if (retval == null) {
                        if (log.isEnabledFor(2)) {
                            String eol = SystemUtils.LINE_SEPARATOR;
                            log.info(eol + "<====" + eol + "Setup new object cache instance on CLASS LEVEL for" + eol + "PersistenceBroker: " + this.broker + eol + "descriptorBasedCache: " + this.descriptorBasedCaches + eol + "class: " + targetClass + eol + "ObjectCache: " + ocd + eol + "====>");
                        }
                        retval = this.prepareAndAddCache(ocd, ocd);
                    }
                }
            }
        } else if (this.isExcluded(targetClass)) {
            if (log.isDebugEnabled()) {
                log.debug("Class '" + targetClass.getName() + "' is excluded from being cached");
            }
            retval = DUMMY_CACHE;
        } else {
            String jcdAlias = this.broker.serviceConnectionManager().getConnectionDescriptor().getJcdAlias();
            Map map = this.caches;
            synchronized (map) {
                retval = this.lookupCache(jcdAlias);
                if (retval == null) {
                    if (log.isEnabledFor(2)) {
                        String eol = SystemUtils.LINE_SEPARATOR;
                        log.info(eol + "<====" + eol + "Setup new object cache instance on CONNECTION LEVEL for" + eol + "PersistenceBroker: " + this.broker + eol + "descriptorBasedCache: " + this.descriptorBasedCaches + eol + "Connection jcdAlias: " + jcdAlias + eol + "Calling class: " + targetClass + "ObjectCache: " + ocd + eol + "====>");
                    }
                    retval = this.prepareAndAddCache(jcdAlias, ocd);
                }
            }
        }
        return retval;
    }

    private ObjectCacheInternal prepareAndAddCache(Object key, ObjectCacheDescriptor ocd) {
        ObjectCacheInternal cache = this.lookupCache(key);
        if (cache != null) {
            log.info("Key '" + key + "' was already in use no need to create the ObjectCache instance again");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Create new ObjectCache implementation for " + key);
            }
            try {
                ObjectCache temp = (ObjectCache)ClassHelper.newInstance(ocd.getObjectCache(), new Class[]{class$org$apache$ojb$broker$PersistenceBroker == null ? (class$org$apache$ojb$broker$PersistenceBroker = CacheDistributor.class$("org.apache.ojb.broker.PersistenceBroker")) : class$org$apache$ojb$broker$PersistenceBroker, class$java$util$Properties == null ? (class$java$util$Properties = CacheDistributor.class$("java.util.Properties")) : class$java$util$Properties}, new Object[]{this.broker, ocd.getConfigurationProperties()});
                if (temp instanceof ObjectCacheInternal) {
                    cache = (ObjectCacheInternal)temp;
                } else {
                    log.info("Specified cache " + ocd.getObjectCache() + " does not implement " + (class$org$apache$ojb$broker$cache$ObjectCacheInternal == null ? (class$org$apache$ojb$broker$cache$ObjectCacheInternal = CacheDistributor.class$("org.apache.ojb.broker.cache.ObjectCacheInternal")) : class$org$apache$ojb$broker$cache$ObjectCacheInternal) + " and will be wrapped by a helper class");
                    cache = new ObjectCacheInternalWrapper(temp);
                }
            }
            catch (Exception e) {
                log.error("Can not create ObjectCache instance using class " + ocd.getObjectCache(), e);
                throw new OJBRuntimeException(e);
            }
            this.caches.put(key, cache);
        }
        return cache;
    }

    private ObjectCacheInternal lookupCache(Object key) {
        return (ObjectCacheInternal)this.caches.get(key);
    }

    private List createExcludedPackagesList(String theList) {
        StringTokenizer tok = new StringTokenizer(theList, DELIMITER_FOR_EXCLUDE);
        String token = null;
        ArrayList<String> result = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            token = tok.nextToken().trim();
            if (token.length() <= 0) continue;
            result.add(token);
        }
        return result;
    }

    private boolean isExcluded(Class targetClass) {
        if (this.excludedPackages != null) {
            String name = targetClass.getName();
            for (int i = 0; i < this.excludedPackages.size(); ++i) {
                String exclude = (String)this.excludedPackages.get(i);
                if (!name.startsWith(exclude)) continue;
                return true;
            }
        }
        return false;
    }

    protected ObjectCacheDescriptor searchInClassDescriptor(Class targetClass) {
        return targetClass != null ? this.broker.getClassDescriptor(targetClass).getObjectCacheDescriptor() : null;
    }

    protected ObjectCacheDescriptor searchInJdbcConnectionDescriptor() {
        return this.broker.serviceConnectionManager().getConnectionDescriptor().getObjectCacheDescriptor();
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        return buf.append("Associated PB", (Object)this.broker).append("Mapped caches", (Object)this.caches).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class ObjectCacheInternalWrapper
    implements ObjectCacheInternal {
        ObjectCache cache = null;

        public ObjectCacheInternalWrapper(ObjectCache cache) {
            this.cache = cache;
        }

        public void doInternalCache(Identity oid, Object obj, int type) {
            this.cache(oid, obj);
        }

        public void doInternalClear() {
        }

        public boolean contains(Identity oid) {
            return this.cache.lookup(oid) != null;
        }

        public void cache(Identity oid, Object obj) {
            this.cache.cache(oid, obj);
        }

        public boolean cacheIfNew(Identity oid, Object obj) {
            this.cache.cache(oid, obj);
            return true;
        }

        public Object lookup(Identity oid) {
            return this.cache.lookup(oid);
        }

        public void remove(Identity oid) {
            this.cache.remove(oid);
        }

        public void clear() {
            this.cache.clear();
        }
    }
}

