/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.OJBSerializableProxy;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class AbstractIndirectionHandler
implements IndirectionHandler {
    static final long serialVersionUID = -1993879565033755826L;
    private PBKey _brokerKey;
    private Object _realSubject = null;
    private Identity _id = null;
    private transient ArrayList _listeners;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$IndirectionHandler;

    public AbstractIndirectionHandler(PBKey brokerKey, Identity id) {
        this.setBrokerKey(brokerKey);
        this.setIdentity(id);
    }

    public Identity getIdentity() {
        return this._id;
    }

    protected void setIdentity(Identity identity) {
        this._id = identity;
    }

    public PBKey getBrokerKey() {
        return this._brokerKey;
    }

    protected void setBrokerKey(PBKey brokerKey) {
        this._brokerKey = brokerKey;
    }

    public synchronized void addListener(MaterializationListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public synchronized void removeListener(MaterializationListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    protected void beforeMaterialization() {
        if (this._listeners != null) {
            for (int idx = this._listeners.size() - 1; idx >= 0; --idx) {
                MaterializationListener listener = (MaterializationListener)this._listeners.get(idx);
                listener.beforeMaterialization(this, this._id);
            }
        }
    }

    protected void afterMaterialization() {
        if (this._listeners != null) {
            for (int idx = this._listeners.size() - 1; idx >= 0; --idx) {
                MaterializationListener listener = (MaterializationListener)this._listeners.get(idx);
                listener.afterMaterialization(this, this._realSubject);
            }
        }
    }

    protected TemporaryBrokerWrapper getBroker() throws PBFactoryException {
        boolean needsClose = false;
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBrokerInternal broker = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (broker == null || broker.isClosed()) {
            broker = (PersistenceBrokerInternal)PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            needsClose = true;
        }
        return new TemporaryBrokerWrapper(broker, needsClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) {
        String methodName = method.getName();
        try {
            if ("finalize".equals(methodName) && this._realSubject == null) {
                return null;
            }
            if ("writeReplace".equals(methodName)) {
                if (this._realSubject == null) {
                    return this.generateSerializableProxy();
                }
                return this.getRealSubject();
            }
            if ("equals".equals(methodName) && args[0] != null) {
                TemporaryBrokerWrapper tmp = this.getBroker();
                try {
                    args[0] = tmp.broker.getProxyFactory().getRealObject(args[0]);
                }
                finally {
                    tmp.close();
                }
            }
            if ("getIndirectionHandler".equals(methodName) && args[0] != null) {
                return this;
            }
            Object subject = this.getRealSubject();
            return method.invoke(subject, args);
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException("Error invoking method " + method.getName(), ex);
        }
    }

    public Object getRealSubject() throws PersistenceBrokerException {
        if (this._realSubject == null) {
            this.beforeMaterialization();
            this._realSubject = this.materializeSubject();
            this.afterMaterialization();
        }
        return this._realSubject;
    }

    public void setRealSubject(Object object) {
        this._realSubject = object;
    }

    protected synchronized Object materializeSubject() throws PersistenceBrokerException {
        TemporaryBrokerWrapper tmp = this.getBroker();
        try {
            Object realSubject = tmp.broker.getObjectByIdentity(this._id);
            if (realSubject == null) {
                LoggerFactory.getLogger(class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = AbstractIndirectionHandler.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).warn("Can not materialize object for Identity " + this._id + " - using PBKey " + this.getBrokerKey());
            }
            Object object = realSubject;
            return object;
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
        finally {
            tmp.close();
        }
    }

    public boolean alreadyMaterialized() {
        return this._realSubject != null;
    }

    private Object generateSerializableProxy() {
        return new OJBSerializableProxy(this.getIdentity().getObjectsRealClass(), this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class TemporaryBrokerWrapper {
        boolean needsClose;
        PersistenceBrokerInternal broker;

        public TemporaryBrokerWrapper(PersistenceBrokerInternal broker, boolean needsClose) {
            this.broker = broker;
            this.needsClose = needsClose;
        }

        public void close() {
            if (this.needsClose) {
                this.broker.close();
            }
        }
    }
}

