/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.OJBProxy;
import org.apache.ojb.broker.core.proxy.ProxyConfiguration;
import org.apache.ojb.broker.core.proxy.ProxyFactory;
import org.apache.ojb.broker.core.proxy.VirtualProxy;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class AbstractProxyFactory
implements ProxyFactory {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$proxy$AbstractProxyFactory == null ? (class$org$apache$ojb$broker$core$proxy$AbstractProxyFactory = AbstractProxyFactory.class$("org.apache.ojb.broker.core.proxy.AbstractProxyFactory")) : class$org$apache$ojb$broker$core$proxy$AbstractProxyFactory);
    private static transient ProxyFactory singleton;
    private Class _indirectionHandlerClass;
    private transient Constructor _indirectionHandlerConstructor;
    private Constructor _listProxyConstructor;
    private Constructor _setProxyConstructor;
    private Constructor _collectionProxyConstructor;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$AbstractProxyFactory;
    static /* synthetic */ Class class$org$apache$ojb$broker$PBKey;
    static /* synthetic */ Class class$org$apache$ojb$broker$Identity;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$apache$ojb$broker$query$Query;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$org$apache$ojb$broker$ManageableCollection;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$IndirectionHandler;

    private static ProxyConfiguration getProxyConfiguration() {
        return (ProxyConfiguration)((Object)OjbConfigurator.getInstance().getConfigurationFor(null));
    }

    private synchronized Constructor getIndirectionHandlerConstructor() {
        if (this._indirectionHandlerConstructor == null) {
            Class[] paramType = new Class[]{class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = AbstractProxyFactory.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey, class$org$apache$ojb$broker$Identity == null ? (class$org$apache$ojb$broker$Identity = AbstractProxyFactory.class$("org.apache.ojb.broker.Identity")) : class$org$apache$ojb$broker$Identity};
            try {
                this._indirectionHandlerConstructor = this.getIndirectionHandlerClass().getConstructor(paramType);
            }
            catch (NoSuchMethodException ex) {
                throw new MetadataException("The class " + this._indirectionHandlerClass.getName() + " specified for IndirectionHandlerClass" + " is required to have a public constructor with signature (" + (class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = AbstractProxyFactory.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey).getName() + ", " + (class$org$apache$ojb$broker$Identity == null ? (class$org$apache$ojb$broker$Identity = AbstractProxyFactory.class$("org.apache.ojb.broker.Identity")) : class$org$apache$ojb$broker$Identity).getName() + ").");
            }
        }
        return this._indirectionHandlerConstructor;
    }

    public Class getIndirectionHandlerClass() {
        if (this._indirectionHandlerClass == null) {
            this.setIndirectionHandlerClass(AbstractProxyFactory.getProxyConfiguration().getIndirectionHandlerClass());
        }
        return this._indirectionHandlerClass;
    }

    public void setIndirectionHandlerClass(Class indirectionHandlerClass) {
        if (indirectionHandlerClass == null) {
            indirectionHandlerClass = this.getDefaultIndirectionHandlerClass();
        }
        if (indirectionHandlerClass.isInterface() || Modifier.isAbstract(indirectionHandlerClass.getModifiers()) || !this.getIndirectionHandlerBaseClass().isAssignableFrom(indirectionHandlerClass)) {
            throw new MetadataException("Illegal class " + indirectionHandlerClass.getName() + " specified for IndirectionHandlerClass. Must be a concrete subclass of " + this.getIndirectionHandlerBaseClass().getName());
        }
        this._indirectionHandlerClass = indirectionHandlerClass;
    }

    public IndirectionHandler createIndirectionHandler(PBKey brokerKey, Identity id) {
        Object[] args = new Object[]{brokerKey, id};
        try {
            return (IndirectionHandler)this.getIndirectionHandlerConstructor().newInstance(args);
        }
        catch (InvocationTargetException ex) {
            throw new PersistenceBrokerException("Exception while creating a new indirection handler instance", ex);
        }
        catch (InstantiationException ex) {
            throw new PersistenceBrokerException("Exception while creating a new indirection handler instance", ex);
        }
        catch (IllegalAccessException ex) {
            throw new PersistenceBrokerException("Exception while creating a new indirection handler instance", ex);
        }
    }

    private static Constructor retrieveCollectionProxyConstructor(Class proxyClass, Class baseType, String typeDesc) {
        if (proxyClass == null) {
            throw new MetadataException("No " + typeDesc + " specified.");
        }
        if (proxyClass.isInterface() || Modifier.isAbstract(proxyClass.getModifiers()) || !baseType.isAssignableFrom(proxyClass)) {
            throw new MetadataException("Illegal class " + proxyClass.getName() + " specified for " + typeDesc + ". Must be a concrete subclass of " + baseType.getName());
        }
        Class[] paramType = new Class[]{class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = AbstractProxyFactory.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey, class$java$lang$Class == null ? (class$java$lang$Class = AbstractProxyFactory.class$("java.lang.Class")) : class$java$lang$Class, class$org$apache$ojb$broker$query$Query == null ? (class$org$apache$ojb$broker$query$Query = AbstractProxyFactory.class$("org.apache.ojb.broker.query.Query")) : class$org$apache$ojb$broker$query$Query};
        try {
            return proxyClass.getConstructor(paramType);
        }
        catch (NoSuchMethodException ex) {
            throw new MetadataException("The class " + proxyClass.getName() + " specified for " + typeDesc + " is required to have a public constructor with signature (" + (class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = AbstractProxyFactory.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey).getName() + ", " + (class$java$lang$Class == null ? (class$java$lang$Class = AbstractProxyFactory.class$("java.lang.Class")) : class$java$lang$Class).getName() + ", " + (class$org$apache$ojb$broker$query$Query == null ? (class$org$apache$ojb$broker$query$Query = AbstractProxyFactory.class$("org.apache.ojb.broker.query.Query")) : class$org$apache$ojb$broker$query$Query).getName() + ").");
        }
    }

    public Class getListProxyClass() {
        return this.getListProxyConstructor().getDeclaringClass();
    }

    private Constructor getListProxyConstructor() {
        if (this._listProxyConstructor == null) {
            this.setListProxyClass(AbstractProxyFactory.getProxyConfiguration().getListProxyClass());
        }
        return this._listProxyConstructor;
    }

    public void setListProxyClass(Class listProxyClass) {
        this._listProxyConstructor = AbstractProxyFactory.retrieveCollectionProxyConstructor(listProxyClass, class$java$util$List == null ? (class$java$util$List = AbstractProxyFactory.class$("java.util.List")) : class$java$util$List, "ListProxyClass");
    }

    public Class getSetProxyClass() {
        return this.getSetProxyConstructor().getDeclaringClass();
    }

    private Constructor getSetProxyConstructor() {
        if (this._setProxyConstructor == null) {
            this.setSetProxyClass(AbstractProxyFactory.getProxyConfiguration().getSetProxyClass());
        }
        return this._setProxyConstructor;
    }

    public void setSetProxyClass(Class setProxyClass) {
        this._setProxyConstructor = AbstractProxyFactory.retrieveCollectionProxyConstructor(setProxyClass, class$java$util$Set == null ? (class$java$util$Set = AbstractProxyFactory.class$("java.util.Set")) : class$java$util$Set, "SetProxyClass");
    }

    public Class getCollectionProxyClass() {
        return this.getCollectionProxyConstructor().getDeclaringClass();
    }

    private Constructor getCollectionProxyConstructor() {
        if (this._collectionProxyConstructor == null) {
            this.setCollectionProxyClass(AbstractProxyFactory.getProxyConfiguration().getCollectionProxyClass());
        }
        return this._collectionProxyConstructor;
    }

    public void setCollectionProxyClass(Class collectionProxyClass) {
        this._collectionProxyConstructor = AbstractProxyFactory.retrieveCollectionProxyConstructor(collectionProxyClass, class$java$util$Collection == null ? (class$java$util$Collection = AbstractProxyFactory.class$("java.util.Collection")) : class$java$util$Collection, "CollectionProxyClass");
        if (!(class$org$apache$ojb$broker$ManageableCollection == null ? (class$org$apache$ojb$broker$ManageableCollection = AbstractProxyFactory.class$("org.apache.ojb.broker.ManageableCollection")) : class$org$apache$ojb$broker$ManageableCollection).isAssignableFrom(collectionProxyClass)) {
            throw new MetadataException("Illegal class " + collectionProxyClass.getName() + " specified for CollectionProxyClass. Must be a concrete subclass of " + (class$org$apache$ojb$broker$ManageableCollection == null ? (class$org$apache$ojb$broker$ManageableCollection = AbstractProxyFactory.class$("org.apache.ojb.broker.ManageableCollection")) : class$org$apache$ojb$broker$ManageableCollection).getName());
        }
    }

    private Constructor getCollectionProxyConstructor(Class collectionClass) {
        if ((class$java$util$List == null ? (class$java$util$List = AbstractProxyFactory.class$("java.util.List")) : class$java$util$List).isAssignableFrom(collectionClass)) {
            return this.getListProxyConstructor();
        }
        if ((class$java$util$Set == null ? (class$java$util$Set = AbstractProxyFactory.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(collectionClass)) {
            return this.getSetProxyConstructor();
        }
        return this.getCollectionProxyConstructor();
    }

    public ManageableCollection createCollectionProxy(PBKey brokerKey, Query query, Class collectionClass) {
        Object[] args = new Object[]{brokerKey, collectionClass, query};
        try {
            return (ManageableCollection)this.getCollectionProxyConstructor(collectionClass).newInstance(args);
        }
        catch (InstantiationException ex) {
            throw new PersistenceBrokerException("Exception while creating a new collection proxy instance", ex);
        }
        catch (InvocationTargetException ex) {
            throw new PersistenceBrokerException("Exception while creating a new collection proxy instance", ex);
        }
        catch (IllegalAccessException ex) {
            throw new PersistenceBrokerException("Exception while creating a new collection proxy instance", ex);
        }
    }

    public final Object getRealObject(Object objectOrProxy) {
        if (this.isNormalOjbProxy(objectOrProxy)) {
            try {
                return this.getIndirectionHandler(objectOrProxy).getRealSubject();
            }
            catch (ClassCastException e) {
                String msg = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = AbstractProxyFactory.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = "Could not retrieve real object for given Proxy: " + objectOrProxy;
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for given Proxy: " + objectOrProxy);
                throw e;
            }
        }
        if (this.isVirtualOjbProxy(objectOrProxy)) {
            try {
                return ((VirtualProxy)objectOrProxy).getRealSubject();
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for VirtualProxy: " + objectOrProxy);
                throw e;
            }
        }
        return objectOrProxy;
    }

    public Object getRealObjectIfMaterialized(Object objectOrProxy) {
        if (this.isNormalOjbProxy(objectOrProxy)) {
            try {
                IndirectionHandler handler = this.getIndirectionHandler(objectOrProxy);
                return handler.alreadyMaterialized() ? handler.getRealSubject() : null;
            }
            catch (ClassCastException e) {
                String msg = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = AbstractProxyFactory.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = "Could not retrieve real object for given Proxy: " + objectOrProxy;
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for given Proxy: " + objectOrProxy);
                throw e;
            }
        }
        if (this.isVirtualOjbProxy(objectOrProxy)) {
            try {
                VirtualProxy proxy = (VirtualProxy)objectOrProxy;
                return proxy.alreadyMaterialized() ? proxy.getRealSubject() : null;
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for VirtualProxy: " + objectOrProxy);
                throw e;
            }
        }
        return objectOrProxy;
    }

    public Class getRealClass(Object objectOrProxy) {
        if (this.isNormalOjbProxy(objectOrProxy)) {
            try {
                IndirectionHandler handler = this.getIndirectionHandler(objectOrProxy);
                return handler.getIdentity().getObjectsRealClass();
            }
            catch (ClassCastException e) {
                String msg = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = AbstractProxyFactory.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = "Could not retrieve real object for given Proxy: " + objectOrProxy;
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
        }
        if (this.isVirtualOjbProxy(objectOrProxy)) {
            IndirectionHandler handler = VirtualProxy.getIndirectionHandler((VirtualProxy)objectOrProxy);
            return handler.getIdentity().getObjectsRealClass();
        }
        return objectOrProxy.getClass();
    }

    public boolean isNormalOjbProxy(Object proxyOrObject) {
        return proxyOrObject instanceof OJBProxy;
    }

    public boolean isVirtualOjbProxy(Object proxyOrObject) {
        return proxyOrObject instanceof VirtualProxy;
    }

    public boolean isProxy(Object proxyOrObject) {
        return this.isNormalOjbProxy(proxyOrObject) || this.isVirtualOjbProxy(proxyOrObject);
    }

    protected abstract IndirectionHandler getDynamicIndirectionHandler(Object var1);

    public IndirectionHandler getIndirectionHandler(Object obj) {
        if (obj == null) {
            return null;
        }
        if (this.isNormalOjbProxy(obj)) {
            return this.getDynamicIndirectionHandler(obj);
        }
        if (this.isVirtualOjbProxy(obj)) {
            return VirtualProxy.getIndirectionHandler((VirtualProxy)obj);
        }
        return null;
    }

    public boolean isMaterialized(Object object) {
        IndirectionHandler handler = this.getIndirectionHandler(object);
        return handler == null || handler.alreadyMaterialized();
    }

    public CollectionProxy getCollectionProxy(Object item) {
        if (this.isCollectionProxy(item)) {
            return (CollectionProxy)item;
        }
        return null;
    }

    public boolean isCollectionProxy(Object item) {
        return item instanceof CollectionProxy;
    }

    public String toString(Object proxy) {
        IndirectionHandler handler = this.getIndirectionHandler(proxy);
        if (handler != null && handler.alreadyMaterialized()) {
            return "unmaterialized proxy for " + handler.getIdentity();
        }
        return proxy.toString();
    }

    public static synchronized ProxyFactory getProxyFactory() {
        if (singleton == null) {
            Class proxyFactoryClass = null;
            try {
                proxyFactoryClass = AbstractProxyFactory.getProxyConfiguration().getProxyFactoryClass();
                singleton = (ProxyFactory)proxyFactoryClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new MetadataException("Illegal class " + proxyFactoryClass.getName() + " specified for ProxyFactoryClass.");
            }
            catch (IllegalAccessException e) {
                throw new MetadataException("Illegal class " + proxyFactoryClass.getName() + " specified for ProxyFactoryClass.");
            }
        }
        return singleton;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

