/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.core.proxy.AbstractProxyFactory;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyFactory;
import org.apache.ojb.broker.core.proxy.ProxyFactoryCGLIBImpl;

public class ProxyHelper {
    private static Reference proxyFactoryRef;

    public static synchronized ProxyFactory getProxyFactory() {
        if (proxyFactoryRef == null || proxyFactoryRef.get() == null) {
            try {
                proxyFactoryRef = new WeakReference<ProxyFactory>(AbstractProxyFactory.getProxyFactory());
            }
            catch (PBFactoryException ex) {
                return new ProxyFactoryCGLIBImpl();
            }
        }
        return (ProxyFactory)proxyFactoryRef.get();
    }

    public static final Object getRealObject(Object objectOrProxy) {
        return ProxyHelper.getProxyFactory().getRealObject(objectOrProxy);
    }

    public static final Object getRealObjectIfMaterialized(Object objectOrProxy) {
        return ProxyHelper.getProxyFactory().getRealObjectIfMaterialized(objectOrProxy);
    }

    public static final Class getRealClass(Object objectOrProxy) {
        return ProxyHelper.getProxyFactory().getRealClass(objectOrProxy);
    }

    public static boolean isNormalOjbProxy(Object proxyOrObject) {
        return ProxyHelper.getProxyFactory().isNormalOjbProxy(proxyOrObject);
    }

    public static boolean isVirtualOjbProxy(Object proxyOrObject) {
        return ProxyHelper.getProxyFactory().isVirtualOjbProxy(proxyOrObject);
    }

    public static boolean isProxy(Object proxyOrObject) {
        return ProxyHelper.getProxyFactory().isProxy(proxyOrObject);
    }

    public static IndirectionHandler getIndirectionHandler(Object obj) {
        return ProxyHelper.getProxyFactory().getIndirectionHandler(obj);
    }

    public static boolean isMaterialized(Object object) {
        return ProxyHelper.getProxyFactory().isMaterialized(object);
    }

    public static String toString(Object object) {
        return ProxyHelper.getProxyFactory().toString(object);
    }

    public static CollectionProxy getCollectionProxy(Object item) {
        return ProxyHelper.getProxyFactory().getCollectionProxy(item);
    }

    public static boolean isCollectionProxy(Object item) {
        return ProxyHelper.getProxyFactory().isCollectionProxy(item);
    }
}

