/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.ojb.broker.locking.LockManager;
import org.apache.ojb.broker.locking.LockManagerRemoteImpl;
import org.apache.ojb.broker.locking.LockRuntimeException;
import org.apache.ojb.broker.util.ClassHelper;

public class LockManagerServlet
extends HttpServlet {
    protected static LockManager lockmanager;
    static final String STR_LOCK_TIMEOUT = "lockTimeout";
    static final String STR_BLOCK_TIMEOUT = "blockTimeout";
    static final String STR_LOCK_MANAGER = "lockManager";
    private static long numRequests;
    private static Throwable lastError;
    static /* synthetic */ Class class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (lockmanager == null) {
            String strBlock;
            lastError = null;
            numRequests = 0L;
            String strLockManager = servletConfig.getInitParameter(STR_LOCK_MANAGER);
            try {
                lockmanager = (LockManager)(strLockManager != null ? ClassHelper.newInstance(strLockManager) : ClassHelper.newInstance(class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl == null ? (class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl = LockManagerServlet.class$("org.apache.ojb.broker.locking.LockManagerInMemoryImpl")) : class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl));
            }
            catch (Exception e) {
                lastError = new LockRuntimeException("Can't instance lock manager, init parameter 'lockManager': " + strLockManager);
                e.printStackTrace();
            }
            String strTimeout = servletConfig.getInitParameter(STR_LOCK_TIMEOUT);
            if (NumberUtils.isNumber((String)strTimeout)) {
                try {
                    Long lockTimeout = NumberUtils.createLong((String)strTimeout);
                    lockmanager.setLockTimeout(lockTimeout);
                }
                catch (Exception e) {
                    if (lastError == null) {
                        lastError = new LockRuntimeException("Can't convert 'lockTimeout' init parameter: " + strTimeout);
                    }
                    e.printStackTrace();
                }
            }
            if (NumberUtils.isNumber((String)(strBlock = servletConfig.getInitParameter(STR_BLOCK_TIMEOUT)))) {
                try {
                    Long blockTimeout = NumberUtils.createLong((String)strBlock);
                    lockmanager.setLockTimeout(blockTimeout);
                }
                catch (Exception e) {
                    if (lastError == null) {
                        lastError = new LockRuntimeException("Can't convert 'blockTimeout' init parameter: " + strBlock);
                    }
                    e.printStackTrace();
                }
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setHeader("Pragma", "no-cache");
        PrintWriter out = response.getWriter();
        out.println("<html><head><title>OJB Distributed Locking Servlet Status Page</title>");
        out.println("</head><body><h1>OJB Distributed Locking Servlet</h1>");
        out.println("The servlet is running.<p>");
        if (lastError == null) {
            out.println("The LockServer is running.<p>");
            out.println("LockManager info: " + lockmanager.getLockInfo() + "<p>");
            out.println("Processed Lock Request: " + numRequests + "<p>");
        } else {
            out.println("<h2>The LockServer has a problem!</h2>");
            out.println("The error message is:<p>");
            out.println(lastError.getMessage() + "<p>");
            lastError.printStackTrace(out);
            lastError = null;
        }
        out.println("</body></html>");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ++numRequests;
        try {
            LockManagerRemoteImpl.LockInfo info = (LockManagerRemoteImpl.LockInfo)this.buildObjectFromRequest(request);
            Object result = null;
            try {
                switch (info.methodName) {
                    case 97: {
                        result = new Boolean(lockmanager.readLock(info.key, info.resourceId, info.isolationLevel));
                        break;
                    }
                    case 101: {
                        result = new Boolean(lockmanager.releaseLock(info.key, info.resourceId));
                        break;
                    }
                    case 120: {
                        lockmanager.releaseLocks(info.key);
                        result = Boolean.TRUE;
                        break;
                    }
                    case 115: {
                        result = new Boolean(lockmanager.writeLock(info.key, info.resourceId, info.isolationLevel));
                        break;
                    }
                    case 117: {
                        result = new Boolean(lockmanager.upgradeLock(info.key, info.resourceId, info.isolationLevel));
                        break;
                    }
                    case 114: {
                        result = new Boolean(lockmanager.hasRead(info.key, info.resourceId));
                        break;
                    }
                    case 119: {
                        result = new Boolean(lockmanager.hasWrite(info.key, info.resourceId));
                        break;
                    }
                    case 118: {
                        result = new Boolean(lockmanager.hasUpgrade(info.key, info.resourceId));
                        break;
                    }
                    case 105: {
                        result = lockmanager.getLockInfo();
                        break;
                    }
                    case 116: {
                        result = new Long(lockmanager.getLockTimeout());
                        break;
                    }
                    case 99: {
                        result = new Long(lockmanager.getBlockTimeout());
                        break;
                    }
                    default: {
                        throw new LockRuntimeException("Unknown command:" + info.methodName);
                    }
                }
            }
            catch (RuntimeException e) {
                result = new LockRuntimeException("Error while invoke specified method in servlet.", e);
            }
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)response.getOutputStream());
            oos.writeObject(result);
            oos.flush();
            oos.close();
        }
        catch (Throwable t) {
            lastError = t;
            t.printStackTrace();
        }
    }

    private Object buildObjectFromRequest(HttpServletRequest request) throws IOException, ClassNotFoundException {
        Object obj = null;
        ServletInputStream is = request.getInputStream();
        ObjectInputStream objInputStream = new ObjectInputStream((InputStream)is);
        obj = objInputStream.readObject();
        objInputStream.close();
        is.close();
        return obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        lastError = null;
    }
}

