/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.locking.IsolationLevels;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public final class DescriptorRepository
extends DescriptorBase
implements Serializable,
XmlCapable,
IsolationLevels {
    static final long serialVersionUID = -1556339982311359524L;
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = DescriptorRepository.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository);
    private static final String VERSION = "1.0";
    private int defaultIsolationLevel = 2;
    private final HashMap descriptorTable = new HashMap();
    private Map extentTable = new HashMap();
    private Map superClassMultipleJoinedTablesMap = new HashMap();
    private transient Map m_multiMappedTableMap;
    private transient Map m_topLevelClassTable;
    private transient Map m_firstConcreteClassMap;
    private transient Map m_allConcreteSubClass;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$DescriptorRepository;

    public static String getVersion() {
        return VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExtent(String classname, ClassDescriptor cld) {
        Map map = this.extentTable;
        synchronized (map) {
            this.extentTable.put(classname, cld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExtent(String classname) {
        Map map = this.extentTable;
        synchronized (map) {
            ClassDescriptor cld = (ClassDescriptor)this.extentTable.remove(classname);
            if (cld != null && this.m_topLevelClassTable != null) {
                Class extClass = null;
                try {
                    extClass = ClassHelper.getClass(classname);
                }
                catch (ClassNotFoundException e) {
                    throw new MetadataException("Can't instantiate class object for needed extent remove", e);
                }
                cld.removeExtentClass(classname);
                this.m_topLevelClassTable.remove(extClass);
                this.m_firstConcreteClassMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getTopLevelClass(Class clazz) throws ClassNotPersistenceCapableException {
        Class retval;
        if (this.m_topLevelClassTable == null) {
            this.m_topLevelClassTable = new HashMap();
        }
        if ((retval = (Class)this.m_topLevelClassTable.get(clazz)) == null) {
            Map map = this.extentTable;
            synchronized (map) {
                ClassDescriptor cld = (ClassDescriptor)this.extentTable.get(clazz.getName());
                if (cld == null) {
                    cld = this.getDescriptorFor(clazz).getSuperClassDescriptor();
                }
                if (cld != null) {
                    retval = this.getTopLevelClass(cld.getClassOfObject());
                    if (retval == null) {
                        retval = clazz;
                    }
                } else {
                    ClassDescriptor temp = this.getDescriptorFor(clazz);
                    retval = temp.getClassOfObject();
                }
                this.m_topLevelClassTable.put(clazz, retval);
            }
        }
        return retval;
    }

    public synchronized FieldDescriptor[] getFieldDescriptorsForMultiMappedTable(ClassDescriptor targetCld) {
        FieldDescriptor[] retval;
        if (this.m_multiMappedTableMap == null) {
            this.m_multiMappedTableMap = new HashMap();
        }
        if ((retval = (FieldDescriptor[])this.m_multiMappedTableMap.get(targetCld.getClassNameOfObject())) == null) {
            retval = this.getAllMappedColumns(this.getClassesMappedToSameTable(targetCld));
            this.m_multiMappedTableMap.put(targetCld.getClassNameOfObject(), retval);
        }
        return retval;
    }

    private FieldDescriptor[] getAllMappedColumns(List classDescriptors) {
        Vector<FieldDescriptor> allFieldDescriptors = new Vector<FieldDescriptor>();
        HashSet<String> visitedColumns = new HashSet<String>();
        Iterator it = classDescriptors.iterator();
        ClassDescriptor temp = null;
        while (it.hasNext()) {
            temp = (ClassDescriptor)it.next();
            FieldDescriptor[] fields = temp.getFieldDescriptions();
            if (fields == null) continue;
            for (int i = 0; i < fields.length; ++i) {
                String columnName = fields[i].getColumnName();
                if (visitedColumns.contains(columnName)) continue;
                visitedColumns.add(columnName);
                allFieldDescriptors.add(fields[i]);
            }
        }
        FieldDescriptor[] retval = new FieldDescriptor[allFieldDescriptors.size()];
        allFieldDescriptors.toArray(retval);
        return retval;
    }

    private List getClassesMappedToSameTable(ClassDescriptor targetCld) {
        Iterator iter = ((HashMap)this.descriptorTable.clone()).values().iterator();
        ArrayList<ClassDescriptor> retval = new ArrayList<ClassDescriptor>();
        retval.add(targetCld);
        while (iter.hasNext()) {
            ClassDescriptor cld = (ClassDescriptor)iter.next();
            if (cld.getFullTableName() == null || !cld.getFullTableName().equals(targetCld.getFullTableName()) || targetCld.getClassOfObject().equals(cld.getClassOfObject())) continue;
            retval.add(cld);
        }
        return retval;
    }

    public Map getDescriptorTable() {
        return this.descriptorTable;
    }

    public ClassDescriptor findFirstConcreteClass(ClassDescriptor cld) {
        ClassDescriptor result;
        if (this.m_firstConcreteClassMap == null) {
            this.m_firstConcreteClassMap = new HashMap();
        }
        if ((result = (ClassDescriptor)this.m_firstConcreteClassMap.get(cld.getClassNameOfObject())) == null) {
            if (cld.isInterface() || cld.isAbstract()) {
                if (cld.isExtent()) {
                    Class ext;
                    Vector extents = cld.getExtentClasses();
                    for (int i = 0; i < extents.size() && (result = this.findFirstConcreteClass(this.getDescriptorFor(ext = (Class)extents.get(i)))) == null; ++i) {
                    }
                } else {
                    LoggerFactory.getDefaultLogger().error("[" + this.getClass().getName() + "] Found interface/abstract class" + " in metadata declarations without concrete class: " + cld.getClassNameOfObject());
                }
                this.m_firstConcreteClassMap.put(cld.getClassNameOfObject(), result);
            } else {
                result = cld;
            }
        }
        return result;
    }

    public Collection getAllConcreteSubclassDescriptors(ClassDescriptor aCld) {
        ArrayList<ClassDescriptor> concreteSubclassClds;
        if (this.m_allConcreteSubClass == null) {
            this.m_allConcreteSubClass = new HashMap();
        }
        if ((concreteSubclassClds = (ArrayList<ClassDescriptor>)this.m_allConcreteSubClass.get(aCld.getClassOfObject())) == null) {
            concreteSubclassClds = new ArrayList<ClassDescriptor>();
            Iterator iter = aCld.getExtentClasses().iterator();
            while (iter.hasNext()) {
                Class extentClass = (Class)iter.next();
                ClassDescriptor extCld = this.getDescriptorFor(extentClass);
                if (aCld.equals(extCld)) continue;
                if (!(extCld.isInterface() || extCld.isAbstract() || concreteSubclassClds.contains(extCld))) {
                    concreteSubclassClds.add(extCld);
                }
                Iterator subIter = this.getAllConcreteSubclassDescriptors(extCld).iterator();
                while (subIter.hasNext()) {
                    ClassDescriptor subCld = (ClassDescriptor)subIter.next();
                    if (concreteSubclassClds.contains(subCld)) continue;
                    concreteSubclassClds.add(subCld);
                }
            }
            this.m_allConcreteSubClass.put(aCld.getClassOfObject(), concreteSubclassClds);
        }
        return concreteSubclassClds;
    }

    public boolean hasDescriptorFor(Class c) {
        return this.descriptorTable.containsKey(c.getName());
    }

    public ClassDescriptor getDescriptorFor(String strClassName) throws ClassNotPersistenceCapableException {
        ClassDescriptor result = this.discoverDescriptor(strClassName);
        if (result == null) {
            throw new ClassNotPersistenceCapableException(strClassName + " not found in OJB Repository");
        }
        return result;
    }

    public ClassDescriptor getDescriptorFor(Class c) throws ClassNotPersistenceCapableException {
        return this.getDescriptorFor(c.getName());
    }

    public void setClassDescriptor(ClassDescriptor cld) {
        this.put(cld.getClassNameOfObject(), cld);
    }

    public void put(Class c, ClassDescriptor cld) {
        this.put(c.getName(), cld);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String classname, ClassDescriptor cld) {
        cld.setRepository(this);
        HashMap hashMap = this.descriptorTable;
        synchronized (hashMap) {
            this.descriptorTable.put(classname, cld);
            Vector extentClasses = cld.getExtentClasses();
            for (int i = 0; i < extentClasses.size(); ++i) {
                this.addExtent(((Class)extentClasses.get(i)).getName(), cld);
            }
            this.changeDescriptorEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String className) {
        HashMap hashMap = this.descriptorTable;
        synchronized (hashMap) {
            ClassDescriptor cld = (ClassDescriptor)this.descriptorTable.remove(className);
            if (cld != null) {
                Iterator it = this.descriptorTable.values().iterator();
                while (it.hasNext()) {
                    ((ClassDescriptor)it.next()).removeExtentClass(className);
                }
                this.removeExtent(className);
                Vector extentClasses = cld.getExtentClasses();
                for (int i = 0; i < extentClasses.size(); ++i) {
                    this.removeExtent(((Class)extentClasses.get(i)).getName());
                }
                this.changeDescriptorEvent();
                this.deregisterSuperClassMultipleJoinedTables(cld);
            }
        }
    }

    public void remove(Class clazz) {
        this.remove(clazz.getName());
    }

    private synchronized void changeDescriptorEvent() {
        this.m_multiMappedTableMap = null;
        this.m_topLevelClassTable = null;
        this.m_firstConcreteClassMap = null;
        this.m_allConcreteSubClass = null;
    }

    public Iterator iterator() {
        return ((HashMap)this.descriptorTable.clone()).values().iterator();
    }

    public int getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    public void setDefaultIsolationLevel(int defaultIsolationLevel) {
        this.defaultIsolationLevel = defaultIsolationLevel;
    }

    public String toString() {
        Iterator it = this.descriptorTable.entrySet().iterator();
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        String className = "class name: ";
        String tableName = "> table name: ";
        while (it.hasNext()) {
            Map.Entry me = it.next();
            ClassDescriptor descriptor = (ClassDescriptor)me.getValue();
            buf.append(className + me.getKey() + " =", (Object)(tableName + descriptor.getFullTableName()));
        }
        return buf.toString();
    }

    public String toXML() {
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer buf = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            buf.append(((XmlCapable)i.next()).toXML() + eol);
        }
        return buf.toString();
    }

    protected String getIsolationLevelAsString() {
        if (this.defaultIsolationLevel == 2) {
            return "read-uncommitted";
        }
        if (this.defaultIsolationLevel == 3) {
            return "read-committed";
        }
        if (this.defaultIsolationLevel == 5) {
            return "repeatable-read";
        }
        if (this.defaultIsolationLevel == 7) {
            return "serializable";
        }
        if (this.defaultIsolationLevel == 4) {
            return "optimistic";
        }
        return "read-uncommitted";
    }

    protected ClassDescriptor discoverDescriptor(String className) {
        ClassDescriptor result = (ClassDescriptor)this.descriptorTable.get(className);
        if (result == null) {
            Class clazz;
            try {
                clazz = ClassHelper.getClass(className, true);
            }
            catch (ClassNotFoundException e) {
                throw new OJBRuntimeException("Class, " + className + ", could not be found.", e);
            }
            result = this.discoverDescriptor(clazz);
        }
        return result;
    }

    private ClassDescriptor discoverDescriptor(Class clazz) {
        ClassDescriptor result = (ClassDescriptor)this.descriptorTable.get(clazz.getName());
        if (result == null) {
            Class<?>[] interfaces;
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                result = this.discoverDescriptor(superClass);
            }
            if (result == null && (interfaces = clazz.getInterfaces()) != null && interfaces.length > 0) {
                for (int idx = 0; idx < interfaces.length && result == null; ++idx) {
                    result = this.discoverDescriptor(interfaces[idx]);
                }
            }
            if (result != null) {
                this.descriptorTable.put(clazz.getName(), result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSuperClassMultipleJoinedTables(ClassDescriptor cld) {
        if (cld.getBaseClass() != null) {
            try {
                Class superClass = ClassHelper.getClass(cld.getBaseClass());
                Class currentClass = cld.getClassOfObject();
                HashMap hashMap = this.descriptorTable;
                synchronized (hashMap) {
                    ArrayList<Class> subClasses = (ArrayList<Class>)this.superClassMultipleJoinedTablesMap.get(superClass);
                    if (subClasses == null) {
                        subClasses = new ArrayList<Class>();
                        this.superClassMultipleJoinedTablesMap.put(superClass, subClasses);
                    }
                    if (!subClasses.contains(currentClass)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("(MultipleJoinedTables): Register sub-class '" + currentClass + "' for class '" + superClass);
                        }
                        subClasses.add(currentClass);
                    }
                }
            }
            catch (Exception e) {
                throw new MetadataException("Can't register super class '" + cld.getBaseClass() + "' for class-descriptor: " + cld, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterSuperClassMultipleJoinedTables(ClassDescriptor cld) {
        try {
            Class currentClass = cld.getClassOfObject();
            HashMap hashMap = this.descriptorTable;
            synchronized (hashMap) {
                boolean removed;
                Class superClass;
                List subClasses = (List)this.superClassMultipleJoinedTablesMap.remove(currentClass);
                if (subClasses != null && this.log.isDebugEnabled()) {
                    this.log.debug("(MultipleJoinedTables): Deregister class " + currentClass + " with sub classes " + subClasses);
                }
                if (cld.getBaseClass() != null && (subClasses = (List)this.superClassMultipleJoinedTablesMap.get(superClass = ClassHelper.getClass(cld.getBaseClass()))) != null && (removed = subClasses.remove(currentClass)) && this.log.isDebugEnabled()) {
                    this.log.debug("(MultipleJoinedTables): Remove sub-class entry '" + currentClass + "' in mapping for class '" + superClass + "'");
                }
            }
        }
        catch (Exception e) {
            throw new MetadataException("Can't deregister super class '" + cld.getBaseClass() + "' for class-descriptor: " + cld, e);
        }
    }

    public Class[] getSubClassesMultipleJoinedTables(ClassDescriptor cld, boolean wholeTree) {
        ArrayList result = new ArrayList();
        this.createResultSubClassesMultipleJoinedTables(result, cld, wholeTree);
        return result.toArray(new Class[result.size()]);
    }

    private void createResultSubClassesMultipleJoinedTables(List result, ClassDescriptor cld, boolean wholeTree) {
        List tmp = (List)this.superClassMultipleJoinedTablesMap.get(cld.getClassOfObject());
        if (tmp != null) {
            result.addAll(tmp);
            if (wholeTree) {
                for (int i = 0; i < tmp.size(); ++i) {
                    Class subClass = (Class)tmp.get(i);
                    ClassDescriptor subCld = this.getDescriptorFor(subClass);
                    this.createResultSubClassesMultipleJoinedTables(result, subCld, wholeTree);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.log.info("# finalize DescriptorRepository instance #");
        super.finalize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

