/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.metadata.AttributeContainer;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.XmlHelper;

public class ObjectCacheDescriptor
implements Serializable,
XmlCapable,
AttributeContainer {
    private static final long serialVersionUID = 2583853027407750053L;
    private static final Class DEF_OBJECT_CACHE = class$org$apache$ojb$broker$cache$ObjectCacheEmptyImpl == null ? (class$org$apache$ojb$broker$cache$ObjectCacheEmptyImpl = ObjectCacheDescriptor.class$("org.apache.ojb.broker.cache.ObjectCacheEmptyImpl")) : class$org$apache$ojb$broker$cache$ObjectCacheEmptyImpl;
    private Class objectCache;
    private Properties configurationProperties = new Properties();
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheEmptyImpl;

    public ObjectCacheDescriptor() {
        this.objectCache = DEF_OBJECT_CACHE;
    }

    public ObjectCacheDescriptor(Class objectCacheClass) {
        this();
        this.objectCache = objectCacheClass;
    }

    public Class getObjectCache() {
        return this.objectCache;
    }

    public void setObjectCache(Class objectCache) {
        this.objectCache = objectCache;
    }

    public void addAttribute(String attributeName, String attributeValue) {
        this.configurationProperties.setProperty(attributeName, attributeValue);
    }

    public String getAttribute(String key) {
        return this.getAttribute(key, null);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String result = this.configurationProperties.getProperty(attributeName);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        buf.append("ObjectCache", (Object)this.getObjectCache()).append("Properties", (Object)this.getConfigurationProperties());
        return buf.toString();
    }

    public String toXML() {
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer buf = new StringBuffer(1024);
        buf.append("      ");
        buf.append(tags.getOpeningTagNonClosingById(113));
        buf.append(eol);
        buf.append("         ");
        buf.append(tags.getAttribute(13, "" + this.getObjectCache() != null ? this.getObjectCache().getName() : ""));
        buf.append("      >");
        buf.append(eol);
        buf.append("         <!-- ");
        buf.append(eol);
        buf.append("         Add proprietary ObjectCache implementation properties here, using custom attributes");
        buf.append(eol);
        buf.append("         e.g. <attribute attribute-name=\"timeout\" attribute-value=\"2000\"/>");
        buf.append(eol);
        buf.append("         -->");
        buf.append(eol);
        XmlHelper.appendSerializedAttributes(buf, "         ", this.getConfigurationProperties());
        buf.append("      ");
        buf.append(tags.getClosingTagById(113));
        buf.append(eol);
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

