/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldBase;
import org.apache.ojb.broker.util.ClassHelper;

public class PersistentFieldDirectImpl
extends PersistentFieldBase {
    private static final long serialVersionUID = -5458024240998909205L;
    private transient boolean isInitialized;
    private transient List fieldsList;
    private transient Field field;
    private transient boolean nonNested;

    public PersistentFieldDirectImpl() {
    }

    public PersistentFieldDirectImpl(Class type, String fieldname) {
        super(type, fieldname);
    }

    public Class getType() {
        return this.getField().getType();
    }

    protected Field getField() {
        if (!this.isInitialized) {
            this.fieldsList = this.getFieldGraph(this.makeAccessible());
            this.field = (Field)this.fieldsList.get(this.fieldsList.size() - 1);
            this.nonNested = this.fieldsList.size() == 1;
            this.isInitialized = true;
        }
        return this.field;
    }

    private List getFieldsList() {
        if (!this.isInitialized) {
            this.getField();
        }
        return this.fieldsList;
    }

    protected boolean isNestedField() {
        return !this.nonNested;
    }

    public void set(Object target, Object value) throws MetadataException {
        if (target == null) {
            return;
        }
        Object current = target;
        if (this.isNestedField()) {
            List fields = this.getFieldsList();
            int size = fields.size() - 1;
            for (int i = 0; i < size; ++i) {
                Object attribute;
                Field field = (Field)fields.get(i);
                try {
                    attribute = this.getValueFrom(field, current);
                }
                catch (Exception e) {
                    throw new MetadataException("Can't read field '" + field.getName() + "' of type " + field.getType().getName(), e);
                }
                if (attribute != null || value != null) {
                    if (attribute == null) {
                        try {
                            attribute = ClassHelper.newInstance(field.getType());
                        }
                        catch (Exception e) {
                            throw new MetadataException("Can't create nested object of type '" + field.getType() + "' for field '" + field.getName() + "'", e);
                        }
                    }
                    try {
                        this.setValueFor(field, current, attribute);
                    }
                    catch (Exception e) {
                        throw new MetadataException("Can't set nested object of type '" + field.getType() + "' for field '" + field.getName() + "'", e);
                    }
                }
                return;
                current = attribute;
            }
        }
        this.setValueFor(this.getField(), current, value);
    }

    public Object get(Object target) throws MetadataException {
        Object result = target;
        if (this.isNestedField()) {
            List fields = this.getFieldsList();
            for (int i = 0; i < fields.size() && result != null; ++i) {
                result = this.getValueFrom((Field)fields.get(i), result);
            }
        } else {
            result = result != null ? this.getValueFrom(this.getField(), result) : null;
        }
        return result;
    }

    protected Object getValueFrom(Field field, Object target) {
        try {
            return field.get(ProxyHelper.getRealObject(target));
        }
        catch (IllegalAccessException e) {
            throw new MetadataException("IllegalAccess error reading field: " + (field != null ? field.getName() : null) + " from object: " + (target != null ? target.getClass().getName() : null), e);
        }
        catch (IllegalArgumentException e) {
            throw new MetadataException("IllegalArgument error reading field: " + this.buildErrorGetMsg(target, field), e);
        }
    }

    protected void setValueFor(Field field, Object target, Object value) {
        try {
            if (value != null || !field.getType().isPrimitive()) {
                field.set(ProxyHelper.getRealObject(target), value);
            }
        }
        catch (NullPointerException ignored) {
            this.getLog().info("Target object '" + (target != null ? target.getClass().getName() : null) + "' for field '" + (field != null ? field.getName() : null) + "' of type '" + (field != null ? field.getType().getName() : null) + "' seems to be null. Can't write into null.", ignored);
        }
        catch (Exception e) {
            this.getLog().error("while set field: " + this.buildErrorSetMsg(target, value, field));
            throw new MetadataException("IllegalAccess error setting field:" + (field != null ? field.getName() : null) + " in object:" + target.getClass().getName(), e);
        }
    }

    protected boolean makeAccessible() {
        return true;
    }

    public boolean usesAccessorsAndMutators() {
        return false;
    }
}

