/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.ojb.broker.util.ClassHelper;

public class ClobWrapper {
    protected Object m_clob;
    protected static Field durationSession;
    protected static Field durationCall;
    protected static Field modeReadOnly;
    protected static Field modeReadWrite;
    protected static Method createTemporary;
    protected static Method freeTemporary;
    protected static Method open;
    protected static Method isOpen;
    protected static Method getCharacterStream;
    protected static Method getCharacterOutputStream;
    protected static Method getBufferSize;
    protected static Method close;
    protected static Method trim;
    static /* synthetic */ Class class$java$sql$Connection;

    public Object getClob() {
        return this.m_clob;
    }

    public void setClob(Object clob) {
        this.m_clob = clob;
    }

    protected static int staticIntFieldValue(Field field) {
        int value = 0;
        try {
            value = field.getInt(null);
        }
        catch (Exception ignore) {
            value = -1;
        }
        return value;
    }

    public static int getDurationSessionValue() {
        return ClobWrapper.staticIntFieldValue(durationSession);
    }

    public static int getDurationCallValue() {
        return ClobWrapper.staticIntFieldValue(durationCall);
    }

    public static int getModeReadOnlyValue() {
        return ClobWrapper.staticIntFieldValue(modeReadOnly);
    }

    public static int getModeReadWriteValue() {
        return ClobWrapper.staticIntFieldValue(modeReadWrite);
    }

    public static ClobWrapper createTemporary(Connection conn, boolean b, int i) throws Exception {
        ClobWrapper retval = new ClobWrapper();
        retval.setClob(createTemporary.invoke(null, conn, BooleanUtils.toBooleanObject((boolean)b), new Integer(i)));
        return retval;
    }

    public void open(int i) throws SQLException {
        if (this.m_clob == null) {
            return;
        }
        try {
            open.invoke(this.m_clob, new Integer(i));
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    public boolean isOpen() throws SQLException {
        if (this.m_clob == null) {
            return false;
        }
        boolean clobOpen = false;
        try {
            Boolean retval = (Boolean)isOpen.invoke(this.m_clob, null);
            if (retval != null) {
                clobOpen = retval;
            }
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
        return clobOpen;
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.m_clob == null) {
            return null;
        }
        Reader retval = null;
        try {
            retval = (Reader)getCharacterStream.invoke(this.m_clob, null);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
        return retval;
    }

    public Writer getCharacterOutputStream() throws SQLException {
        if (this.m_clob == null) {
            return null;
        }
        Writer retval = null;
        try {
            retval = (Writer)getCharacterOutputStream.invoke(this.m_clob, null);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
        return retval;
    }

    public int getBufferSize() throws SQLException {
        if (this.m_clob == null) {
            return 0;
        }
        Integer retval = null;
        try {
            retval = (Integer)getBufferSize.invoke(this.m_clob, null);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
        return retval;
    }

    public void close() throws SQLException {
        if (this.m_clob == null) {
            return;
        }
        try {
            close.invoke(this.m_clob, null);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void trim(long l) throws SQLException {
        if (this.m_clob == null) {
            return;
        }
        try {
            trim.invoke(this.m_clob, new Long(l));
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void freeTemporary() throws SQLException {
        if (this.m_clob == null) {
            return;
        }
        try {
            freeTemporary.invoke(this.m_clob, null);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class clobClass = ClassHelper.getClass("oracle.sql.CLOB", false);
            createTemporary = clobClass.getMethod("createTemporary", class$java$sql$Connection == null ? (class$java$sql$Connection = ClobWrapper.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE, Integer.TYPE);
            freeTemporary = clobClass.getMethod("freeTemporary", null);
            open = clobClass.getMethod("open", Integer.TYPE);
            isOpen = clobClass.getMethod("isOpen", null);
            getCharacterStream = clobClass.getMethod("getCharacterStream", null);
            getCharacterOutputStream = clobClass.getMethod("getCharacterOutputStream", null);
            getBufferSize = clobClass.getMethod("getBufferSize", null);
            close = clobClass.getMethod("close", null);
            trim = clobClass.getMethod("trim", Long.TYPE);
            durationSession = ClassHelper.getField(clobClass, "DURATION_SESSION");
            durationCall = ClassHelper.getField(clobClass, "DURATION_CALL");
            modeReadOnly = ClassHelper.getField(clobClass, "MODE_READONLY");
            modeReadWrite = ClassHelper.getField(clobClass, "MODE_READWRITE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

