/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class PlatformDb2Impl
extends PlatformDefaultImpl {
    public void setObjectForStatement(PreparedStatement ps, int index, Object value, int sqlType) throws SQLException {
        if (sqlType == -6) {
            ps.setByte(index, (Byte)value);
        } else {
            super.setObjectForStatement(ps, index, value, sqlType);
        }
    }

    public String createSequenceQuery(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String createSequenceQuery(String sequenceName, Properties prop) {
        StringBuffer query = new StringBuffer(this.createSequenceQuery(sequenceName));
        if (prop != null) {
            Boolean b;
            Long value;
            String str = SequenceManagerHelper.getSeqAsValue(prop);
            if (str != null) {
                query.append(" AS ").append(str);
            }
            if ((value = SequenceManagerHelper.getSeqStart(prop)) != null) {
                query.append(" START WITH ").append(value);
            }
            if ((value = SequenceManagerHelper.getSeqIncrementBy(prop)) != null) {
                query.append(" INCREMENT BY ").append(value);
            }
            if ((value = SequenceManagerHelper.getSeqMinValue(prop)) != null) {
                query.append(" MINVALUE ").append(value);
            }
            if ((value = SequenceManagerHelper.getSeqMaxValue(prop)) != null) {
                query.append(" MAXVALUE ").append(value);
            }
            if ((b = SequenceManagerHelper.getSeqCycleValue(prop)) != null) {
                if (b.booleanValue()) {
                    query.append(" CYCLE");
                } else {
                    query.append(" NO CYCLE");
                }
            }
            if ((value = SequenceManagerHelper.getSeqCacheValue(prop)) != null) {
                query.append(" CACHE ").append(value);
            }
            if ((b = SequenceManagerHelper.getSeqOrderValue(prop)) != null) {
                if (b.booleanValue()) {
                    query.append(" ORDER");
                } else {
                    query.append(" NO ORDER");
                }
            }
        }
        return query.toString();
    }

    public String nextSequenceQuery(String sequenceName) {
        return "values nextval for " + sequenceName;
    }

    public String dropSequenceQuery(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getLastInsertIdentityQuery(String tableName) {
        return "values IDENTITY_VAL_LOCAL()";
    }
}

