/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.query.LikeCriteria;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class PlatformPostgreSQLImpl
extends PlatformDefaultImpl {
    public void setObjectForStatement(PreparedStatement ps, int index, Object value, int sqlType) throws SQLException {
        if (value instanceof byte[] && sqlType == -4) {
            ps.setBytes(index, (byte[])value);
        } else {
            super.setObjectForStatement(ps, index, value, sqlType);
        }
    }

    public String createSequenceQuery(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String createSequenceQuery(String sequenceName, Properties prop) {
        StringBuffer query = new StringBuffer(this.createSequenceQuery(sequenceName));
        if (prop != null) {
            Boolean b;
            Long value = SequenceManagerHelper.getSeqIncrementBy(prop);
            if (value != null) {
                query.append(" INCREMENT ").append(value);
            }
            if ((value = SequenceManagerHelper.getSeqMinValue(prop)) != null) {
                query.append(" MINVALUE ").append(value);
            }
            if ((value = SequenceManagerHelper.getSeqMaxValue(prop)) != null) {
                query.append(" MAXVALUE ").append(value);
            }
            if ((value = SequenceManagerHelper.getSeqStart(prop)) != null) {
                query.append(" START ").append(value);
            }
            if ((value = SequenceManagerHelper.getSeqCacheValue(prop)) != null) {
                query.append(" CACHE ").append(value);
            }
            if ((b = SequenceManagerHelper.getSeqCycleValue(prop)) != null && b.booleanValue()) {
                query.append(" CYCLE");
            }
        }
        return query.toString();
    }

    public String nextSequenceQuery(String sequenceName) {
        return "select nextval('" + sequenceName + "')";
    }

    public String dropSequenceQuery(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public void addPagingSql(StringBuffer anSqlString) {
        anSqlString.append(" LIMIT ? OFFSET ?");
    }

    public boolean supportsPaging() {
        return true;
    }

    public int bindPagingParameters(PreparedStatement ps, int index, int startAt, int endAt) throws SQLException {
        ps.setInt(index, endAt - (startAt - 1));
        ps.setInt(++index, startAt - 1);
        return ++index;
    }

    public String getEscapeClause(LikeCriteria aCriteria) {
        if (LikeCriteria.getEscapeCharacter() != '\\') {
            return super.getEscapeClause(aCriteria);
        }
        return "";
    }
}

