/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class PlatformSapdbImpl
extends PlatformDefaultImpl {
    public void setObjectForStatement(PreparedStatement ps, int index, Object value, int sqlType) throws SQLException {
        if ((sqlType == -3 || sqlType == -4) && value instanceof byte[]) {
            byte[] buf = (byte[])value;
            ps.setBytes(index, buf);
        } else {
            super.setObjectForStatement(ps, index, value, sqlType);
        }
    }

    public byte getJoinSyntaxType() {
        return 2;
    }

    public boolean useCountForResultsetSize() {
        return true;
    }

    public String createSequenceQuery(String sequenceName) {
        return "CREATE SEQUENCE " + sequenceName;
    }

    public String createSequenceQuery(String sequenceName, Properties prop) {
        StringBuffer query = new StringBuffer(this.createSequenceQuery(sequenceName));
        if (prop != null) {
            Boolean b;
            Long value = SequenceManagerHelper.getSeqIncrementBy(prop);
            if (value != null) {
                query.append(" INCREMENT BY ").append(value);
            }
            if ((value = SequenceManagerHelper.getSeqStart(prop)) != null) {
                query.append(" START WITH ").append(value);
            }
            if ((value = SequenceManagerHelper.getSeqMaxValue(prop)) != null) {
                query.append(" MAXVALUE ").append(value);
            }
            if ((value = SequenceManagerHelper.getSeqMinValue(prop)) != null) {
                query.append(" MINVALUE ").append(value);
            }
            if ((b = SequenceManagerHelper.getSeqCycleValue(prop)) != null) {
                if (b.booleanValue()) {
                    query.append(" CYCLE");
                } else {
                    query.append(" NOCYCLE");
                }
            }
            if ((value = SequenceManagerHelper.getSeqCacheValue(prop)) != null) {
                query.append(" CACHE ").append(value);
            }
            if ((b = SequenceManagerHelper.getSeqOrderValue(prop)) != null) {
                if (b.booleanValue()) {
                    query.append(" ORDER");
                } else {
                    query.append(" NOORDER");
                }
            }
        }
        return query.toString();
    }

    public String nextSequenceQuery(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public String dropSequenceQuery(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public void addPagingSql(StringBuffer anSqlString) {
        anSqlString.append(" ROWNO <= ? ");
    }

    public int bindPagingParameters(PreparedStatement ps, int index, int startAt, int endAt) throws SQLException {
        ps.setInt(index, endAt - 1);
        return ++index;
    }

    public boolean supportsPaging() {
        return true;
    }
}

