/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.AbstractQueryImpl;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class QueryByCriteria
extends AbstractQueryImpl {
    private Criteria m_criteria;
    private boolean m_distinct = false;
    private Map m_pathClasses;
    private Criteria m_havingCriteria;
    private String m_objectProjectionAttribute;
    private List m_orderby = null;
    private List m_groupby = null;
    private List m_prefetchedRelationships = null;
    private Collection m_pathOuterJoins = null;
    public static final Criteria CRITERIA_SELECT_ALL = null;

    public QueryByCriteria(Class targetClass, Criteria whereCriteria, Criteria havingCriteria, boolean distinct) {
        super(targetClass);
        this.setCriteria(whereCriteria);
        this.setHavingCriteria(havingCriteria);
        this.m_distinct = distinct;
        this.m_pathClasses = new HashMap();
        this.m_groupby = new ArrayList();
        this.m_orderby = new ArrayList();
        this.m_prefetchedRelationships = new ArrayList();
        this.m_pathOuterJoins = new HashSet();
    }

    public QueryByCriteria(Class targetClass, Criteria whereCriteria, Criteria havingCriteria) {
        this(targetClass, whereCriteria, havingCriteria, false);
    }

    public QueryByCriteria(Class targetClass, Criteria criteria) {
        this(targetClass, criteria, false);
    }

    public QueryByCriteria(Class targetClass, Criteria criteria, boolean distinct) {
        this(targetClass, criteria, null, distinct);
    }

    public QueryByCriteria(Object anObject, boolean distinct) {
        this(anObject.getClass(), QueryByCriteria.buildCriteria(anObject), distinct);
    }

    public QueryByCriteria(Object anObject) {
        this(anObject.getClass(), QueryByCriteria.buildCriteria(anObject));
    }

    public QueryByCriteria(Class aClassToSearchFrom) {
        this(aClassToSearchFrom, CRITERIA_SELECT_ALL);
    }

    private static Criteria buildCriteria(Object anExample) {
        Criteria criteria = new Criteria();
        ClassDescriptor cld = MetadataManager.getInstance().getRepository().getDescriptorFor(anExample.getClass());
        FieldDescriptor[] fds = cld.getFieldDescriptions();
        for (int i = 0; i < fds.length; ++i) {
            try {
                PersistentField f = fds[i].getPersistentField();
                Object value = f.get(anExample);
                if (value == null) continue;
                criteria.addEqualTo(f.getName(), value);
                continue;
            }
            catch (Throwable ex) {
                LoggerFactory.getDefaultLogger().error(ex);
            }
        }
        return criteria;
    }

    public void addPathClass(String aPath, Class aClass) {
        List pathClasses = (List)this.m_pathClasses.get(aPath);
        if (pathClasses == null) {
            this.setPathClass(aPath, aClass);
        } else {
            pathClasses.add(aClass);
        }
    }

    public void setPathClass(String aPath, Class aClass) {
        ArrayList<Class> pathClasses = new ArrayList<Class>();
        pathClasses.add(aClass);
        this.m_pathClasses.put(aPath, pathClasses);
    }

    public List getClassesForPath(String aPath) {
        return (List)this.m_pathClasses.get(aPath);
    }

    public boolean isPathOuterJoin(String aPath) {
        return this.getOuterJoinPaths().contains(aPath);
    }

    public void setPathOuterJoin(String aPath) {
        this.getOuterJoinPaths().add(aPath);
    }

    public Criteria getCriteria() {
        return this.m_criteria;
    }

    public Criteria getHavingCriteria() {
        return this.m_havingCriteria;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("QueryByCriteria from ");
        buf.append(this.getSearchClass()).append(" ");
        if (this.getCriteria() != null && !this.getCriteria().isEmpty()) {
            buf.append(" where ").append(this.getCriteria());
        }
        return buf.toString();
    }

    public boolean isDistinct() {
        return this.m_distinct;
    }

    public void setDistinct(boolean distinct) {
        this.m_distinct = distinct;
    }

    public Map getPathClasses() {
        return this.m_pathClasses;
    }

    public void setCriteria(Criteria criteria) {
        this.m_criteria = criteria;
        if (this.m_criteria != null) {
            this.m_criteria.setQuery(this);
        }
    }

    public void setHavingCriteria(Criteria havingCriteria) {
        this.m_havingCriteria = havingCriteria;
        if (this.m_havingCriteria != null) {
            this.m_havingCriteria.setQuery(this);
        }
    }

    public void addGroupBy(String fieldName) {
        if (fieldName != null) {
            this.m_groupby.add(new FieldHelper(fieldName, false));
        }
    }

    public void addGroupBy(FieldHelper aField) {
        if (aField != null) {
            this.m_groupby.add(aField);
        }
    }

    public void addGroupBy(String[] fieldNames) {
        for (int i = 0; i < fieldNames.length; ++i) {
            this.addGroupBy(fieldNames[i]);
        }
    }

    public List getGroupBy() {
        ArrayList temp = new ArrayList();
        temp.addAll(this.m_groupby);
        if (this.getCriteria() != null) {
            temp.addAll(this.getCriteria().getGroupby());
        }
        return temp;
    }

    public void addOrderBy(String fieldName, boolean sortAscending) {
        if (fieldName != null) {
            this.m_orderby.add(new FieldHelper(fieldName, sortAscending));
        }
    }

    public void addOrderBy(String fieldName) {
        this.addOrderBy(fieldName, true);
    }

    public void addOrderBy(FieldHelper aField) {
        if (aField != null) {
            this.m_orderby.add(aField);
        }
    }

    public void addOrderByAscending(String fieldName) {
        this.addOrderBy(fieldName, true);
    }

    public void addOrderByDescending(String fieldName) {
        this.addOrderBy(fieldName, false);
    }

    public List getOrderBy() {
        ArrayList temp = new ArrayList();
        temp.addAll(this.m_orderby);
        if (this.getCriteria() != null) {
            temp.addAll(this.getCriteria().getOrderby());
        }
        return temp;
    }

    public void addPrefetchedRelationship(String aName) {
        this.m_prefetchedRelationships.add(aName);
    }

    public List getPrefetchedRelationships() {
        ArrayList temp = new ArrayList();
        temp.addAll(this.m_prefetchedRelationships);
        if (this.getCriteria() != null) {
            temp.addAll(this.getCriteria().getPrefetchedRelationships());
        }
        return temp;
    }

    public Collection getOuterJoinPaths() {
        return this.m_pathOuterJoins;
    }

    public String getObjectProjectionAttribute() {
        return this.m_objectProjectionAttribute;
    }

    public void setObjectProjectionAttribute(String objectProjectionAttribute) {
        ClassDescriptor baseCld = MetadataManager.getInstance().getRepository().getDescriptorFor(this.m_baseClass);
        ArrayList descs = baseCld.getAttributeDescriptorsForPath(objectProjectionAttribute);
        int pathLen = descs.size();
        if (pathLen > 0 && descs.get(pathLen - 1) instanceof ObjectReferenceDescriptor) {
            ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)descs.get(pathLen - 1);
            this.setObjectProjectionAttribute(objectProjectionAttribute, ord.getItemClass());
        }
    }

    public void setObjectProjectionAttribute(String objectProjectionAttribute, Class objectProjectionClass) {
        this.m_objectProjectionAttribute = objectProjectionAttribute;
        this.m_searchClass = objectProjectionClass;
    }
}

