/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.transaction.tm;

import javax.transaction.TransactionManager;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.core.NamingLocator;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactory;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryException;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class AbstractTransactionManagerFactory
implements TransactionManagerFactory {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$transaction$tm$AbstractTransactionManagerFactory == null ? (class$org$apache$ojb$broker$transaction$tm$AbstractTransactionManagerFactory = AbstractTransactionManagerFactory.class$("org.apache.ojb.broker.transaction.tm.AbstractTransactionManagerFactory")) : class$org$apache$ojb$broker$transaction$tm$AbstractTransactionManagerFactory);
    public static String TM_DEFAULT_METHOD_NAME = "getTransactionManager";
    private static TransactionManager tm = null;
    static /* synthetic */ Class class$org$apache$ojb$broker$transaction$tm$AbstractTransactionManagerFactory;

    public abstract String[][] getLookupInfo();

    public synchronized TransactionManager getTransactionManager() throws TransactionManagerFactoryException {
        if (tm == null) {
            StringBuffer msg = new StringBuffer();
            String[][] lookupInfo = this.getLookupInfo();
            String EOL = SystemUtils.LINE_SEPARATOR;
            for (int i = 0; i < lookupInfo.length; ++i) {
                String description = lookupInfo[i][0];
                String methodName = lookupInfo[i][1];
                String className = lookupInfo[i][2];
                try {
                    tm = className == null ? this.jndiLookup(description, methodName) : this.instantiateClass(description, className, methodName);
                    msg.append("Successfully requested TM for " + description + EOL);
                }
                catch (Exception e) {
                    if (className == null) {
                        msg.append("Error on TM request for " + description + ", using jndi-lookup '" + methodName + "'" + EOL + e.getMessage() + EOL);
                    }
                    msg.append("Error on TM request for " + description + ", using method '" + methodName + "' for class '" + className + "'" + EOL + e.getMessage() + EOL);
                }
                if (tm != null) break;
            }
            if (tm == null) {
                throw new TransactionManagerFactoryException("Can't lookup transaction manager:" + EOL + msg);
            }
        }
        return tm;
    }

    protected TransactionManager jndiLookup(String description, String methodName) {
        log.info(description + ", lookup TransactionManager: '" + methodName + "'");
        return (TransactionManager)NamingLocator.lookup(methodName);
    }

    protected TransactionManager instantiateClass(String description, String className, String methodName) throws Exception {
        log.info(description + ", invoke method '" + methodName + "()' on class " + className);
        Class tmClass = ClassHelper.getClass(className);
        return (TransactionManager)tmClass.getMethod(methodName, null).invoke(null, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

