/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ojb.broker.KeyConstraintViolatedException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcTypesHelper;
import org.apache.ojb.broker.util.logging.Logger;

public abstract class ExceptionHelper {
    public static PersistenceBrokerSQLException generateException(String message, SQLException ex, String sql, Logger logger) {
        return ExceptionHelper.generateException(message, ex, sql, null, null, logger, null);
    }

    public static PersistenceBrokerSQLException generateException(SQLException ex, String sql, ClassDescriptor cld, Logger logger, Object obj) {
        return ExceptionHelper.generateException(ex, sql, cld, null, logger, obj);
    }

    public static PersistenceBrokerSQLException generateException(SQLException ex, String sql, ClassDescriptor cld, ValueContainer[] values, Logger logger, Object obj) {
        return ExceptionHelper.generateException(null, ex, sql, cld, values, logger, obj);
    }

    public static PersistenceBrokerSQLException generateException(String message, SQLException ex, String sql, ClassDescriptor cld, ValueContainer[] values, Logger logger, Object obj) {
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer msg = new StringBuffer(eol);
        eol = eol + "* ";
        if (ex instanceof BatchUpdateException) {
            BatchUpdateException tmp = (BatchUpdateException)ex;
            if (message != null) {
                msg.append("* ").append(message);
            } else {
                msg.append("* BatchUpdateException during execution of sql-statement:");
            }
            msg.append(eol).append("Batch update count is '").append(tmp.getUpdateCounts()).append("'");
        } else if (ex instanceof SQLWarning) {
            if (message != null) {
                msg.append("* ").append(message);
            } else {
                msg.append("* SQLWarning during execution of sql-statement:");
            }
        } else if (message != null) {
            msg.append("* ").append(message);
        } else {
            msg.append("* SQLException during execution of sql-statement:");
        }
        if (sql != null) {
            msg.append(eol).append("sql statement was '").append(sql).append("'");
        }
        String stateCode = null;
        if (ex != null) {
            msg.append(eol).append("Exception message is [").append(ex.getMessage()).append("]");
            msg.append(eol).append("Vendor error code [").append(ex.getErrorCode()).append("]");
            msg.append(eol).append("SQL state code [");
            stateCode = ex.getSQLState();
            if ("23000".equalsIgnoreCase(stateCode)) {
                msg.append(stateCode).append("=INTEGRITY CONSTRAINT VIOLATION");
            } else if ("23001".equalsIgnoreCase(stateCode)) {
                msg.append(stateCode).append("=RESTRICT VIOLATION");
            } else if ("23502".equalsIgnoreCase(stateCode)) {
                msg.append(stateCode).append("=NOT NULL VIOLATION");
            } else if ("23503".equalsIgnoreCase(stateCode)) {
                msg.append(stateCode).append("=FOREIGN KEY VIOLATION");
            } else if ("23505".equalsIgnoreCase(stateCode)) {
                msg.append(stateCode).append("=UNIQUE VIOLATION");
            } else if ("23514".equalsIgnoreCase(stateCode)) {
                msg.append(stateCode).append("=CHECK VIOLATION");
            } else {
                msg.append(stateCode);
            }
            msg.append("]");
        }
        if (cld != null) {
            msg.append(eol).append("Target class is '").append(cld.getClassNameOfObject()).append("'");
            FieldDescriptor[] fields = cld.getPkFields();
            msg.append(eol).append("PK of the target object is [");
            for (int i = 0; i < fields.length; ++i) {
                try {
                    if (i > 0) {
                        msg.append(", ");
                    }
                    msg.append(fields[i].getPersistentField().getName());
                    if (obj == null) continue;
                    msg.append("=");
                    msg.append(fields[i].getPersistentField().get(obj));
                    continue;
                }
                catch (Exception ignore) {
                    msg.append(" PK field build FAILED! ");
                }
            }
            msg.append("]");
        }
        if (values != null) {
            msg.append(eol).append(values.length).append(" values performed in statement: ").append(eol);
            for (int i = 0; i < values.length; ++i) {
                ValueContainer value = values[i];
                msg.append("[");
                msg.append("jdbcType=").append(JdbcTypesHelper.getSqlTypeAsString(value.getJdbcType().getType()));
                msg.append(", value=").append(value.getValue());
                msg.append("]");
            }
        }
        if (obj != null) {
            msg.append(eol).append("Source object: ");
            try {
                msg.append(obj.toString());
            }
            catch (Exception e) {
                msg.append(obj.getClass());
            }
        }
        String shortMsg = msg.toString();
        if (ex != null) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex);
            if (rootCause == null) {
                rootCause = ex;
            }
            msg.append(eol).append("The root stack trace is --> ");
            String rootStack = ExceptionUtils.getStackTrace((Throwable)rootCause);
            msg.append(eol).append(rootStack);
        }
        msg.append(SystemUtils.LINE_SEPARATOR).append("**");
        if (logger != null) {
            logger.error(msg.toString());
        }
        if ("23000".equals(stateCode) || "23505".equals(stateCode)) {
            throw new KeyConstraintViolatedException(shortMsg, ex);
        }
        throw new PersistenceBrokerSQLException(shortMsg, ex);
    }
}

