/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;
import org.apache.ojb.broker.util.logging.PoorMansLoggerImpl;
import org.apache.ojb.broker.util.logging.StringBufferLoggerImpl;

public class LoggerFactoryImpl {
    public static final String BOOT_LOG_LEVEL_STR = "OJB.bootLogLevel";
    protected static final String BOOT_STR = "BOOT";
    protected static final String DEFAULT_STR = "DEFAULT";
    protected static final LoggerFactoryImpl INSTANCE = new LoggerFactoryImpl();
    private Logger defaultLogger = null;
    private Logger bootLogger = null;
    private boolean bootLoggerIsReassigned = false;
    private Map cache = new HashMap();
    private LoggingConfiguration conf;
    static /* synthetic */ Class class$java$lang$String;

    private LoggerFactoryImpl() {
    }

    public static LoggerFactoryImpl getInstance() {
        return INSTANCE;
    }

    private LoggingConfiguration getConfiguration() {
        if (this.conf == null) {
            this.conf = new LoggingConfiguration();
        }
        return this.conf;
    }

    public Logger getBootLogger() {
        if (this.bootLogger == null) {
            this.bootLogger = this.createStringBufferLogger_Boot();
        }
        return this.bootLogger;
    }

    public Logger getDefaultLogger() {
        if (this.defaultLogger == null) {
            this.defaultLogger = this.getLogger(DEFAULT_STR);
        }
        return this.defaultLogger;
    }

    public Logger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String loggerName) {
        Logger logger = (Logger)this.cache.get(loggerName);
        if (logger == null) {
            try {
                logger = this.createLoggerInstance(loggerName);
                if (this.getBootLogger().isDebugEnabled()) {
                    this.getBootLogger().debug("Using logger class '" + (this.getConfiguration() != null ? this.getConfiguration().getLoggerClass() : null) + "' for " + loggerName);
                }
                this.getBootLogger().debug("Initializing logger instance " + loggerName);
                logger.configure(this.conf);
            }
            catch (Throwable t) {
                this.reassignBootLogger(true);
                logger = this.getBootLogger();
                this.getBootLogger().error("[" + this.getClass().getName() + "] Could not initialize logger " + (this.conf != null ? this.conf.getLoggerClass() : null), t);
            }
            this.cache.put(loggerName, logger);
            this.reassignBootLogger(false);
        }
        return logger;
    }

    private Logger createLoggerInstance(String loggerName) throws Exception {
        Class loggerClass = this.getConfiguration().getLoggerClass();
        Logger log = (Logger)ClassHelper.newInstance(loggerClass, class$java$lang$String == null ? (class$java$lang$String = LoggerFactoryImpl.class$("java.lang.String")) : class$java$lang$String, (Object)loggerName);
        log.configure(this.getConfiguration());
        return log;
    }

    protected synchronized void reassignBootLogger(boolean forceError) {
        if (!this.bootLoggerIsReassigned) {
            Logger newBootLogger = null;
            String name = this.getBootLogger().getName();
            try {
                newBootLogger = this.createLoggerInstance(name);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (newBootLogger == null) {
                newBootLogger = this.createPoorMansLogger_Boot();
            }
            if (this.getBootLogger() instanceof StringBufferLoggerImpl) {
                StringBufferLoggerImpl strLogger = (StringBufferLoggerImpl)this.getBootLogger();
                String bootMessage = strLogger.flushLogBuffer();
                String eol = SystemUtils.LINE_SEPARATOR;
                if (forceError || strLogger.isErrorLog()) {
                    newBootLogger.error("-- boot log messages -->" + eol + bootMessage);
                } else {
                    newBootLogger.info("-- boot log messages -->" + eol + bootMessage);
                }
            }
            this.bootLogger = newBootLogger;
            this.bootLoggerIsReassigned = true;
        }
    }

    protected Logger createPoorMansLogger_Boot() {
        PoorMansLoggerImpl bootLogger = new PoorMansLoggerImpl(BOOT_STR);
        String level = System.getProperty(BOOT_LOG_LEVEL_STR, "INFO");
        bootLogger.setLevel(level);
        return bootLogger;
    }

    protected Logger createStringBufferLogger_Boot() {
        StringBufferLoggerImpl bootLogger = new StringBufferLoggerImpl(BOOT_STR);
        String level = System.getProperty(BOOT_LOG_LEVEL_STR, "INFO");
        ((PoorMansLoggerImpl)bootLogger).setLevel(level);
        return bootLogger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

