/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.impl.ConfigurationAbstractImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LoggingConfiguration
extends ConfigurationAbstractImpl {
    public static final String PROPERTY_COMMONS_LOGGING_LOG = "org.apache.commons.logging.Log";
    public static final String PROPERTY_COMMONS_LOGGING_LOGFACTORY = "org.apache.commons.logging.LogFactory";
    public static final String PROPERTY_OJB_LOGGERCLASS = "org.apache.ojb.broker.util.logging.Logger.class";
    public static final String PROPERTY_OJB_LOGGERCONFIGFILE = "org.apache.ojb.broker.util.logging.Logger.configFile";
    public static final String OJB_LOGGING_PROPERTIES_FILE = "OJB-logging.properties";
    public static final String OJB_DEFAULT_LOG_LEVEL = "WARN";
    public static final String OJB_DEFAULT_BOOT_LOG_LEVEL = "INFO";
    private Class _loggerClass;
    private String _loggerConfigFile;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        InputStream ojbLogPropFile;
        String loggerClassName;
        ClassLoader contextLoader;
        Logger bootLogger;
        block30: {
            bootLogger = LoggerFactory.getBootLogger();
            contextLoader = ClassHelper.getClassLoader();
            this._loggerClass = null;
            this.properties = new Properties();
            loggerClassName = this.getLoggerClass(System.getProperties());
            this._loggerConfigFile = this.getLoggerConfigFile(System.getProperties());
            if (loggerClassName == null) {
                String ojbLogPropFilePath = System.getProperty(OJB_LOGGING_PROPERTIES_FILE, OJB_LOGGING_PROPERTIES_FILE);
                try {
                    URL ojbLoggingURL = ClassHelper.getResource(ojbLogPropFilePath);
                    if (ojbLoggingURL == null) {
                        ojbLoggingURL = new File(ojbLogPropFilePath).toURL();
                    }
                    ojbLogPropFile = ojbLoggingURL.openStream();
                    try {
                        bootLogger.info("Found logging properties file: " + ojbLogPropFilePath);
                        this.properties.load(ojbLogPropFile);
                        this._loggerConfigFile = this.getLoggerConfigFile(this.properties);
                        loggerClassName = this.getLoggerClass(this.properties);
                    }
                    finally {
                        ojbLogPropFile.close();
                    }
                }
                catch (Exception ex) {
                    if (loggerClassName == null) {
                        bootLogger.warn("Can't read logging properties file using path '" + ojbLogPropFilePath + "', message is: " + SystemUtils.LINE_SEPARATOR + ex.getMessage() + SystemUtils.LINE_SEPARATOR + "Will try to load logging properties from OJB.properties file");
                    }
                    bootLogger.info("Problems while closing resources for path '" + ojbLogPropFilePath + "', message is: " + SystemUtils.LINE_SEPARATOR + ex.getMessage(), ex);
                }
            }
            if (loggerClassName == null) {
                String ojbPropFile = System.getProperty("OJB.properties", "OJB.properties");
                try {
                    ojbLogPropFile = contextLoader.getResourceAsStream(ojbPropFile);
                    if (ojbLogPropFile == null) break block30;
                    try {
                        this.properties.load(ojbLogPropFile);
                        loggerClassName = this.getLoggerClass(this.properties);
                        this._loggerConfigFile = this.getLoggerConfigFile(this.properties);
                        if (loggerClassName != null) {
                            bootLogger.warn("Please use a separate 'OJB-logging.properties' file to specify your logging settings");
                        }
                    }
                    finally {
                        ojbLogPropFile.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (loggerClassName != null) {
            try {
                this._loggerClass = ClassHelper.getClass(loggerClassName);
                bootLogger.info("Logging: Found logger class '" + loggerClassName);
            }
            catch (ClassNotFoundException ex) {
                this._loggerClass = class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.PoorMansLoggerImpl")) : class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
                bootLogger.warn("Could not load logger class " + loggerClassName + ", defaulting to " + this._loggerClass.getName(), ex);
            }
        } else if (System.getProperty(PROPERTY_COMMONS_LOGGING_LOG) != null || System.getProperty(PROPERTY_COMMONS_LOGGING_LOGFACTORY) != null) {
            this._loggerClass = class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.CommonsLoggerImpl")) : class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
            bootLogger.info("Logging: Found commons logging properties, use " + this._loggerClass);
        } else {
            try {
                ojbLogPropFile = contextLoader.getResourceAsStream("log4j.properties");
                if (ojbLogPropFile != null) {
                    this._loggerClass = class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.Log4jLoggerImpl")) : class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl;
                    this._loggerConfigFile = "log4j.properties";
                    bootLogger.info("Logging: Found 'log4j.properties' file, use " + this._loggerClass);
                    ojbLogPropFile.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this._loggerClass == null) {
                try {
                    ojbLogPropFile = contextLoader.getResourceAsStream("commons-logging.properties");
                    if (ojbLogPropFile != null) {
                        this._loggerClass = class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.CommonsLoggerImpl")) : class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
                        this._loggerConfigFile = "commons-logging.properties";
                        bootLogger.info("Logging: Found 'commons-logging.properties' file, use " + this._loggerClass);
                        ojbLogPropFile.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (this._loggerClass == null) {
                    bootLogger.info("** Can't find logging configuration file, use default logger **");
                    this._loggerClass = class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.PoorMansLoggerImpl")) : class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
                }
            }
        }
    }

    private String getLoggerClass(Properties props) {
        String loggerClassName = props.getProperty(PROPERTY_OJB_LOGGERCLASS);
        if (loggerClassName == null) {
            loggerClassName = props.getProperty("LoggerClass");
        }
        return loggerClassName;
    }

    private String getLoggerConfigFile(Properties props) {
        String loggerConfigFile = props.getProperty(PROPERTY_OJB_LOGGERCONFIGFILE);
        if (loggerConfigFile == null) {
            loggerConfigFile = props.getProperty("LoggerConfigFile");
        }
        return loggerConfigFile;
    }

    public String getLogLevel(String loggerName) {
        return this.getString(loggerName + ".LogLevel", this.getString("ROOT.LogLevel", OJB_DEFAULT_LOG_LEVEL));
    }

    public void setLogger(Logger loggerInstance) {
    }

    public Class getLoggerClass() {
        return this._loggerClass;
    }

    public String getLoggerConfigFile() {
        return this._loggerConfigFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

