/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ojb.broker.util.logging.PoorMansLoggerImpl;

public class StringBufferLoggerImpl
extends PoorMansLoggerImpl {
    protected String EOL = SystemUtils.LINE_SEPARATOR;
    private StringBuffer buffer = new StringBuffer(1000);
    private boolean errorLog;

    public StringBufferLoggerImpl(String name) {
        super(name);
    }

    protected void log(String aLevel, Object obj, Throwable t) {
        this.buffer.append("[").append(this.getName()).append("] ").append(aLevel);
        if (obj != null && obj instanceof Throwable) {
            try {
                this.buffer.append(((Throwable)obj).getMessage()).append(this.EOL);
                ((Throwable)obj).printStackTrace();
            }
            catch (Throwable ignored) {}
        } else {
            try {
                this.buffer.append(obj).append(this.EOL);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (t != null) {
            try {
                this.buffer.append(t.getMessage()).append(this.EOL);
                this.buffer.append(ExceptionUtils.getFullStackTrace((Throwable)t)).append(this.EOL);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        if (!this.errorLog && (aLevel.equals("ERROR") || aLevel.equals("FATAL"))) {
            this.errorLog = true;
        }
    }

    public boolean isErrorLog() {
        return this.errorLog;
    }

    public String flushLogBuffer() {
        String result = this.buffer.toString();
        this.buffer = new StringBuffer(1000);
        return result;
    }
}

