/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class HighLowSequence
implements Serializable {
    static final long serialVersionUID = -2174468157880921393L;
    private String name;
    private long maxKey;
    private int grabSize;
    private Integer version;
    protected long curVal = 0L;

    public HighLowSequence() {
        this(null, 0L, 0, new Integer(0));
    }

    public HighLowSequence(String tableName, long maxKey, int grabSize, Integer version) {
        this.name = tableName;
        this.maxKey = maxKey;
        this.grabSize = grabSize;
        this.version = version;
    }

    public HighLowSequence getCopy() {
        HighLowSequence result = new HighLowSequence(this.name, this.maxKey, this.grabSize, this.version);
        result.curVal = this.curVal;
        return result;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        buf.append("name", (Object)this.name).append("grabSize", this.grabSize).append("version", (Object)this.version).append("maxKey", this.maxKey).append("currentKey", this.curVal);
        return buf.toString();
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGrabSize(int grabSize) {
        this.grabSize = grabSize;
    }

    public void setMaxKey(long maxKey) {
        this.maxKey = maxKey;
    }

    public String getName() {
        return this.name;
    }

    public int getGrabSize() {
        return this.grabSize;
    }

    public long getNextId() {
        if (this.curVal == this.maxKey) {
            return 0L;
        }
        ++this.curVal;
        return this.curVal;
    }

    public long getMaxKey() {
        return this.maxKey;
    }

    public void grabNextKeySet() {
        this.curVal = this.maxKey;
        this.maxKey += (long)this.grabSize;
    }
}

