/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SequenceManagerHelper {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$sequence$SequenceManagerHelper == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerHelper = SequenceManagerHelper.class$("org.apache.ojb.broker.util.sequence.SequenceManagerHelper")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerHelper);
    public static final String PROP_SEQ_AS = "seq.as";
    public static final String PROP_SEQ_START_OLD = "sequenceStart";
    public static final String PROP_SEQ_START = "seq.start";
    public static final String PROP_SEQ_INCREMENT_BY = "seq.incrementBy";
    public static final String PROP_SEQ_MAX_VALUE = "seq.maxValue";
    public static final String PROP_SEQ_MIN_VALUE = "seq.minValue";
    public static final String PROP_SEQ_CYCLE = "seq.cycle";
    public static final String PROP_SEQ_CACHE = "seq.cache";
    public static final String PROP_SEQ_ORDER = "seq.order";
    private static final String SEQ_PREFIX = "SEQ_";
    private static final String SEQ_UNASSIGNED = "UNASSIGNED";
    private static final String SM_SELECT_MAX = "SELECT MAX(";
    private static final String SM_FROM = ") FROM ";
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerHelper;

    public static String buildSequenceName(PersistenceBroker brokerForClass, FieldDescriptor field, boolean autoNaming) throws SequenceManagerException {
        String seqName = field.getSequenceName();
        if (seqName != null && seqName.trim().length() != 0) {
            return seqName;
        }
        if (!autoNaming) {
            throw new SequenceManagerException("Could not find sequence-name for field '" + field + "' of class '" + field.getClassDescriptor().getClassNameOfObject() + "', property 'autoNaming' in sequence-manager element in repository was '" + autoNaming + "'. Set autoNaming true in sequence-descriptor or define a " + " sequence-name in field-descriptor.");
        }
        ClassDescriptor cldTargetClass = field.getClassDescriptor();
        Class topLevel = brokerForClass.getTopLevelClass((cldTargetClass = SequenceManagerHelper.findInheritanceRoot(cldTargetClass)).getClassOfObject());
        ClassDescriptor cldTopLevel = brokerForClass.getClassDescriptor(topLevel);
        seqName = cldTopLevel.isExtent() ? SequenceManagerHelper.firstFoundTableName(brokerForClass, cldTopLevel) : cldTargetClass.getFullTableName();
        if (seqName == null) {
            seqName = SEQ_UNASSIGNED;
            log.warn("Too complex structure, can not assign automatic sequence name for field '" + field.getAttributeName() + "' in class '" + field.getClassDescriptor().getClassNameOfObject() + "'. Use a default sequence name instead: " + SEQ_PREFIX + seqName);
        }
        seqName = SEQ_PREFIX + seqName;
        if (log.isDebugEnabled()) {
            log.debug("Set automatic generated sequence-name for field '" + field.getAttributeName() + "' in class '" + field.getClassDescriptor().getClassNameOfObject() + "'.");
        }
        field.setSequenceName(seqName);
        return seqName;
    }

    private static ClassDescriptor findInheritanceRoot(ClassDescriptor cld) {
        ClassDescriptor result = cld;
        if (cld.getSuperClassDescriptor() != null) {
            result = SequenceManagerHelper.findInheritanceRoot(cld.getSuperClassDescriptor());
        }
        return result;
    }

    private static String firstFoundTableName(PersistenceBroker brokerForClass, ClassDescriptor cld) {
        String name;
        block2: {
            name = null;
            if (!cld.isInterface() && cld.getFullTableName() != null) {
                return cld.getFullTableName();
            }
            if (!cld.isExtent()) break block2;
            Vector extentClasses = cld.getExtentClasses();
            Iterator iterator = extentClasses.iterator();
            while (iterator.hasNext() && (name = SequenceManagerHelper.firstFoundTableName(brokerForClass, brokerForClass.getClassDescriptor((Class)iterator.next()))) == null) {
            }
        }
        return name;
    }

    public static long getMaxForExtent(PersistenceBroker brokerForClass, FieldDescriptor field) throws PersistenceBrokerException {
        if (field == null) {
            log.error("Given FieldDescriptor was null, could not detect max value across all extents");
            return 0L;
        }
        Class topLevel = brokerForClass.getTopLevelClass(field.getClassDescriptor().getClassOfObject());
        return SequenceManagerHelper.getMaxId(brokerForClass, topLevel, field);
    }

    public static long getMaxId(PersistenceBroker brokerForClass, Class topLevel, FieldDescriptor original) throws PersistenceBrokerException {
        long tmp;
        long max = 0L;
        ClassDescriptor cld = brokerForClass.getClassDescriptor(topLevel);
        if (!cld.isInterface() && !cld.isAbstract() && (tmp = SequenceManagerHelper.getMaxIdForClass(brokerForClass, cld, original)) > max) {
            max = tmp;
        }
        if (cld.isExtent()) {
            Vector extentClasses = cld.getExtentClasses();
            for (int i = 0; i < extentClasses.size(); ++i) {
                Class extentClass = (Class)extentClasses.get(i);
                if (cld.getClassOfObject().equals(extentClass)) {
                    throw new PersistenceBrokerException("Circular extent in " + extentClass + ", please check the repository");
                }
                tmp = SequenceManagerHelper.getMaxId(brokerForClass, extentClass, original);
                if (tmp <= max) continue;
                max = tmp;
            }
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long getMaxIdForClass(PersistenceBroker brokerForClass, ClassDescriptor cldForOriginalOrExtent, FieldDescriptor original) throws PersistenceBrokerException {
        long result;
        block14: {
            FieldDescriptor field = null;
            if (!original.getClassDescriptor().equals(cldForOriginalOrExtent)) {
                if (!original.getClassDescriptor().getFullTableName().equals(cldForOriginalOrExtent.getFullTableName())) {
                    field = cldForOriginalOrExtent.getFieldDescriptorByName(original.getAttributeName());
                }
            } else {
                field = original;
            }
            if (field == null) {
                return 0L;
            }
            String column = field.getColumnName();
            result = 0L;
            ResultSet rs = null;
            Statement stmt = null;
            StatementManagerIF sm = brokerForClass.serviceStatementManager();
            String table = cldForOriginalOrExtent.getFullTableName();
            String sql = SM_SELECT_MAX + column + SM_FROM + table;
            stmt = sm.getGenericStatement(cldForOriginalOrExtent, false);
            rs = stmt.executeQuery(sql);
            rs.next();
            result = rs.getLong(1);
            try {
                sm.closeResources(stmt, rs);
            }
            catch (Exception ignore) {}
            break block14;
            catch (Exception e) {
                try {
                    log.warn("Cannot lookup max value from table " + table + " for column " + column + ", PB was " + brokerForClass + ", using jdbc-descriptor " + brokerForClass.serviceConnectionManager().getConnectionDescriptor(), e);
                }
                catch (Throwable throwable) {
                    try {
                        sm.closeResources(stmt, rs);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    sm.closeResources(stmt, rs);
                }
                catch (Exception ignore) {}
            }
        }
        return result;
    }

    public static Long getSeqStart(Properties prop) {
        String result = prop.getProperty(PROP_SEQ_START, null);
        if (result == null) {
            result = prop.getProperty(PROP_SEQ_START_OLD, null);
        }
        if (result != null) {
            return new Long(Long.parseLong(result));
        }
        return null;
    }

    public static Long getSeqIncrementBy(Properties prop) {
        String result = prop.getProperty(PROP_SEQ_INCREMENT_BY, null);
        if (result != null) {
            return new Long(Long.parseLong(result));
        }
        return null;
    }

    public static Long getSeqMaxValue(Properties prop) {
        String result = prop.getProperty(PROP_SEQ_MAX_VALUE, null);
        if (result != null) {
            return new Long(Long.parseLong(result));
        }
        return null;
    }

    public static Long getSeqMinValue(Properties prop) {
        String result = prop.getProperty(PROP_SEQ_MIN_VALUE, null);
        if (result != null) {
            return new Long(Long.parseLong(result));
        }
        return null;
    }

    public static Long getSeqCacheValue(Properties prop) {
        String result = prop.getProperty(PROP_SEQ_CACHE, null);
        if (result != null) {
            return new Long(Long.parseLong(result));
        }
        return null;
    }

    public static Boolean getSeqCycleValue(Properties prop) {
        String result = prop.getProperty(PROP_SEQ_CYCLE, null);
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public static Boolean getSeqOrderValue(Properties prop) {
        String result = prop.getProperty(PROP_SEQ_ORDER, null);
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public static String getSeqAsValue(Properties prop) {
        return prop.getProperty(PROP_SEQ_AS, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

