/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.IdentityFactory;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldType;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class Image {
    static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$Image == null ? (class$org$apache$ojb$odmg$Image = Image.class$("org.apache.ojb.odmg.Image")) : class$org$apache$ojb$odmg$Image);
    private long timestamp = System.currentTimeMillis();
    static /* synthetic */ Class class$org$apache$ojb$odmg$Image;

    private Image() {
    }

    boolean illegalImageComparison(Image oldImage) {
        return this.timestamp < oldImage.timestamp;
    }

    public abstract void cleanup(boolean var1);

    public abstract boolean modified(Image var1);

    abstract void referenceProcessing(Image var1);

    public void performReferenceDetection(Image oldImage) {
        if (this.illegalImageComparison(oldImage)) {
            throw new ImageException("The specified Image object is newer than current one, wrong Image order!");
        }
        this.referenceProcessing(oldImage);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ImageException
    extends OJBRuntimeException {
        public ImageException() {
        }

        public ImageException(String msg) {
            super(msg);
        }

        public ImageException(Throwable cause) {
            super(cause);
        }

        public ImageException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static interface ImageListener {
        public void addedOneToOne(ObjectReferenceDescriptor var1, Object var2, Identity var3);

        public void deletedOneToOne(ObjectReferenceDescriptor var1, Object var2, Identity var3, boolean var4);

        public void addedXToN(CollectionDescriptor var1, Object var2, Identity var3);

        public void deletedXToN(CollectionDescriptor var1, Object var2, Identity var3);

        public PersistenceBrokerInternal getBroker();
    }

    public static class Field
    extends Image {
        private final FieldType type;
        private final Object value;

        public Field(FieldType type, Object value) {
            this.type = type;
            this.value = value;
        }

        public void cleanup(boolean reuse) {
        }

        void referenceProcessing(Image oldImage) {
        }

        public boolean modified(Image other) {
            boolean result = false;
            if (this == other) {
                result = true;
            } else if (other instanceof Field) {
                result = !this.type.equals(this.value, ((Field)other).value);
            }
            return result;
        }

        public String toString() {
            return ClassUtils.getShortClassName(this.getClass()) + "[type=" + this.type + ", value=" + this.value + "]";
        }
    }

    public static class SingleRef
    extends Image {
        private Object referenceObjOrProxy;
        private Identity oid = null;
        private final ImageListener listener;
        private final ObjectReferenceDescriptor ord;

        public SingleRef(ImageListener listener, ObjectReferenceDescriptor ord, Object reference) {
            this.listener = listener;
            this.ord = ord;
            this.referenceObjOrProxy = reference;
        }

        public void cleanup(boolean reuse) {
            if (!reuse) {
                this.referenceObjOrProxy = null;
            }
        }

        void referenceProcessing(Image oldImage) {
            boolean isSame;
            SingleRef oldRef = (SingleRef)oldImage;
            boolean bl = isSame = this.getReferenceObjectOrProxy() == oldRef.getReferenceObjectOrProxy();
            if (!isSame) {
                Identity newOid = this.getIdentity();
                Identity oldOid = oldRef.getIdentity();
                if (newOid == null) {
                    if (oldOid != null) {
                        this.listener.deletedOneToOne(this.ord, oldRef.getReferenceObjectOrProxy(), oldOid, true);
                    }
                } else if (oldOid == null) {
                    this.listener.addedOneToOne(this.ord, this.getReferenceObjectOrProxy(), newOid);
                } else if (!newOid.equals(oldOid)) {
                    this.listener.deletedOneToOne(this.ord, oldRef.getReferenceObjectOrProxy(), oldOid, false);
                    this.listener.addedOneToOne(this.ord, this.getReferenceObjectOrProxy(), newOid);
                }
            }
        }

        public Object getReferenceObjectOrProxy() {
            return this.referenceObjOrProxy;
        }

        private Identity getIdentity() {
            if ((this.oid == null || this.oid.isTransient()) && this.referenceObjOrProxy != null) {
                this.oid = this.listener.getBroker().serviceIdentity().buildIdentity(this.referenceObjOrProxy);
            }
            return this.oid;
        }

        public boolean modified(Image toCompare) {
            boolean modified = false;
            if (this != toCompare && toCompare instanceof SingleRef) {
                SingleRef other = (SingleRef)toCompare;
                Identity current = this.getIdentity();
                Identity otherOid = other.getIdentity();
                modified = current != null ? !current.equals(otherOid) : otherOid != null;
            }
            return modified;
        }

        public String toString() {
            return ClassUtils.getShortClassName(this.getClass()) + "[reference=" + this.getIdentity() + "]";
        }
    }

    public static class MultipleRef
    extends Image
    implements CollectionProxyListener {
        static final int IS_NORMAL_OBJECT = 11;
        static final int IS_MATERIALIZED_PROXY = 13;
        static final int IS_UNMATERIALIZED_PROXY = 17;
        private ImageListener listener;
        private final CollectionDescriptor cod;
        private final Object collectionOrArray;
        private Map references;
        private int status;
        private boolean hasTransientIdentity;
        private boolean isRefreshed;

        public MultipleRef(ImageListener listener, CollectionDescriptor cod, Object collectionOrArray) {
            this.listener = listener;
            this.cod = cod;
            this.collectionOrArray = collectionOrArray;
            this.isRefreshed = true;
            this.hasTransientIdentity = false;
            this.references = Collections.EMPTY_MAP;
            this.init();
        }

        private void init() {
            CollectionProxy colProxy = ProxyHelper.getCollectionProxy(this.collectionOrArray);
            if (colProxy != null) {
                if (colProxy.isLoaded()) {
                    this.status = 13;
                    this.handleReferencedObjects(((Collection)((Object)colProxy)).iterator());
                } else {
                    this.status = 17;
                    if (log.isDebugEnabled()) {
                        log.debug("Unmaterialized proxy collection, use proxy listener");
                    }
                    colProxy.addListener(this);
                }
            } else {
                this.status = 11;
                if (this.collectionOrArray != null) {
                    Iterator it = BrokerHelper.getCollectionIterator(this.collectionOrArray);
                    this.handleReferencedObjects(it);
                }
            }
        }

        void handleReferencedObjects(Iterator it) {
            if (it == null) {
                return;
            }
            this.references = new HashMap();
            if (log.isDebugEnabled()) {
                log.debug("Handle collection references");
            }
            IdentityFactory idFac = this.listener.getBroker().serviceIdentity();
            while (it.hasNext()) {
                Object obj = it.next();
                Identity oid = idFac.buildIdentity(obj);
                if (!this.hasTransientIdentity && oid.isTransient()) {
                    this.hasTransientIdentity = true;
                }
                this.references.put(oid, obj);
            }
        }

        public void cleanup(boolean reuse) {
            CollectionProxy colProxy;
            if (log.isDebugEnabled()) {
                log.debug("Cleanup collection image, reuse=" + reuse);
            }
            if (reuse) {
                this.isRefreshed = false;
            } else if (this.status == 17 && (colProxy = ProxyHelper.getCollectionProxy(this.collectionOrArray)) != null) {
                colProxy.removeListener(this);
            }
        }

        void referenceProcessing(Image oldImage) {
            Map.Entry entry;
            MultipleRef oldRefs = (MultipleRef)oldImage;
            if (this.incommensurableProxies(oldRefs)) {
                if (this.isUnmaterializedProxy()) {
                    this.handleReferencedObjects(BrokerHelper.getCollectionIterator(this.collectionOrArray));
                }
                if (oldRefs.isUnmaterializedProxy()) {
                    oldRefs.handleReferencedObjects(BrokerHelper.getCollectionIterator(oldRefs.collectionOrArray));
                }
            }
            if (!this.isRefreshed) {
                this.refreshIdentities();
            }
            if (!oldRefs.isRefreshed) {
                oldRefs.refreshIdentities();
            }
            if (oldRefs.references.size() > 0) {
                Iterator oldIter = oldRefs.references.entrySet().iterator();
                while (oldIter.hasNext()) {
                    entry = oldIter.next();
                    Identity oldOid = (Identity)entry.getKey();
                    if (this.isUnmaterializedProxy() || this.containsReference(oldOid)) continue;
                    this.listener.deletedXToN(this.cod, entry.getValue(), oldOid);
                }
            }
            if (this.references.size() > 0) {
                Iterator newIter = this.references.entrySet().iterator();
                while (newIter.hasNext()) {
                    entry = newIter.next();
                    Identity newOid = (Identity)entry.getKey();
                    if (oldRefs.containsReference(newOid)) continue;
                    this.listener.addedXToN(this.cod, entry.getValue(), newOid);
                }
            }
        }

        private boolean incommensurableProxies(MultipleRef oldImage) {
            boolean result = false;
            if (oldImage.isUnmaterializedProxy() || this.isUnmaterializedProxy()) {
                result = !this.collectionOrArray.equals(oldImage.collectionOrArray);
            }
            return result;
        }

        private void refreshIdentities() {
            if (this.hasTransientIdentity && this.references.size() > 0) {
                this.hasTransientIdentity = false;
                ArrayList list = new ArrayList(this.references.keySet());
                IdentityFactory idFac = this.listener.getBroker().serviceIdentity();
                for (int i = 0; i < list.size(); ++i) {
                    Identity oid = (Identity)list.get(i);
                    if (!oid.isTransient()) continue;
                    Object obj = this.references.remove(oid);
                    Identity newOid = idFac.buildIdentity(obj);
                    this.references.put(newOid, obj);
                    if (this.hasTransientIdentity || !oid.isTransient()) continue;
                    this.hasTransientIdentity = true;
                }
                this.isRefreshed = true;
            }
        }

        public boolean modified(Image other) {
            return false;
        }

        boolean containsReference(Identity oid) {
            if (!this.isRefreshed) {
                this.refreshIdentities();
            }
            return this.references.containsKey(oid);
        }

        Map getIdentityReferenceObjectMap() {
            if (!this.isRefreshed) {
                this.refreshIdentities();
            }
            return this.references;
        }

        boolean isMaterializedProxy() {
            return this.status == 13;
        }

        boolean isUnmaterializedProxy() {
            return this.status == 17;
        }

        public void beforeLoading(CollectionProxyDefaultImpl colProxy) {
        }

        public void afterLoading(CollectionProxyDefaultImpl colProxy) {
            if (this.status == 17) {
                this.status = 13;
                this.handleReferencedObjects(colProxy.iterator());
                colProxy.removeListener(this);
            }
        }

        public String toString() {
            return ClassUtils.getShortClassName(this.getClass()) + "[references-size=" + (this.references != null ? "" + this.references.size() : "undefined") + "]";
        }
    }
}

