/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.lang.ref.WeakReference;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryException;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryFactory;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.J2EETransactionImpl;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.TransactionImpl;
import org.odmg.TransactionNotInProgressException;

public class JTATxManager
implements OJBTxManager {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$JTATxManager == null ? (class$org$apache$ojb$odmg$JTATxManager = JTATxManager.class$("org.apache.ojb.odmg.JTATxManager")) : class$org$apache$ojb$odmg$JTATxManager);
    private static ThreadLocal txRepository = new ThreadLocal();
    static /* synthetic */ Class class$org$apache$ojb$odmg$JTATxManager;

    public void deregisterTx(Object transaction) {
        txRepository.set(null);
    }

    public void registerTx(TransactionImpl odmgTrans) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("registerSynchronization was called");
        }
        Transaction transaction = null;
        try {
            transaction = this.getJTATransaction();
        }
        catch (SystemException e) {
            this.log.error("Obtain current transaction from container failed", e);
        }
        if (transaction == null) {
            this.log.error("Cannot get the external transaction from the external TM");
            throw new TransactionNotInProgressException("No external transaction found");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("registerSynchronization was called with parameters" + SystemUtils.LINE_SEPARATOR + "J2EETransactionImpl: " + odmgTrans + SystemUtils.LINE_SEPARATOR + "Transaction: " + transaction);
        }
        this.registerSynchronization(odmgTrans, transaction);
    }

    private void registerSynchronization(TransactionImpl odmgTrans, Transaction transaction) {
        if (odmgTrans == null || transaction == null) {
            this.log.error("One of the given parameters was null --> cannot do synchronization! omdg transaction was null: " + (odmgTrans == null) + ", external transaction was null: " + (transaction == null));
            return;
        }
        int status = -1;
        try {
            status = transaction.getStatus();
            if (status != 0) {
                throw new OJBRuntimeException("Transaction synchronization failed - wrong status of external container tx: " + JTATxManager.getStatusString(status));
            }
        }
        catch (SystemException e) {
            throw new OJBRuntimeException("Can't read status of external tx", e);
        }
        try {
            transaction.registerSynchronization((Synchronization)((J2EETransactionImpl)odmgTrans));
            txRepository.set(new TxBuffer(odmgTrans, transaction));
        }
        catch (Exception e) {
            this.log.error("Cannot associate PersistenceBroker with running Transaction", e);
            throw new OJBRuntimeException("Transaction synchronization failed - wrong status of external container tx", e);
        }
    }

    private static String getStatusString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
        }
        return "NO STATUS FOUND";
    }

    private TransactionManager getTransactionManager() {
        TransactionManager retval = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("getTransactionManager called");
            }
            retval = TransactionManagerFactoryFactory.instance().getTransactionManager();
        }
        catch (TransactionManagerFactoryException e) {
            this.log.warn("Exception trying to obtain TransactionManager from Factory", (Throwable)((Object)e));
            e.printStackTrace();
        }
        return retval;
    }

    public Transaction getJTATransaction() throws SystemException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("getTransaction called");
        }
        if (this.getTransactionManager() == null) {
            this.log.warn("TransactionManager was null");
            return null;
        }
        return this.getTransactionManager().getTransaction();
    }

    public TransactionImpl getCurrentTransaction() {
        TransactionImpl retval = this.getTransaction();
        if (null == retval) {
            throw new TransactionNotInProgressException("Calling method needed transaction, but no transaction found via TransactionManager");
        }
        return retval;
    }

    public TransactionImpl getTransaction() {
        TxBuffer buf = (TxBuffer)txRepository.get();
        return buf != null ? buf.getInternTx() : null;
    }

    public void abortExternalTx(TransactionImpl odmgTrans) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("abortExternTransaction was called");
        }
        if (odmgTrans == null) {
            return;
        }
        TxBuffer buf = (TxBuffer)txRepository.get();
        Transaction extTx = buf != null ? buf.getExternTx() : null;
        try {
            if (extTx != null && extTx.getStatus() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Set extern transaction to rollback");
                }
                extTx.setRollbackOnly();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        txRepository.set(null);
    }

    public void configure(Configuration config) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class TxBuffer {
        private WeakReference externTx = null;
        private WeakReference internTx = null;

        public TxBuffer() {
        }

        public TxBuffer(TransactionImpl internTx, Transaction externTx) {
            this.internTx = new WeakReference<TransactionImpl>(internTx);
            this.externTx = new WeakReference<Transaction>(externTx);
        }

        public Transaction getExternTx() {
            return (Transaction)this.externTx.get();
        }

        public void setExternTx(Transaction externTx) {
            this.externTx = new WeakReference<Transaction>(externTx);
        }

        public TransactionImpl getInternTx() {
            return (TransactionImpl)this.internTx.get();
        }

        public void setInternTx(TransactionImpl internTx) {
            this.internTx = new WeakReference<TransactionImpl>(internTx);
        }
    }
}

