/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.odmg.ClassNotPersistenceCapableException;
import org.odmg.ObjectNameNotFoundException;
import org.odmg.ObjectNameNotUniqueException;

public class NamedRootsMap {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$NamedRootsMap == null ? (class$org$apache$ojb$odmg$NamedRootsMap = NamedRootsMap.class$("org.apache.ojb.odmg.NamedRootsMap")) : class$org$apache$ojb$odmg$NamedRootsMap);
    private TransactionImpl tx;
    private HashMap tempBindings;
    private Map deletionMap;
    private Map insertMap;
    static /* synthetic */ Class class$org$apache$ojb$odmg$NamedRootsMap;
    static /* synthetic */ Class class$org$apache$ojb$odmg$NamedRootsMap$NamedEntry;

    NamedRootsMap(TransactionImpl tx) {
        this.tx = tx;
        this.tempBindings = new HashMap();
    }

    private void addForDeletion(NamedEntry entry) {
        if (this.deletionMap == null) {
            this.deletionMap = new HashMap();
        }
        this.deletionMap.put(entry.getName(), entry);
    }

    private void addForInsert(NamedEntry entry) {
        if (this.insertMap == null) {
            this.insertMap = new HashMap();
        }
        this.insertMap.put(entry.getName(), entry);
        if (this.deletionMap != null) {
            this.deletionMap.remove(entry.getName());
        }
    }

    public void performDeletion() {
        if (this.deletionMap == null) {
            return;
        }
        PersistenceBroker broker = this.tx.getBroker();
        Iterator it = this.deletionMap.values().iterator();
        while (it.hasNext()) {
            NamedEntry namedEntry = (NamedEntry)it.next();
            broker.delete(namedEntry);
        }
    }

    public void performInsert() {
        if (this.insertMap == null) {
            return;
        }
        PersistenceBroker broker = this.tx.getBroker();
        Iterator it = this.insertMap.values().iterator();
        while (it.hasNext()) {
            NamedEntry namedEntry = (NamedEntry)it.next();
            namedEntry.prepareForStore(broker);
            broker.store(namedEntry, ObjectModification.INSERT);
        }
    }

    public void afterWriteCleanup() {
        if (this.deletionMap != null) {
            this.deletionMap.clear();
        }
        if (this.insertMap != null) {
            this.insertMap.clear();
        }
    }

    private void localBind(String key, NamedEntry entry) throws ObjectNameNotUniqueException {
        if (this.tempBindings.containsKey(key)) {
            throw new ObjectNameNotUniqueException("Object key already in use, the key '" + key + "' is not unique");
        }
        this.tempBindings.put(key, entry);
    }

    private void localUnbind(String key) {
        this.tempBindings.remove(key);
    }

    private NamedEntry localLookup(String key) {
        return (NamedEntry)this.tempBindings.get(key);
    }

    Object lookup(String key) throws ObjectNameNotFoundException {
        Object result = null;
        NamedEntry entry = this.localLookup(key);
        if (entry == null) {
            try {
                PersistenceBroker broker = this.tx.getBroker();
                Identity oid = broker.serviceIdentity().buildIdentity(class$org$apache$ojb$odmg$NamedRootsMap$NamedEntry == null ? (class$org$apache$ojb$odmg$NamedRootsMap$NamedEntry = NamedRootsMap.class$("org.apache.ojb.odmg.NamedRootsMap$NamedEntry")) : class$org$apache$ojb$odmg$NamedRootsMap$NamedEntry, (Object)key);
                entry = (NamedEntry)broker.getObjectByIdentity(oid);
            }
            catch (Exception e) {
                this.log.error("Can't materialize bound object for key '" + key + "'", e);
            }
        }
        if (entry == null) {
            this.log.info("No object found for key '" + key + "'");
        } else {
            Object obj = entry.getObject();
            if (obj instanceof Identity) {
                Identity objectIdentity = (Identity)obj;
                result = this.tx.getBroker().getObjectByIdentity(objectIdentity);
                RuntimeObject rt = new RuntimeObject(result, objectIdentity, this.tx, false);
                this.tx.lockAndRegister(rt, 1, this.tx.getRegistrationList());
            } else {
                result = obj;
            }
        }
        if (result == null) {
            throw new ObjectNameNotFoundException("Can't find named object for name '" + key + "'");
        }
        return result;
    }

    void unbind(String key) {
        NamedEntry entry = new NamedEntry(key, null, false);
        this.localUnbind(key);
        this.addForDeletion(entry);
    }

    public void bind(Object object, String name) throws ObjectNameNotUniqueException {
        NamedEntry oldEntry;
        boolean useIdentity = true;
        PersistenceBroker broker = this.tx.getBroker();
        ClassDescriptor cld = null;
        try {
            cld = broker.getClassDescriptor(ProxyHelper.getRealClass(object));
        }
        catch (PersistenceBrokerException e) {
            // empty catch block
        }
        if (cld == null) {
            useIdentity = false;
            if (!(object instanceof Serializable)) {
                throw new ClassNotPersistenceCapableException("Can't bind named object, because it's not Serializable. Name=" + name + ", object=" + object);
            }
        } else {
            RuntimeObject rt = new RuntimeObject(object, this.tx);
            if (!rt.isNew()) {
                this.tx.lockAndRegister(rt, 1, this.tx.getRegistrationList());
            } else {
                this.tx.makePersistent(rt);
            }
        }
        if ((oldEntry = this.localLookup(name)) == null) {
            Identity oid = broker.serviceIdentity().buildIdentity(class$org$apache$ojb$odmg$NamedRootsMap$NamedEntry == null ? (class$org$apache$ojb$odmg$NamedRootsMap$NamedEntry = NamedRootsMap.class$("org.apache.ojb.odmg.NamedRootsMap$NamedEntry")) : class$org$apache$ojb$odmg$NamedRootsMap$NamedEntry, (Object)name);
            oldEntry = (NamedEntry)broker.getObjectByIdentity(oid);
        }
        if (oldEntry != null) {
            throw new ObjectNameNotUniqueException("The name of the specified named object already exist, name=" + name);
        }
        NamedEntry entry = new NamedEntry(name, object, useIdentity);
        this.addForInsert(entry);
        this.localBind(name, entry);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class NamedEntry
    implements Serializable {
        static final long serialVersionUID = 6179717896336300342L;
        private String name;
        private byte[] oid;
        private transient Object object;
        private transient boolean useIdentity;

        public NamedEntry() {
        }

        NamedEntry(String aName, Object object, boolean useIdentity) {
            this.name = aName;
            this.object = object;
            this.useIdentity = useIdentity;
        }

        public void prepareForStore(PersistenceBroker broker) {
            if (this.object != null) {
                if (this.useIdentity) {
                    Identity oid = broker.serviceIdentity().buildIdentity(this.object);
                    this.oid = SerializationUtils.serialize((Serializable)oid);
                } else {
                    this.oid = SerializationUtils.serialize((Serializable)((Serializable)this.object));
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public byte[] getOid() {
            return this.oid;
        }

        public void setOid(byte[] oid) {
            this.oid = oid;
        }

        Object getObject() {
            if (this.object != null) {
                return this.object;
            }
            return this.oid != null ? SerializationUtils.deserialize((byte[])this.oid) : null;
        }
    }
}

