/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.states.ModificationState;

class ObjectEnvelopeOrdering {
    private static final int CONCRETE_EDGE_WEIGHT = 3;
    private static final int CONCRETE_EDGE_WEIGHT_WITH_FK = 4;
    private static final int POTENTIAL_EDGE_WEIGHT = 1;
    private static final int POTENTIAL_EDGE_WEIGHT_WITH_FK = 2;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$ObjectEnvelopeOrdering == null ? (class$org$apache$ojb$odmg$ObjectEnvelopeOrdering = ObjectEnvelopeOrdering.class$("org.apache.ojb.odmg.ObjectEnvelopeOrdering")) : class$org$apache$ojb$odmg$ObjectEnvelopeOrdering);
    private List originalOrder;
    private Map envelopes;
    private Vertex[] vertices;
    private List edgeList;
    private Identity[] newOrder;
    static /* synthetic */ Class class$org$apache$ojb$odmg$ObjectEnvelopeOrdering;

    public ObjectEnvelopeOrdering(List originalOrder, Map envelopes) {
        this.originalOrder = originalOrder;
        this.envelopes = envelopes;
    }

    public void reorder() {
        int processCount;
        int newOrderIndex = 0;
        long t1 = 0L;
        long t2 = 0L;
        if (log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        this.newOrder = new Identity[this.originalOrder.size()];
        if (log.isDebugEnabled()) {
            log.debug("Orginal order: " + this.originalOrder);
        }
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>(this.originalOrder.size());
        Iterator it = this.originalOrder.iterator();
        while (it.hasNext()) {
            ObjectEnvelope envelope = (ObjectEnvelope)this.envelopes.get(it.next());
            if (envelope.needsUpdate() || envelope.needsInsert() || envelope.needsDelete()) {
                Vertex vertex = new Vertex(envelope);
                vertexList.add(vertex);
                if (!log.isDebugEnabled()) continue;
                log.debug("Add new Vertex object " + envelope.getIdentity() + " to VertexList");
                continue;
            }
            this.newOrder[newOrderIndex++] = envelope.getIdentity();
            if (!log.isDebugEnabled()) continue;
            log.debug("Add unmodified object " + envelope.getIdentity() + " to new OrderList");
        }
        this.vertices = vertexList.toArray(new Vertex[vertexList.size()]);
        this.edgeList = new ArrayList(2 * this.vertices.length);
        for (int i = 0; i < this.vertices.length; ++i) {
            this.addEdgesForVertex(this.vertices[i]);
        }
        if (log.isDebugEnabled()) {
            t2 = System.currentTimeMillis();
            log.debug("Building object envelope graph took " + (t2 - t1) + " ms");
            log.debug("Object envelope graph contains " + this.vertices.length + " vertices" + " and " + this.edgeList.size() + " edges");
        }
        int iterationCount = 0;
        for (int remainingVertices = this.vertices.length; remainingVertices > 0; remainingVertices -= processCount) {
            Vertex vertex;
            ++iterationCount;
            Iterator it2 = this.edgeList.iterator();
            while (it2.hasNext()) {
                Edge edge = (Edge)it2.next();
                if (edge.isProcessed()) continue;
                if (log.isDebugEnabled()) {
                    String msg = "Add weight '" + edge.getWeight() + "' for terminal vertex " + edge.getTerminalVertex() + " of edge " + edge;
                    log.debug(msg);
                }
                edge.getTerminalVertex().incrementIncomingEdgeWeight(edge.getWeight());
            }
            int minIncomingEdgeWeight = Integer.MAX_VALUE;
            for (int i = 0; i < this.vertices.length && ((vertex = this.vertices[i]).isProcessed() || minIncomingEdgeWeight <= vertex.getIncomingEdgeWeight() || (minIncomingEdgeWeight = vertex.getIncomingEdgeWeight()) != 0); ++i) {
            }
            processCount = 0;
            for (int i = 0; i < this.vertices.length; ++i) {
                Vertex vertex2 = this.vertices[i];
                if (!vertex2.isProcessed() && vertex2.getIncomingEdgeWeight() == minIncomingEdgeWeight) {
                    this.newOrder[newOrderIndex++] = vertex2.getEnvelope().getIdentity();
                    vertex2.markProcessed();
                    ++processCount;
                    if (log.isDebugEnabled()) {
                        log.debug("add minimum edge weight - " + minIncomingEdgeWeight + ", newOrderList: " + ArrayUtils.toString((Object)this.newOrder));
                    }
                }
                vertex2.resetIncomingEdgeWeight();
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Processed " + processCount + " of " + remainingVertices + " remaining vertices in iteration #" + iterationCount);
        }
        if (log.isDebugEnabled()) {
            long t3 = System.currentTimeMillis();
            log.debug("New ordering: " + ArrayUtils.toString((Object)this.newOrder));
            log.debug("Processing object envelope graph took " + (t3 - t2) + " ms");
        }
    }

    public Identity[] getOrdering() {
        if (this.newOrder == null) {
            this.reorder();
        }
        return this.newOrder;
    }

    private void addEdgesForVertex(Vertex vertex) {
        ClassDescriptor cld = vertex.getEnvelope().getClassDescriptor();
        Iterator rdsIter = cld.getObjectReferenceDescriptors(true).iterator();
        while (rdsIter.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)rdsIter.next();
            this.addObjectReferenceEdges(vertex, rds);
        }
        Iterator cdsIter = cld.getCollectionDescriptors(true).iterator();
        while (cdsIter.hasNext()) {
            CollectionDescriptor cds = (CollectionDescriptor)cdsIter.next();
            this.addCollectionEdges(vertex, cds);
        }
    }

    private void addObjectReferenceEdges(Vertex vertex, ObjectReferenceDescriptor rds) {
        Object refObject = rds.getPersistentField().get(vertex.getEnvelope().getRealObject());
        Class refClass = rds.getItemClass();
        for (int i = 0; i < this.vertices.length; ++i) {
            Edge edge = null;
            Vertex refVertex = this.vertices[i];
            ObjectEnvelope refEnvelope = refVertex.getEnvelope();
            if (refObject == refEnvelope.getRealObject()) {
                edge = this.buildConcrete11Edge(vertex, refVertex, rds.hasConstraint());
            } else if (refClass.isInstance(refVertex.getEnvelope().getRealObject())) {
                edge = this.buildPotential11Edge(vertex, refVertex, rds.hasConstraint());
            }
            if (edge == null) continue;
            if (!this.edgeList.contains(edge)) {
                this.edgeList.add(edge);
                continue;
            }
            edge.increaseWeightTo(edge.getWeight());
        }
    }

    private void addCollectionEdges(Vertex vertex, CollectionDescriptor cds) {
        ObjectEnvelope envelope = vertex.getEnvelope();
        Object col = cds.getPersistentField().get(envelope.getRealObject());
        Object[] refObjects = col == null || ProxyHelper.isCollectionProxy(col) && !ProxyHelper.getCollectionProxy(col).isLoaded() ? EMPTY_OBJECT_ARRAY : BrokerHelper.getCollectionArray(col);
        Class refClass = cds.getItemClass();
        for (int i = 0; i < this.vertices.length; ++i) {
            Edge edge = null;
            Vertex refVertex = this.vertices[i];
            ObjectEnvelope refEnvelope = refVertex.getEnvelope();
            if (refClass.isInstance(refEnvelope.getRealObject())) {
                edge = ObjectEnvelopeOrdering.containsObject(refEnvelope.getRealObject(), refObjects) ? (cds.isMtoNRelation() ? this.buildConcreteMNEdge(vertex, refVertex) : this.buildConcrete1NEdge(vertex, refVertex)) : (cds.isMtoNRelation() ? this.buildPotentialMNEdge(vertex, refVertex) : this.buildPotential1NEdge(vertex, refVertex));
            }
            if (edge == null) continue;
            if (!this.edgeList.contains(edge)) {
                this.edgeList.add(edge);
                continue;
            }
            edge.increaseWeightTo(edge.getWeight());
        }
    }

    private static boolean containsObject(Object searchFor, Object[] searchIn) {
        for (int i = 0; i < searchIn.length; ++i) {
            if (searchFor != searchIn[i]) continue;
            return true;
        }
        return false;
    }

    protected Edge buildConcrete11Edge(Vertex vertex1, Vertex vertex2, boolean fkToRef) {
        ModificationState state1 = vertex1.getEnvelope().getModificationState();
        ModificationState state2 = vertex2.getEnvelope().getModificationState();
        if (state1.needsUpdate() || state1.needsInsert()) {
            if (state2.needsInsert()) {
                return new Edge(vertex2, vertex1, fkToRef ? 4 : 3);
            }
        } else if (state1.needsDelete() && state2.needsDelete()) {
            return new Edge(vertex1, vertex2, fkToRef ? 4 : 3);
        }
        return null;
    }

    protected Edge buildPotential11Edge(Vertex vertex1, Vertex vertex2, boolean fkToRef) {
        ModificationState state1 = vertex1.getEnvelope().getModificationState();
        ModificationState state2 = vertex2.getEnvelope().getModificationState();
        if ((state1.needsUpdate() || state1.needsDelete()) && state2.needsDelete()) {
            return new Edge(vertex1, vertex2, fkToRef ? 2 : 1);
        }
        return null;
    }

    protected Edge buildConcrete1NEdge(Vertex vertex1, Vertex vertex2) {
        ModificationState state1 = vertex1.getEnvelope().getModificationState();
        ModificationState state2 = vertex2.getEnvelope().getModificationState();
        if (state1.needsInsert()) {
            if (state2.needsUpdate() || state2.needsInsert()) {
                return new Edge(vertex1, vertex2, 3);
            }
        } else if (state1.needsDelete() && (state2.needsUpdate() || state2.needsDelete())) {
            return new Edge(vertex2, vertex1, 3);
        }
        return null;
    }

    protected Edge buildPotential1NEdge(Vertex vertex1, Vertex vertex2) {
        ModificationState state1 = vertex1.getEnvelope().getModificationState();
        ModificationState state2 = vertex2.getEnvelope().getModificationState();
        if (state1.needsDelete() && (state2.needsUpdate() || state2.needsDelete())) {
            return new Edge(vertex2, vertex1, 1);
        }
        return null;
    }

    protected Edge buildConcreteMNEdge(Vertex vertex1, Vertex vertex2) {
        ModificationState state1 = vertex1.getEnvelope().getModificationState();
        ModificationState state2 = vertex2.getEnvelope().getModificationState();
        if (state1.needsUpdate() || state1.needsInsert()) {
            if (state2.needsInsert()) {
                return new Edge(vertex2, vertex1, 3);
            }
        } else if (state1.needsDelete() && state2.needsDelete()) {
            return new Edge(vertex1, vertex2, 1);
        }
        return null;
    }

    protected Edge buildPotentialMNEdge(Vertex vertex1, Vertex vertex2) {
        ModificationState state1 = vertex1.getEnvelope().getModificationState();
        ModificationState state2 = vertex2.getEnvelope().getModificationState();
        if ((state1.needsUpdate() || state1.needsDelete()) && state2.needsDelete()) {
            return new Edge(vertex1, vertex2, 1);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Vertex {
        private ObjectEnvelope envelope;
        private boolean processed;
        private int incomingEdgeWeight;

        public Vertex(ObjectEnvelope envelope) {
            this.envelope = envelope;
            this.incomingEdgeWeight = 0;
            this.processed = false;
        }

        public ObjectEnvelope getEnvelope() {
            return this.envelope;
        }

        public void markProcessed() {
            this.processed = true;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public void resetIncomingEdgeWeight() {
            this.incomingEdgeWeight = 0;
        }

        public void incrementIncomingEdgeWeight(int weight) {
            this.incomingEdgeWeight += weight;
        }

        public int getIncomingEdgeWeight() {
            return this.incomingEdgeWeight;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("identity", (Object)this.envelope.getIdentity()).append("processed", this.processed).append("incomingEdgeWeight", this.incomingEdgeWeight).toString();
        }
    }

    private static class Edge {
        private Vertex initial;
        private Vertex terminal;
        private Identity initialIdentity;
        private Identity terminalIdentity;
        private int weight;
        private boolean knownToBeProcessed;
        private int hashCode;

        public Edge(Vertex initial, Vertex terminal, int weight) {
            this.initial = initial;
            this.terminal = terminal;
            this.initialIdentity = initial.getEnvelope().getIdentity();
            this.terminalIdentity = terminal.getEnvelope().getIdentity();
            this.weight = weight;
            this.knownToBeProcessed = false;
            this.hashCode = this.initialIdentity.hashCode() + 13 * this.terminalIdentity.hashCode();
        }

        public Vertex getInitialVertex() {
            return this.initial;
        }

        public Vertex getTerminalVertex() {
            return this.terminal;
        }

        public boolean connects(Vertex vertex) {
            return this.initial == vertex || this.terminal == vertex;
        }

        public void increaseWeightTo(int minWeight) {
            if (this.weight < minWeight) {
                this.weight = minWeight;
            }
        }

        public int getWeight() {
            return this.weight;
        }

        public boolean isProcessed() {
            boolean processed;
            if (this.knownToBeProcessed) {
                return true;
            }
            boolean bl = processed = this.initial.isProcessed() || this.terminal.isProcessed();
            if (processed) {
                this.knownToBeProcessed = true;
            }
            return processed;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Edge) {
                Edge other = (Edge)obj;
                return this.initialIdentity.equals(other.initialIdentity) && this.terminalIdentity.equals(other.terminalIdentity);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("initial", (Object)this.initialIdentity).append("terminal", (Object)this.terminalIdentity).append("weight", this.weight).append("processed", this.knownToBeProcessed).toString();
        }
    }
}

