/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.odmg.TransactionImpl;

public final class RuntimeObject {
    private final Object obj;
    private Identity identity;
    private final TransactionImpl tx;
    private Boolean isNew;
    private ClassDescriptor cld;
    private IndirectionHandler handler;

    public RuntimeObject(Object obj, TransactionImpl tx) {
        this.tx = tx;
        this.obj = obj;
        this.initCld(tx);
        this.doIsNewObjectCheck(tx);
    }

    public RuntimeObject(Object obj, TransactionImpl tx, boolean isNew) {
        this.tx = tx;
        this.obj = obj;
        this.isNew = isNew ? Boolean.TRUE : Boolean.FALSE;
        this.initCld(tx);
    }

    public RuntimeObject(Object obj, Identity identity, TransactionImpl tx, boolean isNew) {
        this.tx = tx;
        this.obj = obj;
        this.identity = identity;
        this.isNew = isNew ? Boolean.TRUE : Boolean.FALSE;
        this.initCld(tx);
    }

    public RuntimeObject(Object obj, Identity oid, ClassDescriptor cld, boolean isNew, boolean isProxy) {
        this.tx = null;
        this.obj = obj;
        this.identity = oid;
        this.isNew = isNew ? Boolean.TRUE : Boolean.FALSE;
        this.cld = cld;
        if (isProxy) {
            this.handler = ProxyHelper.getIndirectionHandler(obj);
        }
    }

    private void initCld(TransactionImpl tx) {
        IndirectionHandler handler = ProxyHelper.getIndirectionHandler(this.obj);
        if (handler != null) {
            this.handler = handler;
            this.isNew = Boolean.FALSE;
            this.identity = handler.getIdentity();
            this.cld = handler.alreadyMaterialized() ? tx.getBroker().getClassDescriptor(handler.getRealSubject().getClass()) : tx.getBroker().getClassDescriptor(this.identity.getObjectsRealClass());
        } else {
            this.cld = tx.getBroker().getClassDescriptor(this.obj.getClass());
        }
    }

    void doIsNewObjectCheck(TransactionImpl tx) {
        boolean isNew = tx.isTransient(this.cld, this.obj, null);
        this.isNew = isNew ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getObj() {
        return this.obj;
    }

    public Object getObjMaterialized() {
        return this.handler != null ? (this.handler.alreadyMaterialized() ? this.handler.getRealSubject() : null) : this.obj;
    }

    public Identity getIdentity() {
        if (this.identity == null) {
            this.identity = this.tx.getBroker().serviceIdentity().buildIdentity(this.obj);
        }
        return this.identity;
    }

    public ClassDescriptor getCld() {
        return this.cld;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isProxy() {
        return this.handler != null;
    }

    public IndirectionHandler getHandler() {
        return this.handler;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("identity", (Object)this.identity).append("isNew", (Object)this.isNew).append("isProxy", this.handler != null).append("handler", (Object)this.handler).append("tx", (Object)this.tx).toString();
    }
}

