/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.util.ListIterator;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.collections.DListEntry;
import org.apache.ojb.odmg.collections.DListImpl;

class DListIterator
implements ListIterator {
    protected ListIterator iter;
    private DListImpl dlist;
    private DListEntry currentEntry = null;

    public DListIterator(DListImpl list) {
        this.dlist = list;
        this.iter = list.getElements().listIterator();
    }

    public DListIterator(DListImpl list, int index) {
        this.dlist = list;
        this.iter = list.getElements().listIterator(index);
    }

    public void add(Object obj) {
        DListEntry entry = new DListEntry(this.dlist, obj);
        entry.setPosition(this.nextIndex() - 1);
        this.iter.add(entry);
        TransactionImpl tx = this.dlist.getTransaction();
        if (tx != null) {
            RuntimeObject rt = new RuntimeObject(entry, tx, true);
            tx.lockAndRegister(rt, 4, false, tx.getRegistrationList());
        }
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public boolean hasPrevious() {
        return this.iter.hasPrevious();
    }

    public Object next() {
        this.currentEntry = (DListEntry)this.iter.next();
        return this.currentEntry.getRealSubject();
    }

    public int nextIndex() {
        return this.iter.nextIndex();
    }

    public Object previous() {
        this.currentEntry = (DListEntry)this.iter.previous();
        return this.currentEntry.getRealSubject();
    }

    public int previousIndex() {
        return this.iter.previousIndex();
    }

    public void remove() {
        this.iter.remove();
        TransactionImpl tx = this.dlist.getTransaction();
        if (tx != null) {
            tx.markDelete(this.currentEntry);
        }
        this.currentEntry = null;
    }

    public void set(Object o) {
        throw new UnsupportedOperationException("Method is not supported");
    }
}

