/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.lock;

import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.otm.lock.ObjectLock;
import org.apache.ojb.otm.lock.UnknownIsolationException;
import org.apache.ojb.otm.lock.isolation.ReadCommittedIsolation;
import org.apache.ojb.otm.lock.isolation.ReadUncommittedIsolation;
import org.apache.ojb.otm.lock.isolation.RepeatableReadIsolation;
import org.apache.ojb.otm.lock.isolation.SerializableIsolation;
import org.apache.ojb.otm.lock.isolation.TransactionIsolation;

public class IsolationFactory {
    private static final TransactionIsolation READ_UNCOMMITTED_ISOLATION = new ReadUncommittedIsolation();
    private static final TransactionIsolation READ_COMMITTED_ISOLATION = new ReadCommittedIsolation();
    private static final TransactionIsolation REPEATABLE_READ_ISOLATION = new RepeatableReadIsolation();
    private static final TransactionIsolation SERIALIZABLE_ISOLATION = new SerializableIsolation();

    public static TransactionIsolation getIsolationLevel(PersistenceBroker pb, ObjectLock lock) {
        Class clazz = lock.getTargetIdentity().getObjectsRealClass();
        ClassDescriptor classDescriptor = pb.getClassDescriptor(clazz);
        int isolationLevel = classDescriptor.getIsolationLevel();
        TransactionIsolation isolation = null;
        switch (isolationLevel) {
            case 2: {
                isolation = READ_UNCOMMITTED_ISOLATION;
                break;
            }
            case 3: {
                isolation = READ_COMMITTED_ISOLATION;
                break;
            }
            case 5: {
                isolation = REPEATABLE_READ_ISOLATION;
                break;
            }
            case 7: {
                isolation = SERIALIZABLE_ISOLATION;
                break;
            }
            default: {
                throw new UnknownIsolationException("Isolation level " + isolationLevel + " is not supported");
            }
        }
        return isolation;
    }
}

