/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.servlet.ApplicationMap;
import org.apache.myfaces.context.servlet.CookieMap;
import org.apache.myfaces.context.servlet.InitParameterMap;
import org.apache.myfaces.context.servlet.RequestHeaderMap;
import org.apache.myfaces.context.servlet.RequestHeaderValuesMap;
import org.apache.myfaces.context.servlet.RequestMap;
import org.apache.myfaces.context.servlet.RequestParameterMap;
import org.apache.myfaces.context.servlet.RequestParameterValuesMap;
import org.apache.myfaces.context.servlet.SessionMap;
import org.apache.myfaces.util.EnumerationIterator;

public class ServletExternalContextImpl
extends ExternalContext
implements ReleaseableExternalContext {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$context$servlet$ServletExternalContextImpl == null ? (class$org$apache$myfaces$context$servlet$ServletExternalContextImpl = ServletExternalContextImpl.class$("org.apache.myfaces.context.servlet.ServletExternalContextImpl")) : class$org$apache$myfaces$context$servlet$ServletExternalContextImpl));
    private static final String INIT_PARAMETER_MAP_ATTRIBUTE = (class$org$apache$myfaces$context$servlet$InitParameterMap == null ? (class$org$apache$myfaces$context$servlet$InitParameterMap = ServletExternalContextImpl.class$("org.apache.myfaces.context.servlet.InitParameterMap")) : class$org$apache$myfaces$context$servlet$InitParameterMap).getName();
    private ServletContext _servletContext;
    private ServletRequest _servletRequest;
    private ServletResponse _servletResponse;
    private Map _applicationMap;
    private Map _sessionMap;
    private Map _requestMap;
    private Map _requestParameterMap;
    private Map _requestParameterValuesMap;
    private Map _requestHeaderMap;
    private Map _requestHeaderValuesMap;
    private Map _requestCookieMap;
    private Map _initParameterMap;
    private boolean _isHttpServletRequest;
    private String _requestServletPath;
    private String _requestPathInfo;
    private static Method setCharacterEncodingMethod = null;
    static /* synthetic */ Class class$org$apache$myfaces$context$servlet$ServletExternalContextImpl;
    static /* synthetic */ Class class$org$apache$myfaces$context$servlet$InitParameterMap;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$servlet$ServletRequest;

    public ServletExternalContextImpl(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        block6: {
            this._servletContext = servletContext;
            this._servletRequest = servletRequest;
            this._servletResponse = servletResponse;
            this._applicationMap = null;
            this._sessionMap = null;
            this._requestMap = null;
            this._requestParameterMap = null;
            this._requestParameterValuesMap = null;
            this._requestHeaderMap = null;
            this._requestHeaderValuesMap = null;
            this._requestCookieMap = null;
            this._initParameterMap = null;
            boolean bl = this._isHttpServletRequest = servletRequest != null && servletRequest instanceof HttpServletRequest;
            if (this._isHttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
                this._requestServletPath = httpServletRequest.getServletPath();
                this._requestPathInfo = httpServletRequest.getPathInfo();
                try {
                    String contentType;
                    String characterEncoding;
                    if (setCharacterEncodingMethod != null && (characterEncoding = this.lookupCharacterEncoding(contentType = httpServletRequest.getHeader("Content-Type"))) == null) {
                        HttpSession session = httpServletRequest.getSession(false);
                        if (session != null) {
                            characterEncoding = (String)session.getAttribute("javax.faces.request.charset");
                        }
                        if (characterEncoding != null) {
                            setCharacterEncodingMethod.invoke((Object)servletRequest, characterEncoding);
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block6;
                    log.warn((Object)("Failed to set character encoding " + e));
                }
            }
        }
    }

    private String lookupCharacterEncoding(String contentType) {
        String characterEncoding = null;
        if (contentType != null) {
            int charsetFind = contentType.indexOf("charset=");
            if (charsetFind != -1) {
                if (charsetFind == 0) {
                    characterEncoding = contentType.substring(8);
                } else {
                    char charBefore = contentType.charAt(charsetFind - 1);
                    if (charBefore == ';' || Character.isWhitespace(charBefore)) {
                        characterEncoding = contentType.substring(charsetFind + 8);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Incoming request has Content-Type header with character encoding " + characterEncoding));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Incoming request has Content-Type header without character encoding: " + contentType));
            }
        }
        return characterEncoding;
    }

    public void release() {
        this._servletContext = null;
        this._servletRequest = null;
        this._servletResponse = null;
        this._applicationMap = null;
        this._sessionMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._requestCookieMap = null;
        this._initParameterMap = null;
    }

    public Object getSession(boolean create) {
        if (!this._isHttpServletRequest) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return ((HttpServletRequest)this._servletRequest).getSession(create);
    }

    public Object getContext() {
        return this._servletContext;
    }

    public Object getRequest() {
        return this._servletRequest;
    }

    public Object getResponse() {
        return this._servletResponse;
    }

    public Map getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new ApplicationMap(this._servletContext);
        }
        return this._applicationMap;
    }

    public Map getSessionMap() {
        if (this._sessionMap == null) {
            if (!this._isHttpServletRequest) {
                throw new IllegalArgumentException("Only HttpServletRequest supported");
            }
            this._sessionMap = new SessionMap((HttpServletRequest)this._servletRequest);
        }
        return this._sessionMap;
    }

    public Map getRequestMap() {
        if (this._requestMap == null) {
            this._requestMap = new RequestMap(this._servletRequest);
        }
        return this._requestMap;
    }

    public Map getRequestParameterMap() {
        if (this._requestParameterMap == null) {
            this._requestParameterMap = new RequestParameterMap(this._servletRequest);
        }
        return this._requestParameterMap;
    }

    public Map getRequestParameterValuesMap() {
        if (this._requestParameterValuesMap == null) {
            this._requestParameterValuesMap = new RequestParameterValuesMap(this._servletRequest);
        }
        return this._requestParameterValuesMap;
    }

    public Iterator getRequestParameterNames() {
        final Enumeration enumer = this._servletRequest.getParameterNames();
        Iterator it = new Iterator(){

            public boolean hasNext() {
                return enumer.hasMoreElements();
            }

            public Object next() {
                return enumer.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
            }
        };
        return it;
    }

    public Map getRequestHeaderMap() {
        if (this._requestHeaderMap == null) {
            if (!this._isHttpServletRequest) {
                throw new IllegalArgumentException("Only HttpServletRequest supported");
            }
            this._requestHeaderMap = new RequestHeaderMap((HttpServletRequest)this._servletRequest);
        }
        return this._requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        if (this._requestHeaderValuesMap == null) {
            if (!this._isHttpServletRequest) {
                throw new IllegalArgumentException("Only HttpServletRequest supported");
            }
            this._requestHeaderValuesMap = new RequestHeaderValuesMap((HttpServletRequest)this._servletRequest);
        }
        return this._requestHeaderValuesMap;
    }

    public Map getRequestCookieMap() {
        if (this._requestCookieMap == null) {
            if (!this._isHttpServletRequest) {
                throw new IllegalArgumentException("Only HttpServletRequest supported");
            }
            this._requestCookieMap = new CookieMap((HttpServletRequest)this._servletRequest);
        }
        return this._requestCookieMap;
    }

    public Locale getRequestLocale() {
        return this._servletRequest.getLocale();
    }

    public String getRequestPathInfo() {
        if (!this._isHttpServletRequest) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return this._requestPathInfo;
    }

    public String getRequestContextPath() {
        if (!this._isHttpServletRequest) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return ((HttpServletRequest)this._servletRequest).getContextPath();
    }

    public String getInitParameter(String s) {
        return this._servletContext.getInitParameter(s);
    }

    public Map getInitParameterMap() {
        if (this._initParameterMap == null && (this._initParameterMap = (Map)this._servletContext.getAttribute(INIT_PARAMETER_MAP_ATTRIBUTE)) == null) {
            this._initParameterMap = new InitParameterMap(this._servletContext);
            this._servletContext.setAttribute(INIT_PARAMETER_MAP_ATTRIBUTE, (Object)this._initParameterMap);
        }
        return this._initParameterMap;
    }

    public Set getResourcePaths(String s) {
        return this._servletContext.getResourcePaths(s);
    }

    public InputStream getResourceAsStream(String s) {
        return this._servletContext.getResourceAsStream(s);
    }

    public String encodeActionURL(String s) {
        if (!this._isHttpServletRequest) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return ((HttpServletResponse)this._servletResponse).encodeURL(s);
    }

    public String encodeResourceURL(String s) {
        if (!this._isHttpServletRequest) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return ((HttpServletResponse)this._servletResponse).encodeURL(s);
    }

    public String encodeNamespace(String s) {
        return s;
    }

    public void dispatch(String requestURI) throws IOException, FacesException {
        RequestDispatcher requestDispatcher = this._servletRequest.getRequestDispatcher(requestURI);
        if (requestDispatcher == null) {
            ((HttpServletResponse)this._servletResponse).sendError(404);
            return;
        }
        try {
            requestDispatcher.forward(this._servletRequest, this._servletResponse);
        }
        catch (ServletException e) {
            if (e.getMessage() != null) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
            throw new FacesException((Throwable)e);
        }
    }

    public String getRequestServletPath() {
        if (!this._isHttpServletRequest) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return this._requestServletPath;
    }

    public String getAuthType() {
        if (!this._isHttpServletRequest) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return ((HttpServletRequest)this._servletRequest).getAuthType();
    }

    public String getRemoteUser() {
        if (!this._isHttpServletRequest) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return ((HttpServletRequest)this._servletRequest).getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        if (!this._isHttpServletRequest) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return ((HttpServletRequest)this._servletRequest).isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        if (!this._isHttpServletRequest) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return ((HttpServletRequest)this._servletRequest).getUserPrincipal();
    }

    public void log(String message) {
        this._servletContext.log(message);
    }

    public void log(String message, Throwable t) {
        this._servletContext.log(message, t);
    }

    public void redirect(String url) throws IOException {
        if (!(this._servletResponse instanceof HttpServletResponse)) {
            throw new IllegalArgumentException("Only HttpServletResponse supported");
        }
        ((HttpServletResponse)this._servletResponse).sendRedirect(url);
    }

    public Iterator getRequestLocales() {
        if (!this._isHttpServletRequest) {
            throw new IllegalArgumentException("Only HttpServletRequest supported");
        }
        return new EnumerationIterator(((HttpServletRequest)this._servletRequest).getLocales());
    }

    public URL getResource(String s) throws MalformedURLException {
        return this._servletContext.getResource(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            setCharacterEncodingMethod = (class$javax$servlet$ServletRequest == null ? (class$javax$servlet$ServletRequest = ServletExternalContextImpl.class$("javax.servlet.ServletRequest")) : class$javax$servlet$ServletRequest).getMethod("setCharacterEncoding", class$java$lang$String == null ? (class$java$lang$String = ServletExternalContextImpl.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Exception e) {
            log.warn((Object)"Detecting request character encoding is disable.");
            log.warn((Object)("Failed to obtain ServletRequest#setCharacterEncoding() method: " + e));
        }
    }
}

