/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.portlet.PortletExternalContextImpl;
import org.apache.myfaces.context.servlet.ServletExternalContextImpl;
import org.apache.myfaces.util.NullIterator;

public class ServletFacesContextImpl
extends FacesContext {
    private List _messageClientIds = null;
    private List _messages = null;
    private Application _application;
    private ReleaseableExternalContext _externalContext;
    private ResponseStream _responseStream = null;
    private ResponseWriter _responseWriter = null;
    private FacesMessage.Severity _maximumSeverity = FacesMessage.SEVERITY_INFO;
    private UIViewRoot _viewRoot;
    private boolean _renderResponse = false;
    private boolean _responseComplete = false;
    private RenderKitFactory _renderKitFactory;

    public ServletFacesContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        this(new PortletExternalContextImpl(portletContext, portletRequest, portletResponse));
    }

    public ServletFacesContextImpl(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        this(new ServletExternalContextImpl(servletContext, servletRequest, servletResponse));
    }

    private ServletFacesContextImpl(ReleaseableExternalContext externalContext) {
        this._application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this._externalContext = externalContext;
        FacesContext.setCurrentInstance((FacesContext)this);
    }

    public ExternalContext getExternalContext() {
        return (ExternalContext)this._externalContext;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        return this._maximumSeverity;
    }

    public Iterator getMessages() {
        return this._messages != null ? this._messages.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public Application getApplication() {
        return this._application;
    }

    public Iterator getClientIdsWithMessages() {
        if (this._messages == null || this._messages.isEmpty()) {
            return NullIterator.instance();
        }
        LinkedHashSet uniqueClientIds = new LinkedHashSet(this._messageClientIds);
        return uniqueClientIds.iterator();
    }

    public Iterator getMessages(String clientId) {
        if (this._messages == null) {
            return NullIterator.instance();
        }
        ArrayList lst = new ArrayList();
        for (int i = 0; i < this._messages.size(); ++i) {
            Object savedClientId = this._messageClientIds.get(i);
            if (clientId == null) {
                if (savedClientId != null) continue;
                lst.add(this._messages.get(i));
                continue;
            }
            if (!clientId.equals(savedClientId)) continue;
            lst.add(this._messages.get(i));
        }
        return lst.iterator();
    }

    public RenderKit getRenderKit() {
        if (this.getViewRoot() == null) {
            return null;
        }
        String renderKitId = this.getViewRoot().getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        return this._renderKitFactory.getRenderKit((FacesContext)this, renderKitId);
    }

    public boolean getRenderResponse() {
        return this._renderResponse;
    }

    public boolean getResponseComplete() {
        return this._responseComplete;
    }

    public void setResponseStream(ResponseStream responseStream) {
        if (responseStream == null) {
            throw new NullPointerException("responseStream");
        }
        this._responseStream = responseStream;
    }

    public ResponseStream getResponseStream() {
        return this._responseStream;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        if (responseWriter == null) {
            throw new NullPointerException("responseWriter");
        }
        this._responseWriter = responseWriter;
    }

    public ResponseWriter getResponseWriter() {
        return this._responseWriter;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        if (viewRoot == null) {
            throw new NullPointerException("viewRoot");
        }
        this._viewRoot = viewRoot;
    }

    public UIViewRoot getViewRoot() {
        return this._viewRoot;
    }

    public void addMessage(String clientId, FacesMessage message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this._messages == null) {
            this._messages = new ArrayList();
            this._messageClientIds = new ArrayList();
        }
        this._messages.add(message);
        this._messageClientIds.add(clientId != null ? clientId : null);
        FacesMessage.Severity serSeverity = message.getSeverity();
        if (serSeverity != null && serSeverity.compareTo((Object)this._maximumSeverity) > 0) {
            this._maximumSeverity = message.getSeverity();
        }
    }

    public void release() {
        if (this._externalContext != null) {
            this._externalContext.release();
            this._externalContext = null;
        }
        this._messageClientIds = null;
        this._messages = null;
        this._application = null;
        this._responseStream = null;
        this._responseWriter = null;
        this._viewRoot = null;
        FacesContext.setCurrentInstance(null);
    }

    public void renderResponse() {
        this._renderResponse = true;
    }

    public void responseComplete() {
        this._responseComplete = true;
    }

    public void setExternalContext(ReleaseableExternalContext extContext) {
        this._externalContext = extContext;
        FacesContext.setCurrentInstance((FacesContext)this);
    }
}

